/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.creative;

import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphsList;
import mchorse.metamorph.network.Dispatcher;
import mchorse.metamorph.network.common.creative.PacketAcquireMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.opengl.GL11;

public class GuiCreativeMorphsMenu
extends GuiCreativeMorphsList {
    private GuiButtonElement close;
    private GuiButtonElement acquire;
    private boolean menu;

    public GuiCreativeMorphsMenu(Minecraft mc, Consumer<AbstractMorph> callback) {
        this(mc, false, callback);
    }

    public GuiCreativeMorphsMenu(Minecraft mc, boolean menu, Consumer<AbstractMorph> callback) {
        super(mc, callback);
        this.menu = menu;
        this.acquire = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.acquire"), b -> {
            AbstractMorph cell = this.getSelected();
            if (cell != null) {
                Dispatcher.sendToServer(new PacketAcquireMorph(cell));
            }
        });
        this.close = new GuiButtonElement(mc, IKey.str((String)"X"), b -> this.exit());
        this.acquire.flex().w(60);
        this.close.flex().w(20);
        this.bar.flex().row(0).preferred(1);
        this.bar.prepend((IGuiElement)this.acquire);
        if (!this.menu) {
            this.bar.add((IGuiElement)this.close);
        }
        this.markContainer();
        this.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.acquire"), 30, () -> this.acquire.clickItself(GuiBase.getCurrent())).category(this.exitKey.category).active(() -> !this.isEditMode());
    }

    @Override
    public void exit() {
        if (!(this.menu || this.isEditMode() || this.isNested())) {
            this.finish();
            this.removeFromParent();
            GuiBase.getCurrent().setContextMenu(null);
        } else {
            super.exit();
        }
    }

    @Override
    protected boolean updateExitKey() {
        if (this.menu) {
            return this.isEditMode() || this.isNested();
        }
        return true;
    }

    @Override
    public boolean isSelectedMorphIsEditable() {
        return this.morphs.selected != null && this.morphs.selected.category == this.morphs.user.recent;
    }

    public boolean mouseClicked(GuiContext context) {
        return super.mouseClicked(context) || this.area.isInside(context.mouseX, context.mouseY);
    }

    public boolean mouseScrolled(GuiContext context) {
        return super.mouseScrolled(context) || this.area.isInside(context.mouseX, context.mouseY);
    }

    @Override
    public void draw(GuiContext context) {
        GL11.glClear((int)256);
        if (!this.menu) {
            Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)-1442840576);
        }
        super.draw(context);
    }
}

