/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.editor;

import java.util.ArrayList;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiKeybindElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;

public class GuiSettingsPanel
extends GuiMorphPanel<AbstractMorph, GuiAbstractMorph> {
    public GuiScrollElement left;
    public GuiKeybindElement keybind;
    public GuiButtonElement reset;
    public GuiTextElement displayName;
    public GuiStringListElement abilities;
    public GuiStringListElement attack;
    public GuiStringListElement action;
    public GuiTrackpadElement health;
    public GuiTrackpadElement speed;
    public GuiScrollElement right;
    public GuiToggleElement hitboxEnabled;
    public GuiTrackpadElement hitboxWidth;
    public GuiTrackpadElement hitboxHeight;
    public GuiTrackpadElement hitboxSneakingHeight;
    public GuiTrackpadElement hitboxEyePosition;
    public GuiTextElement data;
    public boolean error;

    public GuiSettingsPanel(Minecraft mc, GuiAbstractMorph editor) {
        super(mc, editor);
        this.left = new GuiScrollElement(mc);
        this.left.scroll.opposite = true;
        this.left.cancelScrollEdge();
        this.left.flex().relative((GuiElement)this).w(130).h(1.0f).column(5).vertical().stretch().scroll().height(20).padding(10);
        this.keybind = new GuiKeybindElement(mc, key -> {
            if (key == 1) {
                this.morph.keybind = -1;
                this.keybind.setKeybind(-1);
            } else {
                this.morph.keybind = key;
            }
        });
        this.keybind.tooltip(IKey.lang((String)"metamorph.gui.editor.keybind_tooltip"));
        this.reset = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.editor.reset"), button -> {
            this.morph.settings = MorphSettings.DEFAULT;
            MorphManager.INSTANCE.applySettings(this.morph);
            this.editor.setPanel(this.editor.defaultPanel);
        });
        this.displayName = new GuiTextElement(mc, string -> {
            this.morph.displayName = string;
        });
        this.abilities = new GuiStringListElement(mc, values -> {
            this.ensureCustomSettings();
            this.morph.settings.abilities.clear();
            for (String value : values) {
                IAbility ability = MorphManager.INSTANCE.abilities.get(value);
                if (ability == null) continue;
                this.morph.settings.abilities.add(ability);
            }
        });
        this.abilities.multi().background().tooltip(IKey.lang((String)"metamorph.gui.editor.abilities_tooltip"));
        this.attack = new GuiStringListElement(mc, values -> {
            this.ensureCustomSettings();
            this.morph.settings.attack = MorphManager.INSTANCE.attacks.get(values.get(0));
        });
        this.attack.background();
        this.action = new GuiStringListElement(mc, values -> {
            this.ensureCustomSettings();
            this.morph.settings.action = MorphManager.INSTANCE.actions.get(values.get(0));
        });
        this.action.background();
        this.health = new GuiTrackpadElement(mc, value -> {
            this.ensureCustomSettings();
            this.morph.settings.health = value.intValue();
        }).limit(0.0, Double.POSITIVE_INFINITY, true);
        this.speed = new GuiTrackpadElement(mc, value -> {
            this.ensureCustomSettings();
            this.morph.settings.speed = value.floatValue();
        }).limit(0.0, Double.POSITIVE_INFINITY).values((double)0.05f, (double)0.01f, (double)0.1f).increment(0.25);
        this.data = new GuiTextElement(mc, 1000000, this::editNBT);
        this.abilities.flex().h(80);
        this.attack.flex().h(80);
        this.action.flex().h(80);
        this.data.flex().relative((GuiElement)this).relative((GuiElement)this.left).x(1.0f, 10).y(1.0f, -30).wTo((IResizer)this.flex(), 1.0f, -10);
        this.left.add((IGuiElement)this.reset);
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.keybind"), (int)16).anchor(0.0f, 1.0f), this.keybind});
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.display_name"), (int)16).anchor(0.0f, 1.0f), this.displayName});
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.health"), (int)16).anchor(0.0f, 1.0f), this.health});
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.speed"), (int)16).anchor(0.0f, 1.0f), this.speed});
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.abilities"), (int)16).anchor(0.0f, 1.0f), this.abilities});
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.attack"), (int)16).anchor(0.0f, 1.0f), this.attack});
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.action"), (int)16).anchor(0.0f, 1.0f), this.action});
        this.right = new GuiScrollElement(mc);
        this.right.flex().relative((GuiElement)this).x(1.0f).w(130).h(1.0f).anchorX(1.0f).column(5).vertical().stretch().scroll().height(20).padding(10);
        this.hitboxEnabled = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.editor.hitbox.enabled"), b -> {
            this.morph.hitbox.enabled = b.isToggled();
        });
        this.hitboxWidth = new GuiTrackpadElement(mc, value -> {
            this.morph.hitbox.width = value.floatValue();
        });
        this.hitboxWidth.limit(0.01, 2.147483647E9).tooltip(IKey.lang((String)"metamorph.gui.editor.hitbox.width"));
        this.hitboxHeight = new GuiTrackpadElement(mc, value -> {
            this.morph.hitbox.height = value.floatValue();
        });
        this.hitboxHeight.limit(0.01, 2.147483647E9).tooltip(IKey.lang((String)"metamorph.gui.editor.hitbox.height"));
        this.hitboxSneakingHeight = new GuiTrackpadElement(mc, value -> {
            this.morph.hitbox.sneakingHeight = value.floatValue();
        });
        this.hitboxSneakingHeight.limit(0.01, 2.147483647E9).tooltip(IKey.lang((String)"metamorph.gui.editor.hitbox.sneaking_height"));
        this.hitboxEyePosition = new GuiTrackpadElement(mc, value -> {
            this.morph.hitbox.eye = value.floatValue();
        });
        this.hitboxEyePosition.limit(0.01, 2.147483647E9).tooltip(IKey.lang((String)"metamorph.gui.editor.hitbox.eye_tooltip"));
        this.right.add((IGuiElement)this.hitboxEnabled);
        this.right.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.hitbox.size")), this.hitboxWidth, this.hitboxHeight, this.hitboxSneakingHeight});
        this.right.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.hitbox.eye")), this.hitboxEyePosition});
        this.add(new IGuiElement[]{this.left, this.right, this.data});
    }

    private void ensureCustomSettings() {
        if (!this.morph.hasCustomSettings()) {
            MorphSettings old = this.morph.settings;
            this.morph.settings = new MorphSettings();
            this.morph.settings.copy(old);
        }
    }

    @Override
    public void fillData(AbstractMorph morph) {
        super.fillData(morph);
        this.abilities.clear();
        this.abilities.add(MorphManager.INSTANCE.abilities.keySet());
        this.attack.clear();
        this.attack.add(MorphManager.INSTANCE.attacks.keySet());
        this.action.clear();
        this.action.add(MorphManager.INSTANCE.actions.keySet());
        this.hitboxEnabled.toggled(morph.hitbox.enabled);
        this.hitboxWidth.setValue((double)morph.hitbox.width);
        this.hitboxHeight.setValue((double)morph.hitbox.height);
        this.hitboxSneakingHeight.setValue((double)morph.hitbox.sneakingHeight);
        this.hitboxEyePosition.setValue((double)morph.hitbox.eye);
    }

    public void updateNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.morph.toNBT(tag);
        this.data.setText(tag.toString());
    }

    public void editNBT(String str) {
        try {
            this.morph.fromNBT(JsonToNBT.func_180713_a((String)str));
            this.error = false;
        }
        catch (Exception e) {
            this.error = true;
        }
    }

    @Override
    public void startEditing() {
        super.startEditing();
        this.error = false;
        this.updateNBT();
        this.keybind.setKeybind(this.morph.keybind);
        this.displayName.setText(this.morph.displayName);
        this.health.setValue((double)this.morph.settings.health);
        this.speed.setValue((double)this.morph.settings.speed);
        ArrayList<String> abilities = new ArrayList<String>();
        for (IAbility ability : this.morph.settings.abilities) {
            String key = MorphSettings.getKey(MorphManager.INSTANCE.abilities, ability);
            if (key == null) continue;
            abilities.add(key);
        }
        this.abilities.sort();
        this.attack.sort();
        this.action.sort();
        this.abilities.setCurrent(abilities);
        this.attack.setCurrent((Object)MorphSettings.getKey(MorphManager.INSTANCE.attacks, this.morph.settings.attack));
        this.action.setCurrent((Object)MorphSettings.getKey(MorphManager.INSTANCE.actions, this.morph.settings.action));
    }

    public void draw(GuiContext context) {
        super.draw(context);
        if (this.data.isVisible()) {
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.panels.nbt_data", (Object[])new Object[0]), (float)this.data.area.x, (float)(this.data.area.y - 12), this.error ? -52395 : 0xFFFFFF);
        }
    }
}

