/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.EntityMorph;
import mchorse.metamorph.bodypart.GuiBodyPartEditor;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiEntityMorph
extends GuiAbstractMorph<EntityMorph> {
    public static final List<String> animals = Arrays.asList("minecraft:pig", "minecraft:chicken", "minecraft:cow", "minecraft:mooshroom", "minecraft:polar_bear", "minecraft:sheep", "minecraft:ocelot");
    public GuiBodyPartEditor bodyPart;

    public GuiEntityMorph(Minecraft mc) {
        super(mc);
        this.bodyPart = new GuiBodyPartEditor(mc, this);
        this.registerPanel(this.bodyPart, IKey.lang((String)"metamorph.gui.body_parts.parts"), Icons.LIMB);
    }

    @Override
    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof EntityMorph;
    }

    @Override
    public void startEdit(EntityMorph morph) {
        if (morph.getEntity() == null) {
            morph.setupEntity((World)this.mc.field_71441_e);
        }
        morph.parts.reinitBodyParts();
        morph.setupLimbs();
        this.bodyPart.setLimbs(morph.limbs.keySet());
        super.startEdit(morph);
    }

    @Override
    public List<Label<NBTTagCompound>> getPresets(EntityMorph morph) {
        int i;
        ArrayList<Label<NBTTagCompound>> presets = new ArrayList<Label<NBTTagCompound>>();
        String name = morph.name;
        if (animals.contains(name)) {
            this.addPreset((AbstractMorph)morph, presets, "Baby", "{Age:-1}");
        }
        if (name.equals("minecraft:sheep")) {
            this.addPreset((AbstractMorph)morph, presets, "Sheared", "{Sheared:1b}");
            this.addPreset((AbstractMorph)morph, presets, "Sheared (baby)", "{Age:-1,Sheared:1b}");
            for (i = 1; i < 16; ++i) {
                this.addPreset((AbstractMorph)morph, presets, "Colored sheep #" + i, "{Color:" + i + "}");
            }
            this.addPreset((AbstractMorph)morph, presets, "Jeb", "{CustomName:\"jeb_\"}");
            this.addPreset((AbstractMorph)morph, presets, "Baby Jeb", "{Age:-1,CustomName:\"jeb_\"}");
        }
        if (name.equals("minecraft:slime") || name.equals("minecraft:magma_cube")) {
            this.addPreset((AbstractMorph)morph, presets, "Medium", "{Size:1}");
            this.addPreset((AbstractMorph)morph, presets, "Big", "{Size:2}");
        }
        if (name.equals("minecraft:ocelot")) {
            for (i = 1; i < 4; ++i) {
                this.addPreset((AbstractMorph)morph, presets, "Cat #" + i, "{CatType:" + i + "}");
                this.addPreset((AbstractMorph)morph, presets, "Cat #" + i + " (baby)", "{CatType:" + i + ",Age:-1}");
            }
        }
        if (name.equals("minecraft:parrot")) {
            for (i = 1; i <= 4; ++i) {
                this.addPreset((AbstractMorph)morph, presets, "Parrot #" + i, "{Variant:" + i + "}");
            }
        }
        if (name.equals("minecraft:horse")) {
            for (i = 1; i <= 6; ++i) {
                this.addPreset((AbstractMorph)morph, presets, "Horse #" + i, "{Variant:" + i + "}");
            }
        }
        if (name.equals("minecraft:llama")) {
            for (i = 1; i < 4; ++i) {
                this.addPreset((AbstractMorph)morph, presets, "Llama #" + i, "{Variant:" + i + "}");
            }
        }
        if (name.equals("minecraft:bat")) {
            this.addPreset((AbstractMorph)morph, presets, "Flying", "{BatFlags:2}");
        }
        if (name.equals("minecraft:rabbit")) {
            for (i = 1; i < 6; ++i) {
                this.addPreset((AbstractMorph)morph, presets, "Rabbit #" + i, "{RabbitType:" + i + "}");
            }
            this.addPreset((AbstractMorph)morph, presets, "Toast", "{CustomName:\"Toast\"}");
        }
        if (name.equals("minecraft:zombie")) {
            this.addPreset((AbstractMorph)morph, presets, "Baby", "{IsBaby:1b}");
        }
        if (name.equals("minecraft:villager") || name.equals("minecraft:zombie_villager")) {
            this.addPreset((AbstractMorph)morph, presets, "Librarian", "{ProfessionName:\"minecraft:librarian\"}");
            this.addPreset((AbstractMorph)morph, presets, "Priest", "{ProfessionName:\"minecraft:priest\"}");
            this.addPreset((AbstractMorph)morph, presets, "Smith", "{ProfessionName:\"minecraft:smith\"}");
            this.addPreset((AbstractMorph)morph, presets, "Butcher", "{ProfessionName:\"minecraft:butcher\"}");
            this.addPreset((AbstractMorph)morph, presets, "Nitwit", "{ProfessionName:\"minecraft:nitwit\"}");
        }
        return presets;
    }

    @Override
    protected void addPreset(AbstractMorph morph, List<Label<NBTTagCompound>> list, String label, String json) {
        try {
            NBTTagCompound tag = morph.toNBT();
            NBTTagCompound entity = new NBTTagCompound();
            tag.func_82580_o("EntityData");
            entity.func_74782_a("EntityData", (NBTBase)JsonToNBT.func_180713_a((String)json));
            tag.func_179237_a(entity);
            list.add((Label<NBTTagCompound>)new Label(IKey.str((String)label), (Object)tag));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

