/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack.editors.panels;

import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import mchorse.vanilla_pack.editors.GuiLabelMorph;
import mchorse.vanilla_pack.morphs.LabelMorph;
import net.minecraft.client.Minecraft;

public class GuiLabelPanel
extends GuiMorphPanel<LabelMorph, GuiLabelMorph> {
    public GuiScrollElement element;
    public GuiTextElement label;
    public GuiTrackpadElement max;
    public GuiTrackpadElement anchorX;
    public GuiTrackpadElement anchorY;
    public GuiColorElement color;
    public GuiToggleElement lighting;
    public GuiToggleElement shadow;
    public GuiTrackpadElement shadowX;
    public GuiTrackpadElement shadowY;
    public GuiColorElement shadowColor;

    public GuiLabelPanel(Minecraft mc, GuiLabelMorph editor) {
        super(mc, editor);
        this.label = new GuiTextElement(mc, 10000, label -> {
            ((LabelMorph)this.morph).label = label;
        });
        this.max = new GuiTrackpadElement(mc, value -> {
            ((LabelMorph)this.morph).max = value.intValue();
        });
        this.max.limit(-1.0, 2.147483647E9, true).increment(10.0);
        this.anchorX = new GuiTrackpadElement(mc, value -> {
            ((LabelMorph)this.morph).anchorX = value.floatValue();
        });
        this.anchorX.values((double)0.01f);
        this.anchorY = new GuiTrackpadElement(mc, value -> {
            ((LabelMorph)this.morph).anchorY = value.floatValue();
        });
        this.anchorY.values((double)0.01f);
        this.color = new GuiColorElement(mc, value -> {
            ((LabelMorph)this.morph).color = value;
        });
        this.lighting = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.label.lighting"), button -> {
            ((LabelMorph)this.morph).lighting = button.isToggled();
        });
        this.lighting.tooltip(IKey.lang((String)"metamorph.gui.label.lighting_tooltip"));
        this.shadow = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.label.shadow"), button -> {
            ((LabelMorph)this.morph).shadow = button.isToggled();
        });
        this.shadowX = new GuiTrackpadElement(mc, value -> {
            ((LabelMorph)this.morph).shadowX = value.floatValue();
        });
        this.shadowX.limit(-100.0, 100.0).values((double)0.1f, (double)0.01f, 0.5).increment((double)0.1f);
        this.shadowY = new GuiTrackpadElement(mc, value -> {
            ((LabelMorph)this.morph).shadowY = value.floatValue();
        });
        this.shadowY.limit(-100.0, 100.0).values((double)0.1f, (double)0.01f, 0.5).increment((double)0.1f);
        this.shadowColor = new GuiColorElement(mc, value -> {
            ((LabelMorph)this.morph).shadowColor = value;
        });
        this.element = new GuiScrollElement(mc);
        this.element.scroll.opposite = true;
        this.element.flex().relative((GuiElement)this).w(120).h(1.0f).column(5).vertical().stretch().scroll().height(20).padding(10);
        this.element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.label.label"), (int)16).anchor(0.0f, 1.0f), this.label});
        this.element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.label.max_width"), (int)16).anchor(0.0f, 1.0f), this.max});
        this.element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.label.anchor"), (int)16).anchor(0.0f, 1.0f), this.anchorX, this.anchorY});
        this.element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.label.color"), (int)16).anchor(0.0f, 1.0f), this.color, this.lighting});
        this.element.add((IGuiElement)this.shadow);
        this.element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.label.shadow_offset"), (int)16).anchor(0.0f, 1.0f), this.shadowX, this.shadowY});
        this.element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"metamorph.gui.label.shadow_color"), (int)16).anchor(0.0f, 1.0f), this.shadowColor});
        this.add((IGuiElement)this.element);
    }

    @Override
    public void fillData(LabelMorph morph) {
        super.fillData(morph);
        this.label.setText(morph.label);
        this.max.setValue((double)morph.max);
        this.anchorX.setValue((double)morph.anchorX);
        this.anchorY.setValue((double)morph.anchorY);
        this.color.picker.setColor(morph.color);
        this.lighting.toggled(morph.lighting);
        this.shadow.toggled(morph.shadow);
        this.shadowX.setValue((double)morph.shadowX);
        this.shadowY.setValue((double)morph.shadowY);
        this.shadowColor.picker.setColor(morph.shadowColor);
    }
}

