/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack.morphs;

import java.util.List;
import java.util.Objects;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LabelMorph
extends AbstractMorph {
    public static final String DEFAULT_LABEL = "Lorem ipsum";
    public String label = "Lorem ipsum";
    public int max = -1;
    public float anchorX = 0.5f;
    public float anchorY = 0.5f;
    public int color = 0xFFFFFF;
    public boolean lighting = true;
    public boolean shadow = false;
    public float shadowX = 1.0f;
    public float shadowY = 1.0f;
    public int shadowColor = 0;

    public LabelMorph() {
        this.name = "label";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)10.0f);
        this.renderString();
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        double scale = 0.020833333333333332;
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        if (!this.lighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179139_a((double)scale, (double)(-scale), (double)scale);
        this.renderString();
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        if (!this.lighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderString() {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        if (this.max <= 0) {
            int w = font.func_78256_a(this.label);
            int x = -((int)((float)w * this.anchorX));
            int y = -((int)((float)font.field_78288_b * this.anchorY));
            if (this.shadow) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.shadowX, (float)this.shadowY, (float)-0.1f);
                font.func_78276_b(this.label, x, y, this.shadowColor);
                GlStateManager.func_179121_F();
            }
            font.func_78276_b(this.label, x, y, this.color);
        } else {
            int w;
            int max = MathUtils.clamp((int)this.max, (int)6, (int)Integer.MAX_VALUE);
            List labels = font.func_78271_c(this.label, max);
            int h = MathUtils.clamp((int)(labels.size() - 1), (int)0, (int)100) * 12 + font.field_78288_b;
            int y = -((int)((float)h * this.anchorY));
            if (this.shadow) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.shadowX, (float)this.shadowY, (float)-0.1f);
                for (String label : labels) {
                    w = font.func_78256_a(label);
                    font.func_78276_b(label, -((int)((float)w * this.anchorX)), y, this.shadowColor);
                    y += 12;
                }
                GlStateManager.func_179121_F();
            }
            y = -((int)((float)h * this.anchorY));
            for (String label : labels) {
                w = font.func_78256_a(label);
                font.func_78276_b(label, -((int)((float)w * this.anchorX)), y, this.color);
                y += 12;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof LabelMorph) {
            LabelMorph label = (LabelMorph)obj;
            result = result && Objects.equals(this.label, label.label);
            result = result && this.max == label.max;
            result = result && this.anchorX == label.anchorX;
            result = result && this.anchorY == label.anchorY;
            result = result && this.color == label.color;
            result = result && this.shadow == label.shadow;
            result = result && this.shadowX == label.shadowX;
            result = result && this.shadowY == label.shadowY;
            result = result && this.shadowColor == label.shadowColor;
            result = result && this.lighting == label.lighting;
        }
        return result;
    }

    @Override
    public AbstractMorph create() {
        return new LabelMorph();
    }

    @Override
    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof LabelMorph) {
            LabelMorph label = (LabelMorph)from;
            this.label = label.label;
            this.max = label.max;
            this.anchorX = label.anchorX;
            this.anchorY = label.anchorY;
            this.color = label.color;
            this.shadow = label.shadow;
            this.shadowX = label.shadowX;
            this.shadowY = label.shadowY;
            this.shadowColor = label.shadowColor;
            this.lighting = label.lighting;
        }
    }

    @Override
    public float getWidth(EntityLivingBase target) {
        return target.field_70130_N;
    }

    @Override
    public float getHeight(EntityLivingBase target) {
        return target.field_70131_O;
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (!this.label.equals(DEFAULT_LABEL)) {
            tag.func_74778_a("Label", this.label);
        }
        if (this.max > 0) {
            tag.func_74768_a("Max", this.max);
        }
        if (this.anchorX != 0.5f) {
            tag.func_74776_a("AnchorX", this.anchorX);
        }
        if (this.anchorY != 0.5f) {
            tag.func_74776_a("AnchorY", this.anchorY);
        }
        if (this.color != 0xFFFFFF) {
            tag.func_74768_a("Color", this.color);
        }
        if (this.shadow) {
            tag.func_74757_a("Shadow", this.shadow);
        }
        if (this.shadowX != 1.0f) {
            tag.func_74776_a("ShadowX", this.shadowX);
        }
        if (this.shadowY != 1.0f) {
            tag.func_74776_a("ShadowY", this.shadowY);
        }
        if (this.shadowColor != 0) {
            tag.func_74768_a("ShadowColor", this.shadowColor);
        }
        if (!this.lighting) {
            tag.func_74757_a("Lighting", this.lighting);
        }
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("Label")) {
            this.label = tag.func_74779_i("Label");
        }
        if (tag.func_74764_b("Max")) {
            this.max = tag.func_74762_e("Max");
        }
        if (tag.func_74764_b("AnchorX")) {
            this.anchorX = tag.func_74760_g("AnchorX");
        }
        if (tag.func_74764_b("AnchorY")) {
            this.anchorY = tag.func_74760_g("AnchorY");
        }
        if (tag.func_74764_b("Color")) {
            this.color = tag.func_74762_e("Color");
        }
        if (tag.func_74764_b("Shadow")) {
            this.shadow = tag.func_74767_n("Shadow");
        }
        if (tag.func_74764_b("ShadowX")) {
            this.shadowX = tag.func_74760_g("ShadowX");
        }
        if (tag.func_74764_b("ShadowY")) {
            this.shadowY = tag.func_74760_g("ShadowY");
        }
        if (tag.func_74764_b("ShadowColor")) {
            this.shadowColor = tag.func_74762_e("ShadowColor");
        }
        if (tag.func_74764_b("Lighting")) {
            this.lighting = tag.func_74767_n("Lighting");
        }
    }
}

