/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.input.multiskin;

import java.io.InputStream;
import java.nio.charset.Charset;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTexturePicker;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiCanvasEditor;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.resources.FilteredResourceLocation;
import mchorse.mclib.utils.shaders.Shader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class GuiMultiSkinEditor
extends GuiCanvasEditor {
    public static Shader shader;
    public static int uTexture;
    public static int uTextureBackground;
    public static int uSize;
    public static int uFilters;
    public static int uColor;
    public GuiTexturePicker picker;
    public FilteredResourceLocation location;
    public GuiColorElement color;
    public GuiTrackpadElement scale;
    public GuiToggleElement scaleToLargest;
    public GuiTrackpadElement shiftX;
    public GuiTrackpadElement shiftY;
    public GuiTrackpadElement pixelate;
    public GuiToggleElement erase;

    public GuiMultiSkinEditor(Minecraft mc, GuiTexturePicker picker) {
        super(mc);
        this.picker = picker;
        this.color = new GuiColorElement(mc, value -> {
            this.location.color = value;
        });
        this.color.picker.editAlpha();
        this.color.direction(Direction.TOP).tooltip(IKey.lang("mclib.gui.multiskin.color"));
        this.scale = new GuiTrackpadElement(mc, value -> {
            this.location.scale = value.floatValue();
        });
        this.scale.limit(0.0).metric();
        this.scaleToLargest = new GuiToggleElement(mc, IKey.lang("mclib.gui.multiskin.scale_to_largest"), toggle -> {
            this.location.scaleToLargest = toggle.isToggled();
        });
        this.shiftX = new GuiTrackpadElement(mc, value -> {
            this.location.shiftX = value.intValue();
        });
        this.shiftX.integer();
        this.shiftY = new GuiTrackpadElement(mc, value -> {
            this.location.shiftY = value.intValue();
        });
        this.shiftY.integer();
        this.pixelate = new GuiTrackpadElement(mc, value -> {
            this.location.pixelate = value.intValue();
        });
        this.pixelate.integer().limit(1.0);
        this.erase = new GuiToggleElement(mc, IKey.lang("mclib.gui.multiskin.erase"), toggle -> {
            this.location.erase = toggle.isToggled();
        });
        this.erase.tooltip(IKey.lang("mclib.gui.multiskin.erase_tooltip"), Direction.TOP);
        this.editor.add((IGuiElement)this.color);
        this.editor.add(Elements.label(IKey.lang("mclib.gui.multiskin.scale")).background(-2013265920), this.scale, this.scaleToLargest);
        this.editor.add(Elements.label(IKey.lang("mclib.gui.multiskin.shift")).background(-2013265920), this.shiftX, this.shiftY);
        this.editor.add(Elements.label(IKey.lang("mclib.gui.multiskin.pixelate")).background(-2013265920), this.pixelate, this.erase);
        if (shader == null) {
            try {
                String vert = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/assets/mclib/shaders/preview.vert"), (Charset)Charset.defaultCharset());
                String frag = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/assets/mclib/shaders/preview.frag"), (Charset)Charset.defaultCharset());
                shader = new Shader();
                shader.compile(vert, frag, true);
                uTexture = GL20.glGetUniformLocation((int)GuiMultiSkinEditor.shader.programId, (CharSequence)"texture");
                uTextureBackground = GL20.glGetUniformLocation((int)GuiMultiSkinEditor.shader.programId, (CharSequence)"texture_background");
                uSize = GL20.glGetUniformLocation((int)GuiMultiSkinEditor.shader.programId, (CharSequence)"size");
                uFilters = GL20.glGetUniformLocation((int)GuiMultiSkinEditor.shader.programId, (CharSequence)"filters");
                uColor = GL20.glGetUniformLocation((int)GuiMultiSkinEditor.shader.programId, (CharSequence)"color");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void resetView() {
        int w = 0;
        int h = 0;
        for (FilteredResourceLocation child : this.picker.multiRL.children) {
            this.mc.field_71446_o.func_110577_a(child.path);
            w = Math.max(w, GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096));
            h = Math.max(h, GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097));
        }
        this.setSize(w, h);
        this.color.picker.removeFromParent();
    }

    public void close() {
        this.color.picker.removeFromParent();
    }

    public void setLocation(FilteredResourceLocation location) {
        this.location = location;
        this.color.picker.setColor(location.color);
        this.scale.setValue(location.scale);
        this.scaleToLargest.toggled(location.scaleToLargest);
        this.shiftX.setValue(location.shiftX);
        this.shiftY.setValue(location.shiftY);
        this.pixelate.setValue(location.pixelate);
        this.erase.toggled(location.erase);
    }

    @Override
    protected void startDragging(GuiContext context) {
        super.startDragging(context);
        if (this.mouse == 0) {
            this.lastT = this.location.shiftX;
            this.lastV = this.location.shiftY;
        }
    }

    @Override
    protected void dragging(GuiContext context) {
        super.dragging(context);
        if (this.dragging && this.mouse == 0) {
            double dx = (double)(context.mouseX - this.lastX) / this.scaleX.getZoom();
            double dy = (double)(context.mouseY - this.lastY) / this.scaleY.getZoom();
            if (GuiScreen.func_146272_n()) {
                dx = 0.0;
            }
            if (GuiScreen.func_146271_m()) {
                dy = 0.0;
            }
            this.location.shiftX = (int)dx + (int)this.lastT;
            this.location.shiftY = (int)dy + (int)this.lastV;
            this.shiftX.setValue(this.location.shiftX);
            this.shiftY.setValue(this.location.shiftY);
        }
    }

    @Override
    protected boolean shouldDrawCanvas(GuiContext context) {
        return this.picker.multiRL != null;
    }

    @Override
    protected void drawCanvasFrame(GuiContext context) {
        for (FilteredResourceLocation child : this.picker.multiRL.children) {
            this.mc.field_71446_o.func_110577_a(child.path);
            int ow = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int oh = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            int ww = ow;
            int hh = oh;
            if (child.scaleToLargest) {
                ww = this.w;
                hh = this.h;
            } else if (child.scale != 1.0f) {
                ww = (int)((float)ww * child.scale);
                hh = (int)((float)hh * child.scale);
            }
            if (ww <= 0 || hh <= 0) continue;
            Area area = this.calculate(-this.w / 2 + child.shiftX, -this.h / 2 + child.shiftY, -this.w / 2 + child.shiftX + ww, -this.h / 2 + child.shiftY + hh);
            if (child == this.picker.currentFRL) {
                Gui.func_73734_a((int)area.x, (int)area.y, (int)area.ex(), (int)area.ey(), (int)0x44FF0000);
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
            }
            ColorUtils.bindColor(child.color);
            if (child.pixelate > 1 || child.erase) {
                shader.bind();
                GL20.glUniform1i((int)uTexture, (int)0);
                GL20.glUniform1i((int)uTextureBackground, (int)5);
                GL20.glUniform2f((int)uSize, (float)ow, (float)oh);
                GL20.glUniform4f((int)uFilters, (float)child.pixelate, (float)(child.erase ? 1.0f : 0.0f), (float)0.0f, (float)0.0f);
                GL20.glUniform4f((int)uColor, (float)ColorUtils.COLOR.r, (float)ColorUtils.COLOR.g, (float)ColorUtils.COLOR.b, (float)ColorUtils.COLOR.a);
            }
            GlStateManager.func_179138_g((int)33989);
            this.mc.field_71446_o.func_110577_a(Icons.ICONS);
            GlStateManager.func_179138_g((int)33984);
            GuiDraw.drawBillboard(area.x, area.y, 0, 0, area.w, area.h, area.w, area.h);
            if (child.pixelate <= 1 && !child.erase) continue;
            shader.unbind();
        }
    }
}

