/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.mclib;

import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiDopeSheet;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiGraphView;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiKeyframesEditor;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiSheet;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.mclib.GuiDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.keyframes.Keyframe;
import mchorse.mclib.utils.keyframes.KeyframeChannel;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;
import mchorse.mclib.utils.wav.Wave;
import mchorse.mclib.utils.wav.WavePlayer;
import mchorse.mclib.utils.wav.WaveReader;
import mchorse.mclib.utils.wav.Waveform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class GuiDebugPanel
extends GuiDashboardPanel {
    public GuiKeyframesEditor<GuiDopeSheet> dopesheet;
    public GuiKeyframesEditor<GuiGraphView> graph;
    public GuiModelRenderer renderer;
    public GuiButtonElement play;
    public GuiSlotElement slot;
    public GuiTransformations top;
    public GuiTransformations bottom;
    private WavePlayer player;
    private Waveform wave;

    public GuiDebugPanel(Minecraft mc, GuiDashboard dashboard) {
        super(mc, dashboard);
        this.dopesheet = new GuiKeyframesEditor<GuiDopeSheet>(mc){

            @Override
            protected GuiDopeSheet createElement(Minecraft mc) {
                return new GuiDopeSheet(mc, this::fillData);
            }
        };
        this.graph = new GuiKeyframesEditor<GuiGraphView>(mc){

            @Override
            protected GuiGraphView createElement(Minecraft mc) {
                return new GuiGraphView(mc, this::fillData);
            }
        };
        this.slot = new GuiSlotElement(mc, 0, t -> {});
        this.slot.flex().relative(this).y(10).x(1.0f, -10).anchorX(1.0f);
        this.slot.stack = new ItemStack(Items.field_151168_bH, 42);
        KeyframeChannel channel = new KeyframeChannel();
        channel.insert(0L, 10.0);
        Keyframe a = channel.get(channel.insert(20L, 10.0));
        channel.get(channel.insert(80L, 0.0));
        channel.get(channel.insert(100L, 0.0));
        a.interp = KeyframeInterpolation.BEZIER;
        for (int i = 0; i < 5; ++i) {
            KeyframeChannel c = new KeyframeChannel();
            c.copy(channel);
            ((GuiDopeSheet)this.dopesheet.graph).sheets.add(new GuiSheet(IKey.str("Test " + i), new Color((float)Math.random(), (float)Math.random(), (float)Math.random()).getRGBColor(), c));
        }
        ((GuiDopeSheet)this.dopesheet.graph).duration = 100;
        ((GuiGraphView)this.graph.graph).setChannel(channel, 35071);
        ((GuiGraphView)this.graph.graph).duration = 100;
        this.dopesheet.flex().relative(this).y(0).wh(1.0f, 0.5f);
        this.graph.flex().relative(this).y(0.5f).wh(1.0f, 0.5f);
        this.renderer = new GuiModelRenderer(mc){

            @Override
            protected void drawUserModel(GuiContext context) {
            }
        };
        this.play = new GuiButtonElement(mc, IKey.str("Play me!"), this::play);
        this.top = new GuiTransformations(mc);
        this.top.fillR(90.0, 0.0, -90.0);
        this.top.fillT(1.0, 5.0, -2.0);
        this.bottom = new GuiTransformations(mc);
        this.bottom.fillT(0.0, -2.0, 1.5);
        this.bottom.fillS(2.0, 2.0, 2.0);
        this.bottom.fillR(0.0, 180.0, 0.0);
        this.top.flex().relative(this).x(0.5f).y(10).wh(190, 70).anchor(0.5f, 0.0f);
        this.bottom.flex().relative(this).x(0.5f).y(1.0f, -10).wh(190, 70).anchor(0.5f, 1.0f);
        this.renderer.flex().relative(this).wh(1.0f, 1.0f);
        this.play.flex().relative(this).xy(10, 10).w(80);
        this.add(this.top, this.bottom);
    }

    private void play(GuiButtonElement button) {
        try {
            WaveReader reader;
            Wave data;
            if (this.player != null) {
                this.player.delete();
            }
            if (this.wave != null) {
                this.wave.delete();
            }
            if ((data = (reader = new WaveReader()).read(this.getClass().getResourceAsStream("/assets/mclib/8.wav"))).getBytesPerSample() > 2) {
                data = data.convertTo16();
            }
            this.player = new WavePlayer().initialize(data);
            this.player.play();
            this.wave = new Waveform();
            this.wave.generate(data, 20, 150);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void resize() {
        super.resize();
        ((GuiDopeSheet)this.dopesheet.graph).resetView();
        ((GuiGraphView)this.graph.graph).resetView();
    }

    @Override
    public void draw(GuiContext context) {
        if (this.player != null && !this.player.isPlaying()) {
            this.player.delete();
            this.player = null;
        }
        super.draw(context);
        if (this.wave != null) {
            int w = this.wave.getWidth();
            int h = this.wave.getHeight();
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.wave.draw(this.area.x + 10, this.area.my() - h / 2 - 2, 0, 0, w, h);
            GlStateManager.func_179131_c((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            this.wave.draw(this.area.x + 10, this.area.my() - h / 2, 0, 0, 200, h);
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            this.wave.draw(this.area.x + 10 + 200, this.area.my() - h / 2, 200, 0, 200, h);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.wave.draw(this.area.x + 10 + 400, this.area.my() - h / 2, 400, 0, w, h);
        }
    }
}

