/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils;

import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.ScrollDirection;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScrollArea
extends Area {
    public int scrollItemSize;
    public int scrollSize;
    public int scroll;
    public boolean dragging;
    public int scrollSpeed = 10;
    public ScrollDirection direction = ScrollDirection.VERTICAL;
    public boolean opposite;
    public int scrollbarWidth = -1;
    public boolean cancelScrollEdge = false;

    public ScrollArea(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public ScrollArea() {
    }

    public ScrollArea(int itemSize) {
        this.scrollItemSize = itemSize;
    }

    public int getScrollbarWidth() {
        return this.scrollbarWidth <= 0 ? McLib.scrollbarWidth.get() : this.scrollbarWidth;
    }

    public void setSize(int items) {
        this.scrollSize = items * this.scrollItemSize;
    }

    public void scrollBy(int x) {
        this.scroll += x;
        this.clamp();
    }

    public void scrollTo(int x) {
        this.scroll = x;
        this.clamp();
    }

    public void scrollIntoView(int x) {
        this.scrollIntoView(x, this.scrollItemSize);
    }

    public void scrollIntoView(int x, int bottomOffset) {
        if (this.scroll > x) {
            this.scrollTo(x);
        } else if (x > this.scroll + this.direction.getSide(this) - bottomOffset) {
            this.scrollTo(x - this.direction.getSide(this) + bottomOffset);
        }
    }

    public void clamp() {
        int size = this.direction.getSide(this);
        this.scroll = this.scrollSize <= size ? 0 : MathUtils.clamp(this.scroll, 0, this.scrollSize - size);
    }

    public int getIndex(int x, int y) {
        int axis = this.direction.getScroll(this, x, y);
        int index = axis / this.scrollItemSize;
        if (axis < 0) {
            return -1;
        }
        if (axis > this.scrollSize) {
            return -2;
        }
        return index > this.scrollSize / this.scrollItemSize ? -1 : index;
    }

    public int getScrollBar(int size) {
        int maxSize = this.direction.getSide(this);
        if (this.scrollSize < size) {
            return 0;
        }
        return (int)((1.0f - (float)(this.scrollSize - maxSize) / (float)this.scrollSize) * (float)size);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(GuiContext context) {
        return this.mouseClicked(context.mouseX, context.mouseY);
    }

    public boolean mouseClicked(int x, int y) {
        boolean isInside;
        boolean bl = isInside = this.isInside(x, y) && this.scrollSize > this.h;
        if (isInside) {
            int scrollbar = this.getScrollbarWidth();
            if (this.opposite) {
                isInside = this.direction == ScrollDirection.VERTICAL ? x <= this.x + scrollbar : y <= this.y + scrollbar;
            } else {
                boolean bl2 = this.direction == ScrollDirection.VERTICAL ? x >= this.ex() - scrollbar : (isInside = y >= this.ey() - scrollbar);
            }
        }
        if (isInside) {
            this.dragging = true;
        }
        return isInside;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseScroll(GuiContext context) {
        return this.mouseScroll(context.mouseX, context.mouseY, context.mouseWheel);
    }

    public boolean mouseScroll(int x, int y, int scroll) {
        boolean isInside = this.isInside(x, y);
        int lastScroll = this.scroll;
        if (isInside) {
            this.scrollBy((int)Math.copySign(this.scrollSpeed, scroll));
        }
        return isInside && (this.cancelScrollEdge || lastScroll != this.scroll);
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseReleased(GuiContext context) {
        this.mouseReleased(context.mouseX, context.mouseY);
    }

    public void mouseReleased(int x, int y) {
        this.dragging = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void drag(GuiContext context) {
        this.drag(context.mouseX, context.mouseY);
    }

    public void drag(int x, int y) {
        if (this.dragging) {
            float progress = this.direction.getProgress(this, x, y);
            this.scrollTo((int)(progress * (float)(this.scrollSize - this.direction.getSide(this) + this.getScrollbarWidth())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawScrollbar() {
        int side = this.direction.getSide(this);
        if (this.scrollSize <= side) {
            return;
        }
        int scrollbar = this.getScrollbarWidth();
        int h = this.getScrollBar(side / 2);
        int x = this.opposite ? this.x : this.ex() - scrollbar;
        int y = this.y + (int)((float)this.scroll / (float)(this.scrollSize - this.h) * (float)(this.h - h));
        int rx = x + scrollbar;
        int ry = y + h;
        if (this.direction == ScrollDirection.HORIZONTAL) {
            y = this.opposite ? this.y : this.ey() - scrollbar;
            x = this.x + (int)((float)this.scroll / (float)(this.scrollSize - this.w) * (float)(this.w - h));
            rx = x + h;
            ry = y + scrollbar;
        }
        if (McLib.scrollbarFlat.get()) {
            Gui.func_73734_a((int)x, (int)y, (int)rx, (int)ry, (int)-6250336);
        } else {
            int color = McLib.scrollbarShadow.get();
            GuiDraw.drawDropShadow(x, y, rx, ry, 5, color, ColorUtils.setAlpha(color, 0.0f));
            Gui.func_73734_a((int)x, (int)y, (int)rx, (int)ry, (int)-1118482);
            Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)rx, (int)ry, (int)-10066330);
            Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(rx - 1), (int)(ry - 1), (int)-5592406);
        }
    }
}

