/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config;

import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import mchorse.mclib.config.ConfigCategory;
import mchorse.mclib.config.ConfigThread;
import mchorse.mclib.config.json.ConfigParser;
import mchorse.mclib.config.values.IConfigValue;
import mchorse.mclib.utils.JsonUtils;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;

public class Config {
    public final String id;
    public final File file;
    public final Map<String, ConfigCategory> categories = new LinkedHashMap<String, ConfigCategory>();

    public Config(String id, File file) {
        this.id = id;
        this.file = file;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTitle() {
        return I18n.func_135052_a((String)this.getTitleKey(), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTitleKey() {
        return this.id + ".config.title";
    }

    @SideOnly(value=Side.CLIENT)
    public String getCategoryTitle(String category) {
        return I18n.func_135052_a((String)this.getCategoryTitleKey(category), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getCategoryTitleKey(String category) {
        return this.id + ".config." + category + ".title";
    }

    @SideOnly(value=Side.CLIENT)
    public String getCategoryTooltip(String category) {
        return I18n.func_135052_a((String)this.getCategoryTooltipKey(category), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getCategoryTooltipKey(String category) {
        return this.id + ".config." + category + ".tooltip";
    }

    @SideOnly(value=Side.CLIENT)
    public String getValueTitle(String category, String value) {
        return I18n.func_135052_a((String)this.getValueTitleKey(category, value), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getValueTitleKey(String category, String value) {
        return this.id + ".config." + category + "." + value;
    }

    @SideOnly(value=Side.CLIENT)
    public String getValueTooltip(String category, String value) {
        return I18n.func_135052_a((String)this.getValueTooltipKey(category, value), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getValueTooltipKey(String category, String value) {
        return this.id + ".config.comments." + category + "." + value;
    }

    public IConfigValue get(String category, String value) {
        ConfigCategory cat = this.categories.get(category);
        if (cat != null) {
            return cat.values.get(value);
        }
        return null;
    }

    public void saveLater() {
        ConfigThread.add(this);
    }

    public void save() {
        this.save(this.file);
    }

    public boolean save(File file) {
        try {
            FileUtils.writeStringToFile((File)this.file, (String)this.toJSON(), (Charset)Charset.defaultCharset());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String toJSON() {
        return JsonUtils.jsonToPretty((JsonElement)ConfigParser.toJson(this));
    }
}

