/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.gui;

import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiLabelListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.mclib.GuiDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.ScrollDirection;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.Config;
import mchorse.mclib.config.ConfigCategory;
import mchorse.mclib.config.values.IConfigValue;
import mchorse.mclib.utils.Direction;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiConfig
extends GuiDashboardPanel {
    public GuiIconElement reload;
    public GuiLabelListElement<String> mods;
    public GuiScrollElement options;
    private Config config;
    private IKey title = IKey.lang("mclib.gui.config.title");

    public GuiConfig(Minecraft mc, GuiDashboard dashboard) {
        super(mc, dashboard);
        this.reload = new GuiIconElement(mc, Icons.REFRESH, button -> this.reload());
        this.reload.tooltip(IKey.lang("mclib.gui.config.reload_tooltip"), Direction.BOTTOM);
        this.mods = new GuiLabelListElement(mc, mod -> this.selectConfig((String)((Label)mod.get((int)0)).value));
        this.options = new GuiScrollElement(mc, ScrollDirection.HORIZONTAL);
        this.options.scroll.scrollSpeed = 51;
        this.reload.flex().relative(this).set(96.0f, 12.0f, 16.0f, 16.0f);
        this.mods.flex().relative(this).set(10.0f, 35.0f, 100.0f, 0.0f).h(1.0f, -45);
        this.options.flex().relative(this).set(120.0f, 0.0f, 0.0f, 0.0f).w(1.0f, -120).h(1.0f);
        this.options.flex().column(5).scroll().width(240).height(20).padding(15);
        for (Config config : McLib.proxy.configs.modules.values()) {
            this.mods.add(IKey.lang(config.getTitleKey()), config.id);
        }
        this.mods.sort();
        this.add(this.reload, this.mods, this.options);
        this.selectConfig("mclib");
        this.markContainer();
    }

    private void reload() {
        McLib.proxy.configs.reload();
        this.refresh();
    }

    private void selectConfig(String mod) {
        this.mods.setCurrentValue(mod);
        this.config = McLib.proxy.configs.modules.get(mod);
        this.refresh();
    }

    public void refresh() {
        this.options.removeAll();
        boolean first = true;
        for (ConfigCategory category : this.config.categories.values()) {
            if (!category.isVisible()) continue;
            GuiLabel label = Elements.label(IKey.lang(category.getTitleKey()), 40).anchor(0.0f, 1.0f).background(-2013265920);
            label.flex().w(this.font.func_78256_a(label.label.get()));
            if (first) {
                label.anchor(0.0f, 0.0f).flex().h(0.0f, this.font.field_78288_b);
            }
            this.options.add((IGuiElement)label.tooltip(IKey.lang(category.getTooltipKey()), Direction.BOTTOM));
            for (IConfigValue value : category.values.values()) {
                if (!value.isVisible()) continue;
                for (GuiElement element : value.getFields(this.mc, this)) {
                    this.options.add((IGuiElement)element);
                }
            }
            first = false;
        }
        this.resize();
    }

    @Override
    public void draw(GuiContext context) {
        this.mods.area.draw(-587202560, -10, -35, -10, -10);
        this.font.func_175063_a(this.title.get(), (float)(this.area.x + 10), (float)(this.area.y + 20 - this.font.field_78288_b / 2), 0xFFFFFF);
        super.draw(context);
    }
}

