/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config;

import com.terraformersmc.modmenu.config.option.BooleanConfigOption;
import com.terraformersmc.modmenu.config.option.EnumConfigOption;
import com.terraformersmc.modmenu.config.option.OptionConvertable;
import com.terraformersmc.modmenu.config.option.StringSetConfigOption;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.class_7172;

public class ModMenuConfig {
    public static final EnumConfigOption<Sorting> SORTING = new EnumConfigOption<Sorting>("sorting", Sorting.ASCENDING);
    public static final BooleanConfigOption COUNT_LIBRARIES = new BooleanConfigOption("count_libraries", true);
    public static final BooleanConfigOption COMPACT_LIST = new BooleanConfigOption("compact_list", false);
    public static final BooleanConfigOption COUNT_CHILDREN = new BooleanConfigOption("count_children", true);
    public static final EnumConfigOption<ModsButtonStyle> MODS_BUTTON_STYLE = new EnumConfigOption<ModsButtonStyle>("mods_button_style", ModsButtonStyle.CLASSIC);
    public static final BooleanConfigOption COUNT_HIDDEN_MODS = new BooleanConfigOption("count_hidden_mods", true);
    public static final EnumConfigOption<ModCountLocation> MOD_COUNT_LOCATION = new EnumConfigOption<ModCountLocation>("mod_count_location", ModCountLocation.TITLE_SCREEN);
    public static final BooleanConfigOption HIDE_MOD_LINKS = new BooleanConfigOption("hide_mod_links", false);
    public static final BooleanConfigOption SHOW_LIBRARIES = new BooleanConfigOption("show_libraries", false);
    public static final BooleanConfigOption HIDE_MOD_LICENSE = new BooleanConfigOption("hide_mod_license", false);
    public static final BooleanConfigOption HIDE_BADGES = new BooleanConfigOption("hide_badges", false);
    public static final BooleanConfigOption HIDE_MOD_CREDITS = new BooleanConfigOption("hide_mod_credits", false);
    public static final BooleanConfigOption EASTER_EGGS = new BooleanConfigOption("easter_eggs", true);
    public static final BooleanConfigOption MODIFY_TITLE_SCREEN = new BooleanConfigOption("modify_title_screen", true);
    public static final BooleanConfigOption MODIFY_GAME_MENU = new BooleanConfigOption("modify_game_menu", true);
    public static final BooleanConfigOption HIDE_CONFIG_BUTTONS = new BooleanConfigOption("hide_config_buttons", false);
    public static final StringSetConfigOption HIDDEN_MODS = new StringSetConfigOption("hidden_mods", new HashSet<String>());

    public static class_7172<?>[] asOptions() {
        ArrayList options = new ArrayList();
        for (Field field : ModMenuConfig.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !OptionConvertable.class.isAssignableFrom(field.getType()) || field.getName().equals("HIDE_CONFIG_BUTTONS") || field.getName().equals("MODIFY_TITLE_SCREEN") || field.getName().equals("MODIFY_GAME_MENU")) continue;
            try {
                options.add(((OptionConvertable)field.get(null)).asOption());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return (class_7172[])options.stream().toArray(class_7172[]::new);
    }

    public static enum Sorting {
        ASCENDING(Comparator.comparing(mod -> mod.getName().toLowerCase(Locale.ROOT))),
        DESCENDING(ASCENDING.getComparator().reversed());

        Comparator<Mod> comparator;

        private Sorting(Comparator<Mod> comparator) {
            this.comparator = comparator;
        }

        public Comparator<Mod> getComparator() {
            return this.comparator;
        }
    }

    public static enum ModsButtonStyle {
        CLASSIC(false),
        REPLACE_REALMS(true),
        SHRINK(false),
        ICON(false);

        private final boolean titleScreenOnly;

        private ModsButtonStyle(boolean titleScreenOnly) {
            this.titleScreenOnly = titleScreenOnly;
        }

        public ModsButtonStyle forGameMenu() {
            if (this.titleScreenOnly) {
                return CLASSIC;
            }
            return this;
        }
    }

    public static enum ModCountLocation {
        TITLE_SCREEN(true, false),
        MODS_BUTTON(false, true),
        TITLE_SCREEN_AND_MODS_BUTTON(true, true),
        NONE(false, false);

        private final boolean titleScreen;
        private final boolean modsButton;

        private ModCountLocation(boolean titleScreen, boolean modsButton) {
            this.titleScreen = titleScreen;
            this.modsButton = modsButton;
        }

        public boolean isOnTitleScreen() {
            return this.titleScreen;
        }

        public boolean isOnModsButton() {
            return this.modsButton;
        }
    }
}

