/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.gui.widget.DescriptionListWidget;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.ModMenuTexturedButtonWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.TranslationUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModsScreen
extends class_437 {
    private static final class_2960 FILTERS_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/filters_button.png");
    private static final class_2960 CONFIGURE_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/configure_button.png");
    private static final class_2561 TOGGLE_FILTER_OPTIONS = class_2561.method_43471((String)"modmenu.toggleFilterOptions");
    private static final class_2561 CONFIGURE = class_2561.method_43471((String)"modmenu.configure");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu");
    private class_342 searchBox;
    private DescriptionListWidget descriptionListWidget;
    private final class_437 previousScreen;
    private ModListWidget modList;
    private ModListEntry selected;
    private ModBadgeRenderer modBadgeRenderer;
    private double scrollPercent = 0.0;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();
    public final Map<String, Boolean> modHasConfigScreen = new HashMap<String, Boolean>();

    public ModsScreen(class_437 previousScreen) {
        super((class_2561)class_2561.method_43471((String)"modmenu.title"));
        this.previousScreen = previousScreen;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.modList.method_25405(mouseX, mouseY)) {
            return this.modList.method_25401(mouseX, mouseY, amount);
        }
        if (this.descriptionListWidget.method_25405(mouseX, mouseY)) {
            return this.descriptionListWidget.method_25401(mouseX, mouseY, amount);
        }
        return false;
    }

    public void method_25393() {
        this.searchBox.method_1865();
    }

    protected void method_25426() {
        this.paneY = 48;
        this.paneWidth = this.field_22789 / 2 - 8;
        this.rightPaneX = this.field_22789 - this.paneWidth;
        int searchBoxWidth = this.paneWidth - 32 - 22;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - 11;
        this.searchBox = new class_342(this.field_22793, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, (class_2561)class_2561.method_43471((String)"modmenu.search"));
        this.searchBox.method_1863(string_1 -> this.modList.filter((String)string_1, false));
        this.modList = new ModListWidget(this.field_22787, this.paneWidth, this.field_22790, this.paneY + 19, this.field_22790 - 36, ModMenuConfig.COMPACT_LIST.getValue() ? 23 : 36, this.searchBox.method_1882(), this.modList, this);
        this.modList.method_25333(0);
        this.modList.reloadFilters();
        for (Mod mod : ModMenu.MODS.values()) {
            if (this.modHasConfigScreen.containsKey(mod.getId())) continue;
            try {
                class_437 configScreen = ModMenu.getConfigScreen(mod.getId(), this);
                this.modHasConfigScreen.put(mod.getId(), configScreen != null);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.warn("The '" + mod.getId() + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
                this.modHasConfigScreen.put(mod.getId(), false);
            }
            catch (Throwable e) {
                LOGGER.error("Error from mod '" + mod.getId() + "'", e);
                this.modHasConfigScreen.put(mod.getId(), false);
            }
        }
        Objects.requireNonNull(this.field_22793);
        this.descriptionListWidget = new DescriptionListWidget(this.field_22787, this.paneWidth, this.field_22790, this.paneY + 60, this.field_22790 - 36, 9 + 1, this);
        this.descriptionListWidget.method_25333(this.rightPaneX);
        ModMenuTexturedButtonWidget configureButton = new ModMenuTexturedButtonWidget(this.field_22789 - 24, this.paneY, 20, 20, 0, 0, CONFIGURE_BUTTON_LOCATION, 32, 64, button -> {
            String modid = Objects.requireNonNull(this.selected).getMod().getId();
            if (this.modHasConfigScreen.get(modid).booleanValue()) {
                class_437 configScreen = ModMenu.getConfigScreen(modid, this);
                this.field_22787.method_1507(configScreen);
            } else {
                button.field_22763 = false;
            }
        }){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                if (ModsScreen.this.selected != null) {
                    String modid = ModsScreen.this.selected.getMod().getId();
                    this.field_22763 = ModsScreen.this.modHasConfigScreen.get(modid);
                } else {
                    this.field_22763 = false;
                }
                this.field_22764 = this.field_22763;
                super.method_25394(matrices, mouseX, mouseY, delta);
            }

            @Override
            public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
                RenderSystem.setShader(class_757::method_34543);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.method_25359(matrices, mouseX, mouseY, delta);
            }
        };
        configureButton.method_47400(class_7919.method_47407((class_2561)CONFIGURE));
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        class_4185 websiteButton = new class_4185(this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, (class_2561)class_2561.method_43471((String)"modmenu.website"), button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            this.field_22787.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670(mod.getWebsite());
                }
                this.field_22787.method_1507((class_437)this);
            }, mod.getWebsite(), false));
        }, Supplier::get){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                this.field_22764 = ModsScreen.this.selected != null;
                this.field_22763 = this.field_22764 && ModsScreen.this.selected.getMod().getWebsite() != null;
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        };
        class_4185 issuesButton = new class_4185(this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, (class_2561)class_2561.method_43471((String)"modmenu.issues"), button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            this.field_22787.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670(mod.getIssueTracker());
                }
                this.field_22787.method_1507((class_437)this);
            }, mod.getIssueTracker(), false));
        }, Supplier::get){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                this.field_22764 = ModsScreen.this.selected != null;
                this.field_22763 = this.field_22764 && ModsScreen.this.selected.getMod().getIssueTracker() != null;
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        };
        this.method_25429((class_364)this.searchBox);
        ModMenuTexturedButtonWidget filtersButton = new ModMenuTexturedButtonWidget(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, FILTERS_BUTTON_LOCATION, 32, 64, button -> {
            this.filterOptionsShown = !this.filterOptionsShown;
        }, TOGGLE_FILTER_OPTIONS);
        filtersButton.method_47400(class_7919.method_47407((class_2561)TOGGLE_FILTER_OPTIONS));
        this.method_37063((class_364)filtersButton);
        class_2561 showLibrariesText = ModMenuConfig.SHOW_LIBRARIES.getButtonText();
        class_2561 sortingText = ModMenuConfig.SORTING.getButtonText();
        int showLibrariesWidth = this.field_22793.method_27525((class_5348)showLibrariesText) + 20;
        int sortingWidth = this.field_22793.method_27525((class_5348)sortingText) + 20;
        this.filtersWidth = showLibrariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        this.method_37063((class_364)new class_4185(this.filtersX, 45, sortingWidth, 20, sortingText, button -> {
            ModMenuConfig.SORTING.cycleValue();
            ModMenuConfigManager.save();
            this.modList.reloadFilters();
        }, Supplier::get){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                matrices.method_46416(0.0f, 0.0f, 1.0f);
                this.field_22764 = ModsScreen.this.filterOptionsShown;
                this.method_25355(ModMenuConfig.SORTING.getButtonText());
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        });
        this.method_37063((class_364)new class_4185(this.filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText, button -> {
            ModMenuConfig.SHOW_LIBRARIES.toggleValue();
            ModMenuConfigManager.save();
            this.modList.reloadFilters();
        }, Supplier::get){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                matrices.method_46416(0.0f, 0.0f, 1.0f);
                this.field_22764 = ModsScreen.this.filterOptionsShown;
                this.method_25355(ModMenuConfig.SHOW_LIBRARIES.getButtonText());
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        });
        this.method_25429((class_364)this.modList);
        if (!ModMenuConfig.HIDE_CONFIG_BUTTONS.getValue()) {
            this.method_37063((class_364)configureButton);
        }
        this.method_37063((class_364)websiteButton);
        this.method_37063((class_364)issuesButton);
        this.method_25429((class_364)this.descriptionListWidget);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"modmenu.modsFolder"), button -> class_156.method_668().method_672(new File(FabricLoader.getInstance().getGameDir().toFile(), "mods"))).method_46433(this.field_22789 / 2 - 154, this.field_22790 - 28).method_46437(150, 20).method_46435(Supplier::get).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.field_22787.method_1507(this.previousScreen)).method_46433(this.field_22789 / 2 + 4, this.field_22790 - 28).method_46437(150, 20).method_46435(Supplier::get).method_46431());
        this.method_20085((class_364)this.searchBox);
        this.init = true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers) || this.searchBox.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int keyCode) {
        return this.searchBox.method_25400(chr, keyCode);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.method_25394(matrices, mouseX, mouseY, delta);
        }
        this.modList.method_25394(matrices, mouseX, mouseY, delta);
        this.searchBox.method_25394(matrices, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        ModsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.modList.getWidth() / 2), (int)8, (int)0xFFFFFF);
        class_5250 class_52502 = class_2561.method_43471((String)"modmenu.dropInfo.line1").method_27692(class_124.field_1080);
        int n = this.field_22789 - this.modList.getWidth() / 2;
        int n2 = this.paneY / 2;
        Objects.requireNonNull(this.field_22787.field_1772);
        ModsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_52502, (int)n, (int)(n2 - 9 - 1), (int)0xFFFFFF);
        ModsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"modmenu.dropInfo.line2").method_27692(class_124.field_1080), (int)(this.field_22789 - this.modList.getWidth() / 2), (int)(this.paneY / 2 + 1), (int)0xFFFFFF);
        class_2561 fullModCount = this.computeModCountText(true);
        if (this.updateFiltersX()) {
            if (this.filterOptionsShown) {
                if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.field_22793.method_27525((class_5348)fullModCount) <= this.filtersX - 5) {
                    this.field_22793.method_27528(matrices, fullModCount.method_30937(), (float)this.searchBoxX, 52.0f, 0xFFFFFF);
                } else {
                    this.field_22793.method_27528(matrices, this.computeModCountText(false).method_30937(), (float)this.searchBoxX, 46.0f, 0xFFFFFF);
                    this.field_22793.method_27528(matrices, this.computeLibraryCountText().method_30937(), (float)this.searchBoxX, 57.0f, 0xFFFFFF);
                }
            } else if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.field_22793.method_27525((class_5348)fullModCount) <= this.modList.getWidth() - 5) {
                this.field_22793.method_27528(matrices, fullModCount.method_30937(), (float)this.searchBoxX, 52.0f, 0xFFFFFF);
            } else {
                this.field_22793.method_27528(matrices, this.computeModCountText(false).method_30937(), (float)this.searchBoxX, 46.0f, 0xFFFFFF);
                this.field_22793.method_27528(matrices, this.computeLibraryCountText().method_30937(), (float)this.searchBoxX, 57.0f, 0xFFFFFF);
            }
        }
        if (selectedEntry != null) {
            List<String> names;
            class_5250 name;
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            if ("java".equals(mod.getId())) {
                DrawingUtil.drawRandomVersionBackground(mod, matrices, x, this.paneY, 32, 32);
            }
            this.selected.bindIconTexture();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            ModsScreen.method_25290((class_4587)matrices, (int)x, (int)this.paneY, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.disableBlend();
            Objects.requireNonNull(this.field_22793);
            int lineSpacing = 9 + 1;
            int imageOffset = 36;
            class_5250 trimmedName = name = class_2561.method_43470((String)mod.getName());
            int maxNameWidth = this.field_22789 - (x + imageOffset);
            if (this.field_22793.method_27525((class_5348)name) > maxNameWidth) {
                class_5348 ellipsis = class_5348.method_29430((String)"...");
                trimmedName = class_5348.method_29433((class_5348[])new class_5348[]{this.field_22793.method_1714((class_5348)name, maxNameWidth - this.field_22793.method_27525(ellipsis)), ellipsis});
            }
            this.field_22793.method_27528(matrices, class_2477.method_10517().method_30934((class_5348)trimmedName), (float)(x + imageOffset), (float)(this.paneY + 1), 0xFFFFFF);
            if (mouseX > x + imageOffset && mouseY > this.paneY + 1) {
                Objects.requireNonNull(this.field_22793);
                if (mouseY < this.paneY + 1 + 9 && mouseX < x + imageOffset + this.field_22793.method_27525((class_5348)trimmedName)) {
                    this.method_47415((class_2561)class_2561.method_43469((String)"modmenu.modIdToolTip", (Object[])new Object[]{mod.getId()}));
                }
            }
            if (this.init || this.modBadgeRenderer == null || this.modBadgeRenderer.getMod() != mod) {
                this.modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.field_22787.field_1772.method_27525((class_5348)trimmedName) + 2, this.paneY, this.field_22789 - 28, selectedEntry.mod, this);
                this.init = false;
            }
            if (!ModMenuConfig.HIDE_BADGES.getValue()) {
                this.modBadgeRenderer.draw(matrices, mouseX, mouseY);
            }
            if (mod.isReal()) {
                this.field_22793.method_1729(matrices, mod.getPrefixedVersion(), (float)(x + imageOffset), (float)(this.paneY + 2 + lineSpacing), 0x808080);
            }
            if (!(names = mod.getAuthors()).isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : names.get(0);
                DrawingUtil.drawWrappedString(matrices, class_1074.method_4662((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, this.paneY + 2 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private class_2561 computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
        if (includeLibs && ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return TranslationUtil.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private class_2561 computeLibraryCountText() {
        if (ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return class_2561.method_43470(null);
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void method_25420(class_4587 matrices) {
        ModsScreen.overlayBackground(0, 0, this.field_22789, this.field_22790, 64, 64, 64, 255, 255);
    }

    static void overlayBackground(int x1, int y1, int x2, int y2, int red, int green, int blue, int startAlpha, int endAlpha) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22735);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22912((double)x1, (double)y2, 0.0).method_22913((float)x1 / 32.0f, (float)y2 / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22912((double)x2, (double)y2, 0.0).method_22913((float)x2 / 32.0f, (float)y2 / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22912((double)x2, (double)y1, 0.0).method_22913((float)x2 / 32.0f, (float)y1 / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        buffer.method_22912((double)x1, (double)y1, 0.0).method_22913((float)x1 / 32.0f, (float)y1 / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        tessellator.method_1350();
    }

    public void method_25419() {
        this.modList.close();
        this.field_22787.method_1507(this.previousScreen);
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.method_1882();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeModCountText(true)) + 20 >= this.searchRowWidth && (this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeModCountText(false)) + 20 >= this.searchRowWidth || this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeLibraryCountText()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    public void method_29638(List<Path> paths) {
        Path modsDirectory = FabricLoader.getInstance().getGameDir().resolve("mods");
        List mods = paths.stream().filter(ModsScreen::isFabricMod).collect(Collectors.toList());
        if (mods.isEmpty()) {
            return;
        }
        String modList = mods.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_22787.method_1507((class_437)new class_410(value -> {
            if (value) {
                boolean allSuccessful = true;
                for (Path path : mods) {
                    try {
                        Files.copy(path, modsDirectory.resolve(path.getFileName()), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to copy mod from {} to {}", (Object)path, (Object)modsDirectory.resolve(path.getFileName()));
                        class_370.method_29627((class_310)this.field_22787, (String)path.toString());
                        allSuccessful = false;
                        break;
                    }
                }
                if (allSuccessful) {
                    class_370.method_27024((class_374)this.field_22787.method_1566(), (class_370.class_371)class_370.class_371.field_2218, (class_2561)class_2561.method_43471((String)"modmenu.dropSuccessful.line1"), (class_2561)class_2561.method_43471((String)"modmenu.dropSuccessful.line2"));
                }
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_2561.method_43471((String)"modmenu.dropConfirm"), (class_2561)class_2561.method_43470((String)modList)));
    }

    private static boolean isFabricMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("fabric.mod.json") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public Map<String, Boolean> getModHasConfigScreen() {
        return this.modHasConfigScreen;
    }
}

