/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.moveplus.forge;

import com.corosus.moveplus.command.CommandReloadConfig;
import com.corosus.moveplus.forge.ClientTicker;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="moveplus")
public class EventHandlerForge {
    public static HashMap<UUID, Boolean> lookupPlayerUUIDToCrawlActive_Server = new HashMap();
    public static boolean playerCrawlingClient = false;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void tickClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientTicker.tickClientGame();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void tickClient(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientTicker.tickClientRender();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            try {
                if (!event.player.field_70170_p.field_72995_K) {
                    if (lookupPlayerUUIDToCrawlActive_Server.containsKey(event.player.func_110124_au()) && lookupPlayerUUIDToCrawlActive_Server.get(event.player.func_110124_au()).booleanValue()) {
                        EventHandlerForge.forcePlayerCrawling(event.player);
                    }
                } else if (playerCrawlingClient && ClientTicker.isMainClientPlayer(event.player)) {
                    EventHandlerForge.forcePlayerCrawling(event.player);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setPlayerCrawlStateServer(PlayerEntity player, boolean isCrawling) {
        lookupPlayerUUIDToCrawlActive_Server.put(player.func_110124_au(), isCrawling);
    }

    public static void forcePlayerCrawling(PlayerEntity player) {
        player.func_184212_Q().func_187227_b((DataParameter)ObfuscationReflectionHelper.getPrivateValue(Entity.class, null, (String)"field_213330_X"), (Object)Pose.SWIMMING);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void tickClient(ClientChatEvent event) {
        ClientTicker.clientChatEvent(event);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientChat(ClientChatEvent event) {
        String msg = event.getMessage();
        if (msg.equals("/" + CommandReloadConfig.getCommandName() + " client")) {
            ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, FMLPaths.CONFIGDIR.get());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void drawScreen(RenderGameOverlayEvent.Pre event) {
        ClientTicker.tickClientRenderScreen(event);
    }
}

