/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.base.ElevatorInputTileRenderer;
import com.supermartijn642.movingelevators.gui.ElevatorScreen;
import com.supermartijn642.movingelevators.model.MEBlockBakedModel;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        ClientRegistry.bindTileEntityRenderer(MovingElevators.elevator_tile, ElevatorInputTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(MovingElevators.button_tile, ElevatorInputTileRenderer::new);
        RenderTypeLookup.setRenderLayer((Block)MovingElevators.elevator_block, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)MovingElevators.display_block, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)MovingElevators.button_block, (RenderType)RenderType.func_228641_d_());
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        ClientProxy.setCamouflageModel(e, MovingElevators.elevator_block);
        ClientProxy.setCamouflageModel(e, MovingElevators.display_block);
        ClientProxy.setCamouflageModel(e, MovingElevators.button_block);
    }

    private static void setCamouflageModel(ModelBakeEvent e, Block block) {
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            StringBuilder builder = new StringBuilder();
            if (!state.func_206871_b().isEmpty()) {
                builder.append(state.func_206871_b().entrySet().stream().map(entry -> ClientProxy.getPropertyName((Property)entry.getKey(), (Comparable)entry.getValue())).collect(Collectors.joining(",")));
            }
            ModelResourceLocation modelLocation = new ModelResourceLocation(block.getRegistryName(), builder.toString());
            IBakedModel model = e.getModelManager().func_174953_a(modelLocation);
            e.getModelRegistry().put(modelLocation, new MEBlockBakedModel(model));
        }
    }

    private static <T extends Comparable<T>> String getPropertyName(Property<T> property, Comparable<?> value) {
        return property.func_177701_a() + "=" + property.func_177702_a(value);
    }

    public static void openElevatorScreen(BlockPos pos) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ElevatorScreen(pos));
    }

    public static String translate(String s) {
        return I18n.func_135052_a((String)s, (Object[])new Object[0]);
    }

    public static String formatFloorDisplayName(String name, int floor) {
        return name == null ? ClientProxy.translate("movingelevators.floorname").replace("$number$", Integer.toString(floor)) : name;
    }

    public static PlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventListeners {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent e) {
            if (e.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e != null) {
                ElevatorGroupCapability.tickWorldCapability((World)Minecraft.func_71410_x().field_71441_e);
            }
        }
    }
}

