/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.google.gson.JsonParseException;
import com.supermartijn642.movingelevators.ElevatorBlock;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;

public class ElevatorBlockTile
extends ElevatorInputTile {
    private boolean initialized = false;
    private Direction facing;
    private String name;
    private DyeColor color = DyeColor.GRAY;

    public ElevatorBlockTile() {
        super(MovingElevators.elevator_tile);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.initialized) {
            this.field_145850_b.getCapability(ElevatorGroupCapability.CAPABILITY).ifPresent(cap -> cap.add(this));
            this.getGroup().updateFloorData(this, this.name, this.color);
            this.initialized = true;
        }
    }

    public boolean hasPlatform() {
        int startX = this.field_174879_c.func_177958_n() + this.getFacing().func_82601_c() * (int)Math.ceil((float)this.getGroup().getSize() / 2.0f) - this.getGroup().getSize() / 2;
        int startZ = this.field_174879_c.func_177952_p() + this.getFacing().func_82599_e() * (int)Math.ceil((float)this.getGroup().getSize() / 2.0f) - this.getGroup().getSize() / 2;
        for (int x = 0; x < this.getGroup().getSize(); ++x) {
            for (int z = 0; z < this.getGroup().getSize(); ++z) {
                BlockPos pos = new BlockPos(startX + x, this.field_174879_c.func_177956_o() - 1, startZ + z);
                if (this.field_145850_b.func_175623_d(pos) || this.field_145850_b.func_175625_s(pos) != null) {
                    return false;
                }
                BlockState state = this.field_145850_b.func_180495_p(pos);
                if (state.func_185887_b((IBlockReader)this.field_145850_b, pos) < 0.0f) {
                    return false;
                }
                if (state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197758_c(Direction.Axis.Y) == 1.0 && state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197762_b(Direction.Axis.X) == 0.0 && state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197758_c(Direction.Axis.X) == 1.0 && state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197762_b(Direction.Axis.Z) == 0.0 && state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197758_c(Direction.Axis.Z) == 1.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasSpaceForPlatform() {
        int startX = this.field_174879_c.func_177958_n() + this.getFacing().func_82601_c() * (int)Math.ceil((float)this.getGroup().getSize() / 2.0f) - this.getGroup().getSize() / 2;
        int startZ = this.field_174879_c.func_177952_p() + this.getFacing().func_82599_e() * (int)Math.ceil((float)this.getGroup().getSize() / 2.0f) - this.getGroup().getSize() / 2;
        for (int x = 0; x < this.getGroup().getSize(); ++x) {
            for (int z = 0; z < this.getGroup().getSize(); ++z) {
                BlockPos pos = new BlockPos(startX + x, this.field_174879_c.func_177956_o() - 1, startZ + z);
                if (this.field_145850_b.func_175623_d(pos)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)ElevatorBlock.FACING);
        }
        return this.facing;
    }

    @Override
    protected CompoundNBT getChangedData() {
        CompoundNBT data = super.getChangedData();
        if (this.name != null) {
            data.func_74778_a("name", ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(this.name)));
        }
        data.func_74768_a("color", this.color.func_196059_a());
        return data;
    }

    @Override
    protected CompoundNBT getAllData() {
        CompoundNBT data = super.getAllData();
        if (this.name != null) {
            data.func_74778_a("name", ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(this.name)));
        }
        data.func_74768_a("color", this.color.func_196059_a());
        return data;
    }

    @Override
    protected void handleData(CompoundNBT data) {
        super.handleData(data);
        if (data.func_74764_b("name")) {
            try {
                this.name = ITextComponent.Serializer.func_240643_a_((String)data.func_74779_i("name")).func_212636_a(Integer.MAX_VALUE);
            }
            catch (JsonParseException ignore) {
                this.name = data.func_74779_i("name");
            }
        } else {
            this.name = null;
        }
        if (data.func_74764_b("color")) {
            this.color = DyeColor.func_196056_a((int)data.func_74762_e("color"));
        }
    }

    public void onBreak() {
        this.field_145850_b.getCapability(ElevatorGroupCapability.CAPABILITY).ifPresent(groups -> groups.remove(this));
    }

    public double func_145833_n() {
        return 260100.0;
    }

    @Override
    public String getFloorName() {
        return this.name;
    }

    public void setFloorName(String name) {
        this.name = name;
        this.dataChanged();
        if (this.hasGroup()) {
            this.getGroup().updateFloorData(this, this.name, this.color);
        }
    }

    public void setDisplayLabelColor(DyeColor color) {
        this.color = color;
        this.dataChanged();
        if (this.hasGroup()) {
            this.getGroup().updateFloorData(this, this.name, this.color);
        }
    }

    @Override
    public DyeColor getDisplayLabelColor() {
        return this.color;
    }

    @Override
    public ElevatorGroup getGroup() {
        return this.field_145850_b.getCapability(ElevatorGroupCapability.CAPABILITY).map(groups -> groups.getGroup(this)).orElse(null);
    }

    @Override
    public boolean hasGroup() {
        return this.initialized;
    }

    @Override
    public int getFloorLevel() {
        return this.field_174879_c.func_177956_o();
    }
}

