/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.ElevatorGroupCapability;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElevatorGroupRenderer {
    public static final double RENDER_DISTANCE = 260100.0;

    @SubscribeEvent
    public static void onRender(RenderWorldLastEvent e) {
        ElevatorGroupCapability groups = (ElevatorGroupCapability)Minecraft.func_71410_x().field_71441_e.getCapability(ElevatorGroupCapability.CAPABILITY).orElse(null);
        if (groups == null) {
            return;
        }
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        e.getMatrixStack().func_227860_a_();
        Vector3d matrix = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        e.getMatrixStack().func_227861_a_(-matrix.field_72450_a, -matrix.field_72448_b, -matrix.field_72449_c);
        for (ElevatorGroup group : groups.getGroups()) {
            BlockPos elevatorPos = new BlockPos((double)group.x, group.getCurrentY(), (double)group.z);
            if (!(elevatorPos.func_177951_i((Vector3i)Minecraft.func_71410_x().field_71439_g.func_233580_cy_()) < 260100.0)) continue;
            ElevatorGroupRenderer.renderGroup(e.getMatrixStack(), group, buffer, e.getPartialTicks());
        }
        e.getMatrixStack().func_227865_b_();
        buffer.func_228461_a_();
    }

    public static void renderGroup(MatrixStack matrixStack, ElevatorGroup group, IRenderTypeBuffer.Impl buffer, float partialTicks) {
        if (!group.isMoving() || group.getCurrentY() == group.getLastY()) {
            return;
        }
        BlockState[][] state = group.getPlatform();
        int size = group.getSize();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double y = lastY + (currentY - lastY) * (double)partialTicks;
        int startX = group.x + group.facing.func_82601_c() * (int)Math.ceil((float)size / 2.0f) - size / 2;
        int startZ = group.z + group.facing.func_82599_e() * (int)Math.ceil((float)size / 2.0f) - size / 2;
        BlockPos topPos = new BlockPos((double)group.x, y, (double)group.z).func_177967_a(group.facing, (int)Math.ceil((float)size / 2.0f));
        int currentLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)group.world, (BlockPos)topPos);
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)(startX + x), y, (double)(startZ + z));
                Minecraft.func_71410_x().func_175602_ab().renderBlock(state[x][z], matrixStack, (IRenderTypeBuffer)buffer, currentLight, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                matrixStack.func_227865_b_();
            }
        }
    }
}

