/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.base;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.movingelevators.ClientProxy;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import com.supermartijn642.movingelevators.base.METileRenderer;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;

public class ElevatorInputTileRenderer<T extends ElevatorInputTile>
extends METileRenderer<T> {
    private static final RenderType BUTTONS = ElevatorInputTileRenderer.getTexture("buttons");
    private static final RenderType DISPLAY_BACKGROUND = ElevatorInputTileRenderer.getTexture("display_overlay");
    private static final RenderType DISPLAY_BACKGROUND_BIG = ElevatorInputTileRenderer.getTexture("display_overlay_big");
    private static final RenderType DISPLAY_GREEN_DOT = ElevatorInputTileRenderer.getTexture("green_dot");
    private static final HashMap<DyeColor, RenderType> DISPLAY_BUTTONS = new HashMap();
    private static final HashMap<DyeColor, RenderType> DISPLAY_BUTTONS_OFF = new HashMap();
    private static final double TEXT_RENDER_DISTANCE = 225.0;

    private static RenderType getTexture(String name) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228726_a_(new RenderState.TransparencyState("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableAlphaTest();
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.disableAlphaTest();
        })).func_228724_a_(new RenderState.TextureState(new ResourceLocation("movingelevators", "textures/blocks/" + name + ".png"), false, false)).func_228728_a_(false);
        return RenderType.func_228633_a_((String)("movingelevators_texture_" + name), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)state);
    }

    public ElevatorInputTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    @Override
    protected void render() {
        if (!((ElevatorInputTile)this.tile).hasGroup() || ((ElevatorInputTile)this.tile).getFacing() == null) {
            return;
        }
        this.renderButtons();
        this.renderDisplay();
    }

    private void renderButtons() {
        this.matrixStack.func_227860_a_();
        this.matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        this.matrixStack.func_227863_a_(new Quaternion(0.0f, 180.0f - ((ElevatorInputTile)this.tile).getFacing().func_185119_l(), 0.0f, true));
        this.matrixStack.func_227861_a_(-0.5, -0.5, -0.51);
        this.drawQuad(BUTTONS);
        this.matrixStack.func_227865_b_();
    }

    private void renderDisplay() {
        double platformY;
        int index;
        RenderType background;
        int button_count;
        int height = ((ElevatorInputTile)this.tile).getDisplayHeight();
        if (height <= 0) {
            return;
        }
        this.matrixStack.func_227860_a_();
        this.matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        this.matrixStack.func_227863_a_(new Quaternion(0.0f, 180.0f - ((ElevatorInputTile)this.tile).getFacing().func_185119_l(), 0.0f, true));
        this.matrixStack.func_227861_a_(-0.5, -0.5, -0.51);
        if (height == 1) {
            button_count = 3;
            background = DISPLAY_BACKGROUND;
        } else {
            button_count = 7;
            background = DISPLAY_BACKGROUND_BIG;
        }
        this.matrixStack.func_227860_a_();
        this.matrixStack.func_227862_a_(1.0f, (float)height, 1.0f);
        this.drawQuad(background);
        this.matrixStack.func_227865_b_();
        ElevatorGroup group = ((ElevatorInputTile)this.tile).getGroup();
        int below = index = group.getFloorNumber(((ElevatorInputTile)this.tile).getFloorLevel());
        int above = group.getFloorCount() - index - 1;
        if (below < above) {
            below = Math.min(below, button_count);
            above = Math.min(above, button_count * 2 - below);
        } else {
            above = Math.min(above, button_count);
            below = Math.min(below, button_count * 2 - above);
        }
        int startIndex = index - below;
        int total = below + 1 + above;
        Vector3d buttonPos = new Vector3d((double)((ElevatorInputTile)this.tile).func_174877_v().func_177958_n() + 0.5, (double)(((ElevatorInputTile)this.tile).func_174877_v().func_177956_o() + 1) + 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, (double)((ElevatorInputTile)this.tile).func_174877_v().func_177952_p() + 0.5);
        Vector3d cameraPos = Minecraft.func_71410_x().field_175622_Z.func_174824_e(this.partialTicks);
        this.matrixStack.func_227860_a_();
        this.matrixStack.func_227861_a_(0.0, 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, -0.002);
        this.matrixStack.func_227862_a_(1.0f, 0.125f, 1.0f);
        for (int i = 0; i < total; ++i) {
            boolean drawText;
            this.drawQuad((startIndex + i == index ? DISPLAY_BUTTONS_OFF : DISPLAY_BUTTONS).get(group.getFloorDisplayColor(startIndex + i)));
            boolean bl = drawText = cameraPos.func_72436_e(buttonPos) < 225.0;
            if (drawText) {
                this.matrixStack.func_227860_a_();
                this.matrixStack.func_227861_a_(0.578125, 0.0, 0.0);
                this.drawString(ClientProxy.formatFloorDisplayName(group.getFloorDisplayName(startIndex + i), startIndex + i));
                this.matrixStack.func_227865_b_();
            }
            this.matrixStack.func_227861_a_(0.0, 1.0, 0.0);
            buttonPos = buttonPos.func_72441_c(0.0, 0.125, 0.0);
        }
        this.matrixStack.func_227865_b_();
        if (((ElevatorInputTile)this.tile).getGroup().isMoving() && (platformY = ((ElevatorInputTile)this.tile).getGroup().getCurrentY()) >= (double)group.getFloorYLevel(0) && platformY < (double)group.getFloorYLevel(group.getFloorCount() - 1)) {
            double yOffset = 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0;
            for (int i = 0; i < group.getFloorCount() - 1; ++i) {
                int belowY = group.getFloorYLevel(i);
                int aboveY = group.getFloorYLevel(i + 1);
                if (!(platformY >= (double)belowY) || !(platformY < (double)aboveY)) continue;
                yOffset += ((double)i + (platformY - (double)belowY) / (double)(aboveY - belowY)) * 0.125;
            }
            this.matrixStack.func_227861_a_(0.078125, yOffset, -0.003);
            this.matrixStack.func_227862_a_(0.125f, 0.125f, 1.0f);
            this.drawQuad(DISPLAY_GREEN_DOT);
        }
        this.matrixStack.func_227865_b_();
    }

    private void drawQuad(RenderType type) {
        Matrix4f matrix = this.matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder builder = this.buffer.getBuffer(type);
        builder.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, 1.0f, 0.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, 1.0f, 1.0f, 0.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, 1.0f, 0.0f, 0.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
    }

    private void drawString(String s) {
        if (s == null) {
            return;
        }
        FontRenderer fontRenderer = this.field_228858_b_.field_147557_n;
        this.matrixStack.func_227860_a_();
        this.matrixStack.func_227861_a_(0.0, 0.07, -0.005);
        this.matrixStack.func_227862_a_(-0.01f, -0.08f, 1.0f);
        float f = (float)(-fontRenderer.func_78256_a(s)) / 2.0f;
        fontRenderer.getClass();
        fontRenderer.func_228079_a_(s, f, (float)(-9), NativeImage.func_227787_a_((int)255, (int)255, (int)255, (int)255), true, this.matrixStack.func_227866_c_().func_227870_a_(), this.buffer, false, 0, this.combinedLight);
        this.matrixStack.func_227865_b_();
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            DISPLAY_BUTTONS.put(color, ElevatorInputTileRenderer.getTexture("display_buttons/display_button_" + color.name().toLowerCase(Locale.ROOT)));
            DISPLAY_BUTTONS_OFF.put(color, ElevatorInputTileRenderer.getTexture("display_buttons/display_button_off_" + color.name().toLowerCase(Locale.ROOT)));
        }
    }
}

