/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.packets;

import com.supermartijn642.movingelevators.ClientProxy;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.ElevatorGroupCapability;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class ElevatorMovementPacket {
    private int x;
    private int z;
    private Direction facing;
    private double currentY;

    public ElevatorMovementPacket(int x, int z, Direction facing, double currentY) {
        this.x = x;
        this.z = z;
        this.facing = facing;
        this.currentY = currentY;
    }

    public ElevatorMovementPacket(PacketBuffer buffer) {
        this.decode(buffer);
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.z);
        buffer.writeInt(this.facing.func_176736_b());
        buffer.writeDouble(this.currentY);
    }

    public void decode(PacketBuffer buffer) {
        this.x = buffer.readInt();
        this.z = buffer.readInt();
        this.facing = Direction.func_176731_b((int)buffer.readInt());
        this.currentY = buffer.readDouble();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        World world = ClientProxy.getPlayer().field_70170_p;
        if (world == null) {
            return;
        }
        ElevatorGroupCapability groups = (ElevatorGroupCapability)world.getCapability(ElevatorGroupCapability.CAPABILITY).orElse(null);
        if (groups == null) {
            return;
        }
        ElevatorGroup group = groups.get(this.x, this.z, this.facing);
        if (group == null) {
            return;
        }
        context.enqueueWork(() -> group.updateCurrentY(this.currentY));
    }
}

