/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.MusketItem;
import ewewukek.musketmod.MusketMod;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Scanner;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger logger = LogManager.getLogger(MusketMod.class);
    public static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("musketmod.txt");
    public static final Config INSTANCE = new Config();
    public static final int VERSION = 1;
    public double bulletStdDev;
    public double bulletSpeed;
    public double bulletMaxDistance;
    public double damageMin;
    public double damageMax;

    public static void reload() {
        INSTANCE.setDefaults();
        INSTANCE.load();
        MusketItem.bulletStdDev = (float)Math.toRadians(Config.INSTANCE.bulletStdDev);
        MusketItem.bulletSpeed = Config.INSTANCE.bulletSpeed / 20.0;
        double maxEnergy = MusketItem.bulletSpeed * MusketItem.bulletSpeed;
        BulletEntity.damageFactorMin = (float)(Config.INSTANCE.damageMin / maxEnergy);
        BulletEntity.damageFactorMax = (float)(Config.INSTANCE.damageMax / maxEnergy);
        BulletEntity.maxDistance = Config.INSTANCE.bulletMaxDistance;
        logger.info("Configuration has been loaded");
    }

    private void setDefaults() {
        this.bulletStdDev = 1.0;
        this.bulletSpeed = 180.0;
        this.bulletMaxDistance = 256.0;
        this.damageMin = 20.5;
        this.damageMax = 21.5;
    }

    /*
     * Unable to fully structure code
     */
    private void load() {
        version = 0;
        try {
            reader = Files.newBufferedReader(Config.CONFIG_PATH);
            var3_5 = null;
            try {
                lineNumber = 0;
lbl7:
                // 15 sources

                block43: while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    commentStart = line.indexOf(35);
                    if (commentStart != -1) {
                        line = line.substring(0, commentStart);
                    }
                    line.trim();
                    if (line.length() == 0) continue;
                    errorPrefix = Config.CONFIG_PATH + ": line " + lineNumber + ": ";
                    s = new Scanner(line);
                    var9_13 = null;
                    try {
                        s.useLocale(Locale.US);
                        s.useDelimiter("\\s*=\\s*");
                        if (!s.hasNext()) {
                            Config.logger.warn(errorPrefix + "parameter name is missing");
                            continue;
                        }
                        key = s.next().trim();
                        if (!s.hasNextDouble()) {
                            Config.logger.warn(errorPrefix + "value is missing/wrong/not a number");
                            continue;
                        }
                        value = s.nextDouble();
                        var13_20 = key;
                        var14_21 = -1;
                        switch (var13_20.hashCode()) {
                            case 351608024: {
                                if (!var13_20.equals("version")) break;
                                var14_21 = 0;
                                break;
                            }
                            case 582909588: {
                                if (!var13_20.equals("bulletStdDev")) break;
                                var14_21 = 1;
                                break;
                            }
                            case -1366786971: {
                                if (!var13_20.equals("bulletSpeed")) break;
                                var14_21 = 2;
                                break;
                            }
                            case -1363058921: {
                                if (!var13_20.equals("bulletMaxDistance")) break;
                                var14_21 = 3;
                                break;
                            }
                            case 2020948067: {
                                if (!var13_20.equals("damageMin")) break;
                                var14_21 = 4;
                                break;
                            }
                            case 2020947829: {
                                if (!var13_20.equals("damageMax")) break;
                                var14_21 = 5;
                            }
                        }
                        switch (var14_21) {
                            case 0: {
                                version = (int)value;
                                ** break;
                            }
                            case 1: {
                                this.bulletStdDev = value;
                                ** break;
                            }
                            case 2: {
                                this.bulletSpeed = value;
                                ** break;
                            }
                            case 3: {
                                this.bulletMaxDistance = value;
                                ** break;
                            }
                            case 4: {
                                this.damageMin = value;
                                ** break;
                            }
                            case 5: {
                                this.damageMax = value;
                                ** break;
                            }
                            default: {
                                Config.logger.warn(errorPrefix + "unrecognized parameter name: " + key);
                                continue block43;
                            }
                        }
                    }
                    catch (Throwable var10_17) {
                        var9_13 = var10_17;
                        throw var10_17;
                    }
                    finally {
                        if (s == null) continue;
                        if (var9_13 != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable var10_15) {
                                var9_13.addSuppressed(var10_15);
                            }
                            continue;
                        }
                        s.close();
                    }
                }
            }
            catch (Throwable var4_9) {
                var3_5 = var4_9;
                throw var4_9;
            }
            finally {
                if (reader != null) {
                    if (var3_5 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable var4_8) {
                            var3_5.addSuppressed(var4_8);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (NoSuchFileException e) {
            this.save();
            Config.logger.info("Configuration file not found, default created");
        }
        catch (IOException e) {
            Config.logger.warn("Could not read configuration file: ", (Throwable)e);
        }
        if (version < 1) {
            Config.logger.info("Configuration file belongs to older version, updating");
            this.save();
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            writer.write("version = 1\n");
            writer.write("# Standard deviation of bullet spread (in degrees)\n");
            writer.write("bulletStdDev = " + this.bulletStdDev + "\n");
            writer.write("# Muzzle velocity of bullet (in blocks per second)\n");
            writer.write("bulletSpeed = " + this.bulletSpeed + "\n");
            writer.write("# Maximum bullet travel distance (in blocks)\n");
            writer.write("bulletMaxDistance = " + this.bulletMaxDistance + "\n");
            writer.write("# Minimum damage at point-blank range\n");
            writer.write("damageMin = " + this.damageMin + "\n");
            writer.write("# Maximum damage at point-blank range\n");
            writer.write("damageMax = " + this.damageMax + "\n");
        }
        catch (IOException e) {
            logger.warn("Could not save configuration file: ", (Throwable)e);
        }
    }
}

