/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.MusketItem;
import ewewukek.musketmod.MusketMod;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BulletEntity
extends AbstractHurtingProjectile {
    private static final Random random = new Random();
    static final double GRAVITY = 0.05;
    static final double AIR_FRICTION = 0.99;
    static final double WATER_FRICTION = 0.6;
    static final short LIFETIME = 50;
    public static float damageFactorMin;
    public static float damageFactorMax;
    public static double maxDistance;
    private float distanceTravelled;
    private short tickCounter;

    public BulletEntity(EntityType<BulletEntity> entityType, Level world) {
        super(entityType, world);
    }

    public BulletEntity(Level world) {
        this(MusketMod.BULLET_ENTITY_TYPE, world);
    }

    public boolean isFirstTick() {
        return this.tickCounter == 0;
    }

    public DamageSource causeMusketDamage(BulletEntity bullet, Entity attacker) {
        return new IndirectEntityDamageSource("musket", (Entity)bullet, attacker).m_19366_();
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_ && this.processCollision()) {
            this.m_146870_();
            return;
        }
        this.tickCounter = (short)(this.tickCounter + 1);
        if (this.tickCounter >= 50 || (double)this.distanceTravelled > maxDistance) {
            this.m_146870_();
            return;
        }
        Vec3 motion = this.m_20184_();
        double posX = this.m_20185_() + motion.f_82479_;
        double posY = this.m_20186_() + motion.f_82480_;
        double posZ = this.m_20189_() + motion.f_82481_;
        this.distanceTravelled = (float)((double)this.distanceTravelled + motion.m_82553_());
        motion = motion.m_82492_(0.0, 0.05, 0.0);
        double friction = 0.99;
        if (this.m_20069_()) {
            int count = 4;
            for (int i = 0; i != 4; ++i) {
                double t = ((double)i + 1.0) / 4.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, posX - motion.f_82479_ * t, posY - motion.f_82480_ * t, posZ - motion.f_82481_ * t, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
            friction = 0.6;
        }
        this.m_20256_(motion.m_82490_(friction));
        this.m_6034_(posX, posY, posZ);
        this.m_20101_();
    }

    private void fireParticles() {
        Vec3 pos = this.m_20182_();
        Vec3 front = this.m_20184_().m_82541_();
        for (int i = 0; i != 10; ++i) {
            double t = Math.pow(random.nextFloat(), 1.5);
            Vec3 p = pos.m_82549_(front.m_82490_(1.25 + t));
            p = p.m_82549_(new Vec3((double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5).m_82490_(0.1));
            Vec3 v = front.m_82490_(0.1 * (1.0 - t));
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, p.f_82479_, p.f_82480_, p.f_82481_, v.f_82479_, v.f_82480_, v.f_82481_);
        }
    }

    private boolean processCollision() {
        Entity target;
        Vec3 to;
        Vec3 from = this.m_20182_();
        BlockHitResult collision = this.f_19853_.m_45547_(new ClipContext(from, to = from.m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (collision.m_6662_() != HitResult.Type.MISS) {
            to = collision.m_82450_();
        }
        if ((target = this.closestEntityOnPath(from, to)) != null) {
            Entity shooter;
            if (target instanceof Player && (shooter = this.m_37282_()) instanceof Player && !((Player)shooter).m_7099_((Player)target)) {
                target = null;
            }
            if (target != null) {
                this.hitEntity(target);
                return true;
            }
        }
        if (collision.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockState blockstate = this.f_19853_.m_8055_(collision.m_82425_());
        blockstate.m_60669_(this.f_19853_, blockstate, collision, (Projectile)this);
        int impactParticleCount = (int)(this.m_20184_().m_82556_() / 20.0);
        if (impactParticleCount > 0) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), to.f_82479_, to.f_82480_, to.f_82481_, impactParticleCount, 0.0, 0.0, 0.0, 0.01);
        }
        return true;
    }

    private void hitEntity(Entity target) {
        Entity shooter = this.m_37282_();
        DamageSource damagesource = this.causeMusketDamage(this, (Entity)(shooter != null ? shooter : this));
        float energy = (float)this.m_20184_().m_82556_();
        float factor = damageFactorMin + random.nextFloat() * (damageFactorMax - damageFactorMin);
        target.m_6469_(damagesource, energy * factor);
    }

    private Entity closestEntityOnPath(Vec3 start, Vec3 end) {
        Vec3 motion = this.m_20184_();
        Entity result = null;
        double result_dist = 0.0;
        AABB aabbSelection = this.m_142469_().m_82369_(motion).m_82400_(0.5);
        for (Entity entity : this.f_19853_.m_6249_((Entity)this, aabbSelection, x$0 -> this.m_5603_((Entity)x$0))) {
            double dist;
            AABB aabb = entity.m_142469_();
            Optional optional = aabb.m_82371_(start, end);
            if (!optional.isPresent()) {
                aabb = aabb.m_82386_(entity.f_19790_ - entity.m_20185_(), entity.f_19791_ - entity.m_20186_(), entity.f_19792_ - entity.m_20189_());
                optional = aabb.m_82371_(start, end);
            }
            if (!optional.isPresent() || !((dist = start.m_82557_((Vec3)optional.get())) < result_dist) && result != null) continue;
            result = entity;
            result_dist = dist;
        }
        return result;
    }

    protected void m_8097_() {
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.distanceTravelled = compound.m_128457_("distanceTravelled");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("distanceTravelled", this.distanceTravelled);
    }

    public Packet<?> m_5654_() {
        Entity owner = this.m_37282_();
        return new ClientboundAddEntityPacket(this.m_142049_(), this.m_142081_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), owner != null ? owner.m_142049_() : 0, this.m_20184_().m_82490_(3.9 / MusketItem.bulletSpeed));
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        Vec3 packet_velocity = new Vec3(packet.m_131503_(), packet.m_131504_(), packet.m_131505_());
        this.m_20256_(packet_velocity.m_82490_(MusketItem.bulletSpeed / 3.9));
        this.fireParticles();
    }
}

