/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletRenderer;
import ewewukek.musketmod.MusketItem;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientSetup {
    public static void init(FMLClientSetupEvent event) {
        ItemProperties.register((Item)MusketMod.MUSKET, (ResourceLocation)new ResourceLocation("loaded"), (stack, world, player, arg) -> MusketItem.isLoaded(stack) ? 1.0f : 0.0f);
    }

    @SubscribeEvent
    public static void onRenderHandEvent(RenderHandEvent event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && stack.m_41720_() == MusketMod.MUSKET) {
            Minecraft mc = Minecraft.m_91087_();
            RenderHelper.renderSpecificFirstPersonHand(mc.m_91292_(), (AbstractClientPlayer)mc.f_91074_, event.getHand(), event.getPartialTicks(), event.getInterpolatedPitch(), event.getSwingProgress(), event.getEquipProgress(), stack, event.getMatrixStack(), event.getBuffers(), event.getLight());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEventPre(RenderLivingEvent.Pre<Player, PlayerModel<Player>> event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.f_20911_) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!stack.m_41619_() && stack.m_41720_() == MusketMod.MUSKET && MusketItem.isLoaded(stack)) {
            PlayerModel model = (PlayerModel)event.getRenderer().m_7200_();
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                model.f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
            } else {
                model.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(MusketMod.BULLET_ENTITY_TYPE, BulletRenderer::new);
        }
    }
}

