/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.MusketMod;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MusketItem
extends Item {
    public static final int DURABILITY = 250;
    public static final int LOADING_STAGE_1 = 5;
    public static final int LOADING_STAGE_2 = 10;
    public static final int LOADING_STAGE_3 = 20;
    public static final int RELOAD_DURATION = 30;
    public static float bulletStdDev;
    public static double bulletSpeed;

    public MusketItem(Item.Properties properties) {
        super(properties.m_41499_(250));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return super.m_7203_(worldIn, player, hand);
        }
        ItemStack stack = player.m_21120_(hand);
        boolean creative = player.m_150110_().f_35937_;
        if (player.m_19941_((Tag)FluidTags.f_13131_) && !creative) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        boolean haveAmmo = !this.findAmmo(player).m_41619_() || creative;
        boolean loaded = MusketItem.isLoaded(stack);
        if (loaded && MusketItem.isReady(stack)) {
            if (!worldIn.f_46443_) {
                this.fireBullet(worldIn, player);
            }
            player.m_5496_(MusketMod.SOUND_MUSKET_FIRE, 3.5f, 1.0f);
            MusketItem.damageItem(stack, player);
            this.setReady(stack, false);
            this.setLoaded(stack, false);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (loaded || haveAmmo) {
            if (!loaded) {
                this.setLoadingStage(stack, 0);
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (MusketItem.isLoaded(stack)) {
            this.setReady(stack, true);
        }
    }

    public void m_5929_(Level world, LivingEntity entity, ItemStack stack, int timeLeft) {
        if (world.f_46443_ || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int usingDuration = this.m_8105_(stack) - timeLeft;
        int loadingStage = this.getLoadingStage(stack);
        double posX = player.m_20185_();
        double posY = player.m_20186_();
        double posZ = player.m_20189_();
        if (loadingStage == 0 && usingDuration >= 5) {
            world.m_6263_(null, posX, posY, posZ, MusketMod.SOUND_MUSKET_LOAD_0, SoundSource.PLAYERS, 0.8f, 1.0f);
            this.setLoadingStage(stack, 1);
        } else if (loadingStage == 1 && usingDuration >= 10) {
            world.m_6263_(null, posX, posY, posZ, MusketMod.SOUND_MUSKET_LOAD_1, SoundSource.PLAYERS, 0.8f, 1.0f);
            this.setLoadingStage(stack, 2);
        } else if (loadingStage == 2 && usingDuration >= 20) {
            world.m_6263_(null, posX, posY, posZ, MusketMod.SOUND_MUSKET_LOAD_2, SoundSource.PLAYERS, 0.8f, 1.0f);
            this.setLoadingStage(stack, 3);
        }
        if (usingDuration >= 30 && !MusketItem.isLoaded(stack)) {
            if (!player.m_150110_().f_35937_) {
                ItemStack ammoStack = this.findAmmo(player);
                if (ammoStack.m_41619_()) {
                    return;
                }
                ammoStack.m_41774_(1);
                if (ammoStack.m_41619_()) {
                    player.m_150109_().m_36057_(ammoStack);
                }
            }
            world.m_6263_(null, posX, posY, posZ, MusketMod.SOUND_MUSKET_READY, SoundSource.PLAYERS, 0.8f, 1.0f);
            this.setLoaded(stack, true);
        }
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.f_46443_ && entityLiving instanceof Player && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            MusketItem.damageItem(stack, (Player)entityLiving);
        }
        return false;
    }

    public static void damageItem(ItemStack stack, Player player) {
        stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public static boolean isLoaded(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128445_("loaded") == 1;
    }

    public static boolean isReady(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128445_("ready") == 1;
    }

    private boolean isAmmo(ItemStack stack) {
        return stack.m_41720_() == MusketMod.CARTRIDGE;
    }

    private ItemStack findAmmo(Player player) {
        if (this.isAmmo(player.m_6844_(EquipmentSlot.OFFHAND))) {
            return player.m_6844_(EquipmentSlot.OFFHAND);
        }
        if (this.isAmmo(player.m_6844_(EquipmentSlot.MAINHAND))) {
            return player.m_6844_(EquipmentSlot.MAINHAND);
        }
        for (int i = 0; i != player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    private void fireBullet(Level worldIn, Player player) {
        float deg2rad = (float)Math.PI / 180;
        Vec3 front = new Vec3(0.0, 0.0, 1.0).m_82496_((float)(-Math.PI) / 180 * player.m_146909_()).m_82524_((float)(-Math.PI) / 180 * player.m_146908_());
        Vec3 pos = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        float angle = (float)Math.PI * 2 * worldIn.m_5822_().nextFloat();
        float gaussian = Math.abs((float)worldIn.m_5822_().nextGaussian());
        if (gaussian > 4.0f) {
            gaussian = 4.0f;
        }
        front = front.m_82496_(bulletStdDev * gaussian * Mth.m_14031_((float)angle)).m_82524_(bulletStdDev * gaussian * Mth.m_14089_((float)angle));
        Vec3 motion = front.m_82490_(bulletSpeed);
        Vec3 playerMotion = player.m_20184_();
        motion.m_82520_(playerMotion.f_82479_, player.m_20096_() ? 0.0 : playerMotion.f_82480_, playerMotion.f_82481_);
        BulletEntity bullet = new BulletEntity(worldIn);
        bullet.m_5602_((Entity)player);
        bullet.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        bullet.m_20256_(motion);
        worldIn.m_7967_((Entity)bullet);
    }

    private void setLoaded(ItemStack stack, boolean loaded) {
        stack.m_41784_().m_128344_("loaded", (byte)(loaded ? 1 : 0));
    }

    private void setReady(ItemStack stack, boolean ready) {
        stack.m_41784_().m_128344_("ready", (byte)(ready ? 1 : 0));
    }

    private void setLoadingStage(ItemStack stack, int loadingStage) {
        stack.m_41784_().m_128405_("loadingStage", loadingStage);
    }

    private int getLoadingStage(ItemStack stack) {
        return stack.m_41784_().m_128451_("loadingStage");
    }
}

