/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.ClientSetup;
import ewewukek.musketmod.Config;
import ewewukek.musketmod.MusketItem;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="musketmod")
public class MusketMod {
    public static final String MODID = "musketmod";
    public static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("musketmod.txt");
    public static final Item CARTRIDGE = new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40757_));
    public static final Item MUSKET = new MusketItem(new Item.Properties().m_41491_(CreativeModeTab.f_40757_));
    public static final SoundEvent SOUND_MUSKET_LOAD_0 = new SoundEvent(new ResourceLocation("musketmod", "musket_load0"));
    public static final SoundEvent SOUND_MUSKET_LOAD_1 = new SoundEvent(new ResourceLocation("musketmod", "musket_load1"));
    public static final SoundEvent SOUND_MUSKET_LOAD_2 = new SoundEvent(new ResourceLocation("musketmod", "musket_load2"));
    public static final SoundEvent SOUND_MUSKET_READY = new SoundEvent(new ResourceLocation("musketmod", "musket_ready"));
    public static final SoundEvent SOUND_MUSKET_FIRE = new SoundEvent(new ResourceLocation("musketmod", "musket_fire"));
    public static final EntityType<BulletEntity> BULLET_ENTITY_TYPE = EntityType.Builder.m_20704_(BulletEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(64).setUpdateInterval(5).setShouldReceiveVelocityUpdates(false).m_20712_("musketmod:bullet");

    public MusketMod() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientSetup::init));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerEvents {
        @SubscribeEvent
        public static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
            event.addListener(new PreparableReloadListener(){

                public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                    return stage.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> Config.reload(), gameExecutor);
                }
            });
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)CARTRIDGE.setRegistryName(MusketMod.MODID, "cartridge"), (Item)MUSKET.setRegistryName(MusketMod.MODID, "musket")});
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)((EntityType)BULLET_ENTITY_TYPE.setRegistryName(MusketMod.MODID, "bullet")));
        }

        @SubscribeEvent
        public static void onSoundRegistry(RegistryEvent.Register<SoundEvent> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)SOUND_MUSKET_LOAD_0.setRegistryName(MusketMod.MODID, "musket_load0"), (SoundEvent)SOUND_MUSKET_LOAD_1.setRegistryName(MusketMod.MODID, "musket_load1"), (SoundEvent)SOUND_MUSKET_LOAD_2.setRegistryName(MusketMod.MODID, "musket_load2"), (SoundEvent)SOUND_MUSKET_READY.setRegistryName(MusketMod.MODID, "musket_ready"), (SoundEvent)SOUND_MUSKET_FIRE.setRegistryName(MusketMod.MODID, "musket_fire")});
        }
    }
}

