/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.gui;

import chumbanotz.mutantbeasts.MBConfig;
import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.packet.CreeperMinionTrackerPacket;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class CreeperMinionTrackerScreen
extends GuiScreen {
    private static final ResourceLocation TEXTURE = MutantBeasts.prefix("textures/gui/creeper_minion_tracker.png");
    private final int xSize = 176;
    private final int ySize = 166;
    private int guiX;
    private int guiY;
    private final CreeperMinionEntity creeperMinion;
    private boolean canRideOnShoulder;
    private boolean canDestroyBlocks;
    private boolean alwaysShowName;

    public CreeperMinionTrackerScreen(CreeperMinionEntity creeperMinion) {
        this.creeperMinion = creeperMinion;
    }

    public void func_73866_w_() {
        this.canDestroyBlocks = this.creeperMinion.canDestroyBlocks();
        this.alwaysShowName = this.creeperMinion.func_174833_aM();
        this.canRideOnShoulder = this.creeperMinion.canRideOnShoulder();
        this.guiX = (this.field_146294_l - this.xSize) / 2;
        this.guiY = (this.field_146295_m - this.ySize) / 2;
        int buttonWidth = this.xSize / 2 - 10;
        this.func_189646_b(new GuiButton(0, this.guiX + 8, this.guiY + this.ySize - 78, buttonWidth * 2 + 4, 20, this.canDestroyBlocks()));
        this.func_189646_b(new GuiButton(1, this.guiX + 8, this.guiY + this.ySize - 54, buttonWidth * 2 + 4, 20, this.getShowName()));
        this.func_189646_b(new GuiButton(2, this.guiX + 8, this.guiY + this.ySize - 30, buttonWidth * 2 + 4, 20, this.canRideOnShoulder()));
        if (!this.creeperMinion.func_152114_e((EntityLivingBase)this.field_146297_k.field_71439_g)) {
            for (GuiButton button : this.field_146292_n) {
                button.field_146124_l = false;
            }
        }
        if (!MBConfig.creeperMinionOnShoulder) {
            ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = false;
        }
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private String getShowName() {
        return CreeperMinionTrackerScreen.format("always_show_name", new Object[0]) + I18n.func_135052_a((String)(this.alwaysShowName ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String canDestroyBlocks() {
        return CreeperMinionTrackerScreen.format("destroys_blocks", new Object[0]) + I18n.func_135052_a((String)(this.canDestroyBlocks ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String canRideOnShoulder() {
        if (MBConfig.creeperMinionOnShoulder) {
            return CreeperMinionTrackerScreen.format("can_ride_on_shoulder", new Object[0]) + I18n.func_135052_a((String)(this.canRideOnShoulder ? "options.on" : "options.off"), (Object[])new Object[0]);
        }
        return CreeperMinionTrackerScreen.format("disabled", new Object[0]);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                this.canDestroyBlocks = !this.canDestroyBlocks;
                MBPacketHandler.INSTANCE.sendToServer((IMessage)new CreeperMinionTrackerPacket(this.creeperMinion, 0, this.canDestroyBlocks));
                button.field_146126_j = this.canDestroyBlocks();
                break;
            }
            case 1: {
                this.alwaysShowName = !this.alwaysShowName;
                MBPacketHandler.INSTANCE.sendToServer((IMessage)new CreeperMinionTrackerPacket(this.creeperMinion, 1, this.alwaysShowName));
                button.field_146126_j = this.getShowName();
                break;
            }
            case 2: {
                this.canRideOnShoulder = !this.canRideOnShoulder;
                MBPacketHandler.INSTANCE.sendToServer((IMessage)new CreeperMinionTrackerPacket(this.creeperMinion, 2, this.canRideOnShoulder));
                button.field_146126_j = this.canRideOnShoulder();
                break;
            }
        }
    }

    public void func_73876_c() {
        if (!this.creeperMinion.func_70089_S()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.guiX, this.guiY, 0, 0, this.xSize, this.ySize);
        int health = (int)(this.creeperMinion.func_110143_aJ() * 150.0f / this.creeperMinion.func_110138_aP());
        this.func_73729_b(this.guiX + 13, this.guiY + 16, 0, 166, health, 6);
        this.field_146289_q.func_78276_b(this.creeperMinion.func_145748_c_().func_150260_c(), this.guiX + 13, this.guiY + 5, 0x404040);
        this.field_146289_q.func_78276_b(CreeperMinionTrackerScreen.format("health", new Object[0]), this.guiX + 13, this.guiY + 28, 0x404040);
        this.field_146289_q.func_78276_b(CreeperMinionTrackerScreen.format("explosion", new Object[0]), this.guiX + 13, this.guiY + 48, 0x404040);
        this.field_146289_q.func_78276_b(CreeperMinionTrackerScreen.format("blast_radius", new Object[0]), this.guiX + 13, this.guiY + 68, 0x404040);
        StringBuilder sb = new StringBuilder();
        sb.append(this.creeperMinion.func_110143_aJ() / 2.0f).append(" / ").append(this.creeperMinion.func_110138_aP() / 2.0f);
        this.func_73732_a(this.field_146289_q, sb.toString(), this.guiX + this.xSize / 2 + 38, this.guiY + 30, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.creeperMinion.canExplodeContinuously() ? CreeperMinionTrackerScreen.format("continuous", new Object[0]) : CreeperMinionTrackerScreen.format("one_time", new Object[0]), this.guiX + this.xSize / 2 + 38, this.guiY + 50, 0xFFFFFF);
        int temp = (int)(this.creeperMinion.getExplosionRadius() * 10.0f);
        sb = new StringBuilder().append((float)temp / 10.0f);
        this.func_73732_a(this.field_146289_q, sb.toString(), this.guiX + this.xSize / 2 + 38, this.guiY + 70, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean func_73868_f() {
        return false;
    }

    private static String format(String key, Object ... parameters) {
        return I18n.func_135052_a((String)("gui.mutantbeasts.creeper_minion_tracker." + key), (Object[])parameters);
    }
}

