/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.entity.mutant.MutantSkeletonEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class BodyPartEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private int part;
    private final boolean yawPositive;
    private final boolean pitchPositive;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private int despawnTimer;

    public BodyPartEntity(World world) {
        super(world);
        this.field_70126_B = this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.field_70127_C = this.field_70125_A = this.field_70146_Z.nextFloat() * 360.0f;
        this.yawPositive = this.field_70146_Z.nextBoolean();
        this.pitchPositive = this.field_70146_Z.nextBoolean();
        this.func_70105_a(0.7f, 0.7f);
    }

    public BodyPartEntity(World world, EntityLiving owner, int bodyPart) {
        this(world);
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u + (double)(3.2f * (0.25f + this.field_70146_Z.nextFloat() * 0.5f)), owner.field_70161_v);
        this.part = bodyPart;
        if (owner.func_70027_ad()) {
            this.func_70015_d(EntityUtil.getFire((Entity)owner) / 20);
        }
    }

    protected void func_70088_a() {
    }

    public int getPart() {
        return this.part;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getItemByPart());
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    public void func_70016_h(double x, double y, double z) {
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.045;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.96;
        this.field_70181_x *= 0.96;
        this.field_70179_y *= 0.96;
        if (this.field_70122_E) {
            this.field_70159_w *= 0.7;
            this.field_70181_x *= 0.7;
            this.field_70179_y *= 0.7;
        }
        if (!this.field_70122_E && !this.field_70134_J) {
            this.field_70177_z += 10.0f * (float)(this.yawPositive ? 1 : -1);
            this.field_70125_A += 15.0f * (float)(this.pitchPositive ? 1 : -1);
            for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), this::canHarm)) {
                if (this.func_70027_ad()) {
                    entity.func_70015_d(EntityUtil.getFire(this) / 20);
                }
                entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this), 4.0f + (float)this.field_70146_Z.nextInt(4));
            }
            if (this.despawnTimer > 0) {
                --this.despawnTimer;
            }
        } else {
            ++this.despawnTimer;
        }
        if (!this.field_70170_p.field_72995_K && this.despawnTimer >= 6000) {
            this.func_70106_y();
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_145779_a(this.getItemByPart(), 1).func_174868_q();
        }
        player.func_184609_a(hand);
        this.func_70106_y();
        return true;
    }

    private boolean canHarm(Entity entity) {
        return entity.func_70067_L() && !(entity instanceof MutantSkeletonEntity);
    }

    public Item getItemByPart() {
        if (this.part == 0) {
            return MBItems.MUTANT_SKELETON_PELVIS;
        }
        if (this.part >= 1 && this.part < 19) {
            return MBItems.MUTANT_SKELETON_RIB;
        }
        if (this.part == 19) {
            return MBItems.MUTANT_SKELETON_SKULL;
        }
        if (this.part >= 21 && this.part < 29) {
            return MBItems.MUTANT_SKELETON_LIMB;
        }
        if (this.part == 29 || this.part == 30) {
            return MBItems.MUTANT_SKELETON_SHOULDER_PAD;
        }
        return Items.field_190931_a;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.func_95999_t() : I18n.func_74838_a((String)(this.getItemByPart().func_77658_a() + ".name"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74774_a("Part", (byte)this.part);
        compound.func_74777_a("DespawnTimer", (short)this.despawnTimer);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.part = compound.func_74771_c("Part");
        this.despawnTimer = compound.func_74765_d("DespawnTimer");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.part);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.part = additionalData.readByte();
    }
}

