/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.MBConfig;
import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.entity.ai.EntityAIAvoidDamage;
import chumbanotz.mutantbeasts.entity.ai.EntityAIHurtByNearestTarget;
import chumbanotz.mutantbeasts.entity.ai.MBEntityAIAttackMelee;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.MutatedExplosion;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILandOnOwnersShoulder;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityShoulderRiding;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CreeperMinionEntity
extends EntityShoulderRiding {
    private static final DataParameter<Byte> CREEPER_MINION_FLAGS = EntityDataManager.func_187226_a(CreeperMinionEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> EXPLODE_STATE = EntityDataManager.func_187226_a(CreeperMinionEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> EXPLOSION_RADIUS = EntityDataManager.func_187226_a(CreeperMinionEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 26;

    public CreeperMinionEntity(World worldIn) {
        super(worldIn);
        this.setDestroyBlocks(true);
        this.func_70105_a(0.3f, 0.84f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISwell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity<EntityOcelot>((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2){

            public boolean func_75250_a() {
                return !CreeperMinionEntity.this.func_70909_n() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new MBEntityAIAttackMelee((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidDamage((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new FollowOwnerGoal());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILandOnOwnersShoulder(this){

            public boolean func_75250_a() {
                return MBConfig.creeperMinionOnShoulder && CreeperMinionEntity.this.func_70909_n() && CreeperMinionEntity.this.func_70902_q() instanceof EntityPlayer && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByNearestTarget((EntityCreature)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityPlayer.class, true, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CREEPER_MINION_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(EXPLODE_STATE, (Object)-1);
        this.field_70180_af.func_187214_a(EXPLOSION_RADIUS, (Object)Float.valueOf(20.0f));
    }

    @Nullable
    public EntityLivingBase func_70902_q() {
        UUID uuid = this.func_184753_b();
        if (uuid == null) {
            return null;
        }
        EntityPlayer entity = this.field_70170_p.func_152378_a(uuid);
        if (entity == null && this.field_70170_p instanceof WorldServer) {
            entity = ((WorldServer)this.field_70170_p).func_175733_a(uuid);
        }
        return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
    }

    public int getExplodeState() {
        return (Integer)this.field_70180_af.func_187225_a(EXPLODE_STATE);
    }

    public void setExplodeState(int state) {
        this.field_70180_af.func_187227_b(EXPLODE_STATE, (Object)state);
    }

    public boolean getPowered() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 1) != 0;
    }

    public void setPowered(boolean powered) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)(powered ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean hasIgnited() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 4) != 0;
    }

    public void ignite() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)((byte)(b0 | 4)));
    }

    public boolean canExplodeContinuously() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 8) != 0;
    }

    public void setCanExplodeContinuously(boolean continuously) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)(continuously ? (byte)(b0 | 8) : (byte)(b0 & 0xFFFFFFF7)));
    }

    public boolean canDestroyBlocks() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 0x10) != 0;
    }

    public void setDestroyBlocks(boolean destroy) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)(destroy ? (byte)(b0 | 0x10) : (byte)(b0 & 0xFFFFFFEF)));
    }

    public boolean canRideOnShoulder() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 0x20) != 0;
    }

    public void setCanRideOnShoulder(boolean canRide) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)(canRide ? (byte)(b0 | 0x20) : (byte)(b0 & 0xFFFFFFDF)));
    }

    public float getExplosionRadius() {
        return ((Float)this.field_70180_af.func_187225_a(EXPLOSION_RADIUS)).floatValue() / 10.0f;
    }

    public void setExplosionRadius(float radius) {
        this.field_70180_af.func_187227_b(EXPLOSION_RADIUS, (Object)Float.valueOf(radius * 10.0f));
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((EntityLiving)this, worldIn);
    }

    public boolean func_70631_g_() {
        return false;
    }

    public boolean func_191995_du() {
        return super.func_191995_du() && this.canRideOnShoulder() && this.func_70638_az() == null && this.getExplodeState() < 0;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.setPowered(true);
    }

    public EntityLivingBase func_70638_az() {
        if (!this.func_70909_n()) {
            EntityLivingBase owner = this.func_70902_q();
            return owner instanceof MutantCreeperEntity ? ((MutantCreeperEntity)owner).func_70638_az() : super.func_70638_az();
        }
        return super.func_70638_az();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && !this.func_70909_n() && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setExplodeState(1);
            }
            if ((i = this.getExplodeState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(MBSoundEvents.ENTITY_CREEPER_MINION_PRIMED, 1.0f, this.func_70647_i());
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = 0;
                if (!this.field_70170_p.field_72995_K) {
                    MutatedExplosion.create((Entity)this, this.getExplosionRadius() + (this.getPowered() ? 2.0f : 0.0f), false, this.canDestroyBlocks());
                    if (!this.canExplodeContinuously()) {
                        if (this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.func_70902_q() instanceof EntityPlayerMP) {
                            this.func_70902_q().func_145747_a((ITextComponent)new TextComponentTranslation("death.attack.explosion", new Object[]{this.func_70005_c_()}));
                        }
                        this.field_70729_aU = true;
                        this.func_70106_y();
                        EntityUtil.spawnLingeringCloud((EntityLivingBase)this);
                    }
                }
                this.setExplodeState(-this.fuseTime);
            }
            if (this.field_70159_w * this.field_70181_x * this.field_70179_y > (double)0.8f && this.func_70638_az() != null && this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(0.5).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.timeSinceIgnited = this.fuseTime;
            }
        }
        super.func_70071_h_();
    }

    public float getCreeperFlashIntensity(float partialTicks) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * partialTicks) / (float)(this.fuseTime - 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_111282_a(player, (EntityLivingBase)this, hand)) {
            return true;
        }
        if (this.func_70909_n()) {
            if (itemstack.func_77973_b() == MBItems.CREEPER_MINION_TRACKER) {
                player.openGui((Object)MutantBeasts.INSTANCE, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
                return true;
            }
            if (!this.func_152114_e((EntityLivingBase)player)) return false;
            if (itemstack.func_77973_b() == Items.field_151016_H) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(1.0f);
                    EntityUtil.spawnParticleAtEntity((EntityLivingBase)this, EnumParticleTypes.HEART, 1, new int[0]);
                    itemstack.func_190918_g(1);
                    return true;
                }
                if (!(this.func_110138_aP() < 20.0f)) return false;
                EntityUtil.spawnParticleAtEntity((EntityLivingBase)this, EnumParticleTypes.HEART, 1, new int[0]);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.func_110138_aP() + 1.0f));
                itemstack.func_190918_g(1);
                return true;
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W)) {
                if (this.canExplodeContinuously()) {
                    float explosionRadius = this.getExplosionRadius();
                    if (!(explosionRadius < 4.0f)) return false;
                    this.field_175503_c += 5;
                    this.setExplosionRadius(explosionRadius + 0.11f);
                    itemstack.func_190918_g(1);
                    return true;
                }
                this.field_175503_c += 15;
                this.setCanExplodeContinuously(true);
                itemstack.func_190918_g(1);
                return true;
            }
            if (this.field_70170_p.field_72995_K) return true;
            this.field_70911_d.func_75270_a(!this.func_70906_o());
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151033_d && !this.hasIgnited()) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            player.func_71029_a(StatList.func_188057_b((Item)itemstack.func_77973_b()));
            if (this.field_70170_p.field_72995_K) return true;
            this.ignite();
            itemstack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        if (!player.func_184812_l_() || this.func_70902_q() != null || itemstack.func_77973_b() != MBItems.CREEPER_MINION_TRACKER) return false;
        if (this.field_70170_p.field_72995_K) return true;
        this.func_70903_f(true);
        this.func_184754_b(player.func_110124_au());
        player.func_130011_c(null);
        player.func_145747_a((ITextComponent)new TextComponentTranslation(MBItems.CREEPER_MINION_TRACKER.func_77658_a() + ".tame_success", new Object[]{this.func_70005_c_(), player.func_70005_c_()}));
        return true;
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        return EntityUtil.shouldAttackEntity(target, owner, true);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_94541_c()) {
            if (this.func_70909_n()) {
                return false;
            }
            if (amount >= 2.0f) {
                amount = 2.0f;
            }
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_180427_aV() {
        return this.func_70909_n();
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && this.func_70909_n();
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && cls != MutantCreeperEntity.class;
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    @Nullable
    public Team func_96124_cp() {
        EntityLivingBase owner = this.func_70902_q();
        return owner != null ? owner.func_96124_cp() : super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        EntityLivingBase owner = this.func_70902_q();
        return owner != null && (entityIn == owner || owner.func_184191_r(entityIn)) || super.func_184191_r(entityIn);
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public void func_70642_aH() {
        if (this.func_70638_az() == null && this.getExplodeState() <= 0) {
            super.func_70642_aH();
        }
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f;
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_CREEPER_MINION_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_CREEPER_MINION_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_CREEPER_MINION_DEATH;
    }

    public SoundCategory func_184176_by() {
        return this.func_70909_n() ? SoundCategory.NEUTRAL : SoundCategory.HOSTILE;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Tamed", this.func_70909_n());
        compound.func_74757_a("ExplodesContinuously", this.canExplodeContinuously());
        compound.func_74757_a("DestroysBlocks", this.canDestroyBlocks());
        compound.func_74757_a("CanRideOnShoulder", this.canRideOnShoulder());
        compound.func_74757_a("Ignited", this.hasIgnited());
        compound.func_74776_a("ExplosionRadius", this.getExplosionRadius());
        if (this.getPowered()) {
            compound.func_74757_a("Powered", true);
        }
        for (String unusedNBT : new String[]{"Age", "ForcedAge", "InLove", "LoveCause"}) {
            compound.func_82580_o(unusedNBT);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70903_f(compound.func_74767_n("Tamed"));
        this.setCanExplodeContinuously(compound.func_74767_n("ExplodesContinuously"));
        this.setDestroyBlocks(compound.func_74767_n("DestroysBlocks"));
        this.setCanRideOnShoulder(compound.func_74767_n("CanRideOnShoulder"));
        this.setPowered(compound.func_74767_n("Powered"));
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.setExplosionRadius(compound.func_74760_g("ExplosionRadius"));
        }
        if (compound.func_74767_n("Ignited")) {
            this.ignite();
        }
    }

    protected ResourceLocation func_184647_J() {
        return EntityUtil.getLootTable((Entity)this);
    }

    class FollowOwnerGoal
    extends EntityAIFollowOwner {
        public FollowOwnerGoal() {
            super((EntityTameable)CreeperMinionEntity.this, 1.2, 10.0f, 5.0f);
        }

        public boolean func_75250_a() {
            return CreeperMinionEntity.this.func_70638_az() == null && super.func_75250_a();
        }

        public void func_75246_d() {
            if (!CreeperMinionEntity.this.func_70909_n()) {
                if (CreeperMinionEntity.this.func_70902_q() != null) {
                    CreeperMinionEntity.this.field_70699_by.func_75497_a((Entity)CreeperMinionEntity.this.func_70902_q(), 1.2);
                }
            } else {
                super.func_75246_d();
            }
        }
    }

    class AISwell
    extends EntityAIBase {
        public AISwell() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase attackTarget = CreeperMinionEntity.this.func_70638_az();
            return !CreeperMinionEntity.this.func_70906_o() && (CreeperMinionEntity.this.getExplodeState() > 0 || attackTarget != null && CreeperMinionEntity.this.func_70068_e((Entity)attackTarget) < 9.0 && CreeperMinionEntity.this.func_70635_at().func_75522_a((Entity)attackTarget));
        }

        public void func_75249_e() {
            CreeperMinionEntity.this.field_70699_by.func_75499_g();
        }

        public void func_75246_d() {
            CreeperMinionEntity.this.setExplodeState(CreeperMinionEntity.this.func_70638_az() == null || CreeperMinionEntity.this.func_70068_e((Entity)CreeperMinionEntity.this.func_70638_az()) > 36.0 || !CreeperMinionEntity.this.func_70635_at().func_75522_a((Entity)CreeperMinionEntity.this.func_70638_az()) ? -1 : 1);
        }
    }
}

