/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.entity.projectile.ChemicalXEntity;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBParticles;
import chumbanotz.mutantbeasts.util.MutatedExplosion;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class SkullSpiritEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Boolean> ATTACHED = EntityDataManager.func_187226_a(SkullSpiritEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private int startTick = 15;
    private int attachedTick = 80 + this.field_70146_Z.nextInt(40);
    private int targetId;
    private UUID targetUUID;

    public SkullSpiritEntity(World world) {
        super(world);
        this.field_70145_X = true;
        this.func_70105_a(0.1f, 0.1f);
    }

    public SkullSpiritEntity(World world, EntityLiving target) {
        this(world);
        this.targetId = target.func_145782_y();
        this.targetUUID = target.func_110124_au();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ATTACHED, (Object)false);
    }

    public boolean isAttached() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACHED);
    }

    private void setAttached(boolean attached) {
        this.field_70180_af.func_187227_b(ATTACHED, (Object)attached);
    }

    public boolean func_145773_az() {
        return true;
    }

    public Entity getTarget() {
        if (this.targetUUID != null && this.field_70170_p instanceof WorldServer) {
            return ((WorldServer)this.field_70170_p).func_175733_a(this.targetUUID);
        }
        return this.field_70170_p.func_73045_a(this.targetId);
    }

    public void func_70071_h_() {
        Entity target = this.getTarget();
        if (target != null && target.func_70089_S()) {
            if (this.isAttached()) {
                if (!this.field_70170_p.field_72995_K) {
                    target.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f;
                    target.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f;
                    if (--this.attachedTick <= 0 && target instanceof EntityLiving) {
                        EntityLiving mob = (EntityLiving)target;
                        Class<? extends EntityLiving> mutantClass = ChemicalXEntity.getMutantOf(mob);
                        if (mutantClass != null && this.field_70146_Z.nextFloat() < 0.75f) {
                            MutatedExplosion.create(this, 2.0f, false, false);
                            EntityLiving mutant = EntityUtil.convertMobWithNBT((EntityLivingBase)mob, (EntityLiving)EntityList.func_191304_a(mutantClass, (World)this.field_70170_p), true);
                            mutant.func_110163_bv();
                            AxisAlignedBB bb = mutant.func_174813_aQ();
                            for (BlockPos pos : BlockPos.func_191532_a((int)MathHelper.func_76128_c((double)bb.field_72340_a), (int)MathHelper.func_76128_c((double)bb.field_72338_b), (int)MathHelper.func_76128_c((double)bb.field_72339_c), (int)MathHelper.func_76128_c((double)bb.field_72336_d), (int)MathHelper.func_76128_c((double)bb.field_72337_e), (int)MathHelper.func_76128_c((double)bb.field_72334_f))) {
                                if (!(this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos) >= 0.0f)) continue;
                                this.field_70170_p.func_175655_b(pos, true);
                            }
                            for (EntityPlayerMP entityplayermp : this.field_70170_p.func_72872_a(EntityPlayerMP.class, bb.func_186662_g(5.0))) {
                                CriteriaTriggers.field_192133_m.func_192229_a(entityplayermp, (Entity)mutant);
                            }
                        } else {
                            this.setAttached(false);
                            MutatedExplosion.create(this, 2.0f, false, false);
                        }
                        this.func_70106_y();
                    }
                }
                this.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                if (this.field_70146_Z.nextInt(8) == 0) {
                    target.func_70097_a(DamageSource.field_76376_m, 0.0f);
                }
                for (int i = 0; i < 3; ++i) {
                    double posX = target.field_70165_t + (double)(this.field_70146_Z.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N;
                    double posY = target.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * target.field_70131_O);
                    double posZ = target.field_70161_v + (double)(this.field_70146_Z.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N;
                    double x = this.field_70146_Z.nextGaussian() * 0.02;
                    double y = this.field_70146_Z.nextGaussian() * 0.02;
                    double z = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(MBParticles.SKULL_SPIRIT, posX, posY, posZ, x, y, z, new int[0]);
                }
            } else {
                this.field_70169_q = this.field_70165_t;
                this.field_70167_r = this.field_70163_u;
                this.field_70166_s = this.field_70161_v;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.startTick-- >= 0) {
                    this.field_70181_x += (double)(0.3f * (float)this.startTick / 15.0f);
                }
                double x = target.field_70165_t - this.field_70165_t;
                double y = target.field_70163_u - this.field_70163_u;
                double z = target.field_70161_v - this.field_70161_v;
                double d = Math.sqrt(x * x + y * y + z * z);
                this.field_70159_w += x / d * (double)0.2f;
                this.field_70181_x += y / d * (double)0.2f;
                this.field_70179_y += z / d * (double)0.2f;
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (!this.field_70170_p.field_72995_K && this.func_70068_e(target) < 1.0) {
                    this.setAttached(true);
                }
                for (int i = 0; i < 16; ++i) {
                    float xx = (this.field_70146_Z.nextFloat() - 0.5f) * 1.2f;
                    float yy = (this.field_70146_Z.nextFloat() - 0.5f) * 1.2f;
                    float zz = (this.field_70146_Z.nextFloat() - 0.5f) * 1.2f;
                    this.field_70170_p.func_175688_a(MBParticles.SKULL_SPIRIT, this.field_70165_t + (double)xx, this.field_70163_u + (double)yy, this.field_70161_v + (double)zz, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else {
            this.func_70106_y();
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("Attached", this.isAttached());
        compound.func_74768_a("AttachedTick", this.attachedTick);
        if (this.targetUUID != null) {
            compound.func_186854_a("Target", this.targetUUID);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setAttached(compound.func_74767_n("Attached"));
        this.attachedTick = compound.func_74762_e("AttachedTick");
        if (compound.func_186855_b("Target")) {
            this.targetUUID = compound.func_186857_a("Target");
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.targetId);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.targetId = additionalData.readInt();
    }
}

