/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.entity.BodyPartEntity;
import chumbanotz.mutantbeasts.entity.ai.EntityAIAvoidDamage;
import chumbanotz.mutantbeasts.entity.ai.EntityAIHurtByNearestTarget;
import chumbanotz.mutantbeasts.entity.ai.MBEntityAIAttackMelee;
import chumbanotz.mutantbeasts.entity.projectile.MutantArrowEntity;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MutantSkeletonEntity
extends EntityMob
implements IAnimatedEntity {
    public static final byte MELEE_ATTACK = 1;
    public static final byte SHOOT_ATTACK = 2;
    public static final byte MULTI_SHOT_ATTACK = 3;
    public static final byte CONSTRICT_RIBS_ATTACK = 4;
    private int attackID;
    private int attackTick;

    public MutantSkeletonEntity(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 30;
        this.func_70105_a(1.2f, 3.6f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MeleeGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ShootGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MultiShotGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ConstrictRibsAttackGoal());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MBEntityAIAttackMelee((EntityCreature)this, 1.1).setMaxAttackTick(10));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidDamage((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByNearestTarget((EntityCreature)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWolf.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(5.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((EntityLiving)this, worldIn);
    }

    public float func_70047_e() {
        return 3.25f;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70103_a(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attackTick = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackID != 0) {
            ++this.attackTick;
        }
        if (!this.field_70170_p.func_72935_r() && this.field_70173_aa % 100 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(2.0f);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.attackID == 0) {
            this.attackID = this.field_70146_Z.nextInt(4) != 0 ? 1 : 4;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !(source.func_76346_g() instanceof MutantSkeletonEntity) && super.func_70097_a(source, amount);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return super.func_184228_n(entityIn) && entityIn instanceof EntityLivingBase;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public int getAnimationID() {
        return this.attackID;
    }

    @Override
    public void setAnimationID(int id) {
        this.attackID = id;
    }

    @Override
    public int getAnimationTick() {
        return this.attackTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.attackTick = tick;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (EntityLivingBase entityLivingBase : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(3.0, 2.0, 3.0))) {
                entityLivingBase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 7.0f);
            }
            for (int i = 0; i < 18; ++i) {
                int j = i;
                if (i >= 3) {
                    j = i + 1;
                }
                if (j >= 4) {
                    ++j;
                }
                if (j >= 5) {
                    ++j;
                }
                if (j >= 6) {
                    ++j;
                }
                if (j >= 9) {
                    ++j;
                }
                if (j >= 10) {
                    ++j;
                }
                if (j >= 11) {
                    ++j;
                }
                if (j >= 12) {
                    ++j;
                }
                if (j >= 15) {
                    ++j;
                }
                if (j >= 16) {
                    ++j;
                }
                if (j >= 17) {
                    ++j;
                }
                if (j >= 18) {
                    ++j;
                }
                if (j >= 20) {
                    ++j;
                }
                BodyPartEntity part = new BodyPartEntity(this.field_70170_p, (EntityLiving)this, j);
                part.field_70159_w += (double)(this.field_70146_Z.nextFloat() * 0.8f * 2.0f - 0.8f);
                part.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.25f + 0.1f);
                part.field_70179_y += (double)(this.field_70146_Z.nextFloat() * 0.8f * 2.0f - 0.8f);
                this.field_70170_p.func_72838_d((Entity)part);
            }
        }
        this.field_70725_aQ = 19;
    }

    protected void func_70629_bd() {
        this.field_70181_x += (double)0.04f;
    }

    protected void func_180466_bG() {
        this.func_70629_bd();
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_SKELETON_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_SKELETON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_SKELETON_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_SKELETON_STEP, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return EntityUtil.getLootTable((Entity)this);
    }

    private void setAttackID(int id) {
        this.attackID = id;
        this.attackTick = 0;
        this.field_70170_p.func_72960_a((Entity)this, (byte)(-id));
    }

    class MultiShotGoal
    extends EntityAIBase {
        private EntityLivingBase attackTarget;
        private final List<MutantArrowEntity> shots = new ArrayList<MutantArrowEntity>();

        public MultiShotGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantSkeletonEntity.this.func_70638_az();
            return this.attackTarget != null && MutantSkeletonEntity.this.attackID == 0 && (MutantSkeletonEntity.this.field_70122_E && MutantSkeletonEntity.this.field_70146_Z.nextInt(26) == 0 && MutantSkeletonEntity.this.func_70635_at().func_75522_a((Entity)this.attackTarget) || MutantSkeletonEntity.this.func_184187_bx() == this.attackTarget);
        }

        public void func_75249_e() {
            MutantSkeletonEntity.this.setAttackID(3);
        }

        public boolean func_75253_b() {
            return MutantSkeletonEntity.this.attackTick < 30;
        }

        public void func_75246_d() {
            MutantSkeletonEntity.this.func_70661_as().func_75499_g();
            MutantSkeletonEntity.this.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (MutantSkeletonEntity.this.attackTick == 10) {
                MutantSkeletonEntity.this.func_184210_p();
                double x = this.attackTarget.field_70165_t - MutantSkeletonEntity.this.field_70165_t;
                double z = this.attackTarget.field_70161_v - MutantSkeletonEntity.this.field_70161_v;
                float scale = 0.06f + MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.03f;
                if (MutantSkeletonEntity.this.func_70068_e((Entity)this.attackTarget) < 16.0) {
                    x *= -1.0;
                    z *= -1.0;
                    scale *= 5.0f;
                }
                MutantSkeletonEntity.this.field_70134_J = false;
                MutantSkeletonEntity.this.field_70159_w = x * (double)scale;
                MutantSkeletonEntity.this.field_70181_x = 1.1f;
                MutantSkeletonEntity.this.field_70179_y = z * (double)scale;
            }
            if (MutantSkeletonEntity.this.attackTick >= 24 && MutantSkeletonEntity.this.attackTick < 28) {
                if (!this.shots.isEmpty()) {
                    Iterator<MutantArrowEntity> iterator = this.shots.iterator();
                    while (iterator.hasNext()) {
                        MutantArrowEntity arrowEntity;
                        MutantArrowEntity shot = arrowEntity = iterator.next();
                        MutantSkeletonEntity.this.field_70170_p.func_72838_d((Entity)arrowEntity);
                    }
                    this.shots.clear();
                }
                for (int i = 0; i < 6; ++i) {
                    MutantArrowEntity shot = new MutantArrowEntity(MutantSkeletonEntity.this.field_70170_p, (EntityLivingBase)MutantSkeletonEntity.this, this.attackTarget);
                    shot.setSpeed(1.2f - MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.1f);
                    shot.setClones(2);
                    shot.randomize(3.0f);
                    shot.setDamage(5 + MutantSkeletonEntity.this.field_70146_Z.nextInt(5));
                    this.shots.add(shot);
                }
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.25f);
            }
        }

        public void func_75251_c() {
            MutantSkeletonEntity.this.setAttackID(0);
            this.shots.clear();
            this.attackTarget = null;
        }
    }

    class ShootGoal
    extends EntityAIBase {
        private EntityLivingBase attackTarget;

        public ShootGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantSkeletonEntity.this.func_70638_az();
            return this.attackTarget != null && MutantSkeletonEntity.this.attackID == 0 && MutantSkeletonEntity.this.field_70146_Z.nextInt(12) == 0 && MutantSkeletonEntity.this.func_70068_e((Entity)this.attackTarget) > 4.0 && MutantSkeletonEntity.this.func_70635_at().func_75522_a((Entity)this.attackTarget);
        }

        public void func_75249_e() {
            MutantSkeletonEntity.this.setAttackID(2);
        }

        public boolean func_75253_b() {
            return MutantSkeletonEntity.this.attackTick < 32;
        }

        public void func_75246_d() {
            MutantSkeletonEntity.this.func_70661_as().func_75499_g();
            MutantSkeletonEntity.this.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (MutantSkeletonEntity.this.attackTick == 26 && this.attackTarget.func_70089_S()) {
                MutantArrowEntity arrowEntity = new MutantArrowEntity(MutantSkeletonEntity.this.field_70170_p, (EntityLivingBase)MutantSkeletonEntity.this, this.attackTarget);
                if (MutantSkeletonEntity.this.field_70737_aN > 0) {
                    arrowEntity.randomize((float)MutantSkeletonEntity.this.field_70737_aN / 2.0f);
                } else if (!MutantSkeletonEntity.this.func_70635_at().func_75522_a((Entity)this.attackTarget)) {
                    arrowEntity.randomize((float)MutantSkeletonEntity.this.func_70068_e((Entity)this.attackTarget));
                }
                if (MutantSkeletonEntity.this.field_70146_Z.nextInt(4) == 0) {
                    arrowEntity.setPotionEffect(new PotionEffect(MobEffects.field_76436_u, 80 + MutantSkeletonEntity.this.field_70146_Z.nextInt(60), 0));
                }
                if (MutantSkeletonEntity.this.field_70146_Z.nextInt(4) == 0) {
                    arrowEntity.setPotionEffect(new PotionEffect(MobEffects.field_76438_s, 120 + MutantSkeletonEntity.this.field_70146_Z.nextInt(60), 1));
                }
                if (MutantSkeletonEntity.this.field_70146_Z.nextInt(4) == 0) {
                    arrowEntity.setPotionEffect(new PotionEffect(MobEffects.field_76421_d, 120 + MutantSkeletonEntity.this.field_70146_Z.nextInt(60), 1));
                }
                MutantSkeletonEntity.this.field_70170_p.func_72838_d((Entity)arrowEntity);
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.25f);
            }
        }

        public void func_75251_c() {
            MutantSkeletonEntity.this.setAttackID(0);
            this.attackTarget = null;
        }
    }

    class ConstrictRibsAttackGoal
    extends EntityAIBase {
        private EntityLivingBase attackTarget;

        public ConstrictRibsAttackGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantSkeletonEntity.this.func_70638_az();
            return this.attackTarget != null && MutantSkeletonEntity.this.attackID == 4;
        }

        public boolean func_75253_b() {
            return MutantSkeletonEntity.this.attackTick < 20;
        }

        public void func_75249_e() {
            MutantSkeletonEntity.this.setAttackID(4);
        }

        public void func_75246_d() {
            MutantSkeletonEntity.this.func_70661_as().func_75499_g();
            if (MutantSkeletonEntity.this.attackTick == 5) {
                this.attackTarget.func_184210_p();
            }
            if (MutantSkeletonEntity.this.attackTick == 6) {
                float damage = (float)MutantSkeletonEntity.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                this.attackTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)MutantSkeletonEntity.this), damage > 0.0f ? damage + 5.0f : 0.0f);
                this.attackTarget.field_70159_w = (1.0f + MutantSkeletonEntity.this.func_70681_au().nextFloat() * 0.4f) * (float)(MutantSkeletonEntity.this.func_70681_au().nextBoolean() ? 1 : -1);
                this.attackTarget.field_70181_x = 0.4f + MutantSkeletonEntity.this.func_70681_au().nextFloat() * 0.8f;
                this.attackTarget.field_70179_y = (1.0f + MutantSkeletonEntity.this.func_70681_au().nextFloat() * 0.4f) * (float)(MutantSkeletonEntity.this.func_70681_au().nextBoolean() ? 1 : -1);
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_187539_bB, 0.5f, 0.8f + MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f);
                EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
                EntityUtil.disableShield(this.attackTarget, 100);
            }
        }

        public void func_75251_c() {
            MutantSkeletonEntity.this.setAttackID(0);
            this.attackTarget = null;
        }
    }

    class MeleeGoal
    extends EntityAIBase {
        public MeleeGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return MutantSkeletonEntity.this.attackID == 1;
        }

        public boolean func_75253_b() {
            return MutantSkeletonEntity.this.attackTick < 14;
        }

        public void func_75249_e() {
            MutantSkeletonEntity.this.setAttackID(1);
        }

        public void func_75246_d() {
            MutantSkeletonEntity.this.func_70661_as().func_75499_g();
            if (MutantSkeletonEntity.this.func_70638_az() != null && MutantSkeletonEntity.this.func_70638_az().func_70089_S()) {
                MutantSkeletonEntity.this.func_70671_ap().func_75651_a((Entity)MutantSkeletonEntity.this.func_70638_az(), 30.0f, 30.0f);
            }
            if (MutantSkeletonEntity.this.attackTick == 3) {
                DamageSource damageSource = DamageSource.func_76358_a((EntityLivingBase)MutantSkeletonEntity.this);
                for (Entity entity : MutantSkeletonEntity.this.field_70170_p.func_72839_b((Entity)MutantSkeletonEntity.this, MutantSkeletonEntity.this.func_174813_aQ().func_186662_g(4.0))) {
                    if (!entity.func_70067_L() || entity instanceof MutantSkeletonEntity) continue;
                    double dist = MutantSkeletonEntity.this.func_70032_d(entity);
                    double x = MutantSkeletonEntity.this.field_70165_t - entity.field_70165_t;
                    double z = MutantSkeletonEntity.this.field_70161_v - entity.field_70161_v;
                    if (!(dist <= (double)(2.3f + MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.3f)) || !(EntityUtil.getHeadAngle((EntityLivingBase)MutantSkeletonEntity.this, x, z) < 60.0f)) continue;
                    float power = 1.8f + (float)MutantSkeletonEntity.this.field_70146_Z.nextInt(5) * 0.15f;
                    if (!entity.func_70097_a(damageSource, (float)MutantSkeletonEntity.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) {
                        EntityUtil.knockBackBlockingPlayer(entity);
                    }
                    entity.field_70159_w = -x / dist * (double)power;
                    entity.field_70181_x = Math.max((double)0.28f, entity.field_70181_x);
                    entity.field_70179_y = -z / dist * (double)power;
                }
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_187721_dT, 1.0f, 1.0f / (MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f + 1.2f));
            }
        }

        public void func_75251_c() {
            MutantSkeletonEntity.this.setAttackID(0);
        }
    }
}

