/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.item;

import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBParticles;
import com.google.common.collect.Multimap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class EndersoulHandItem
extends Item {
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EntityEquipmentSlot.MAINHAND;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public int func_77619_b() {
        return 20;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y == EnumEnchantmentType.WEAPON && enchantment != Enchantments.field_191530_r;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (!EndersoulHandItem.canCarry(worldIn, pos, blockState)) {
            return EnumActionResult.FAIL;
        }
        if (!worldIn.canMineBlockBody(player, pos)) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos, facing, player.func_184586_b(hand))) {
            return EnumActionResult.FAIL;
        }
        if (worldIn.func_175625_s(pos) != null) {
            return EnumActionResult.FAIL;
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_72838_d((Entity)new ThrowableBlockEntity(worldIn, player, blockState, pos));
            worldIn.func_175698_g(pos);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.func_70093_af()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult result = EndersoulHandItem.rayTrace(playerIn, 128.0);
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("Unable to teleport to location", new Object[0]), true);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!worldIn.field_72995_K) {
            BlockPos startPos = result.func_178782_a();
            BlockPos endPos = startPos.func_177972_a(result.field_178784_b);
            BlockPos posDown = startPos.func_177977_b();
            if (!worldIn.func_175623_d(posDown) || !worldIn.func_180495_p(posDown).func_185904_a().func_76230_c()) {
                for (int tries = 0; tries < 3; ++tries) {
                    BlockPos checkPos = startPos.func_177981_b(tries + 1);
                    if (!worldIn.func_175623_d(checkPos)) continue;
                    endPos = checkPos;
                    break;
                }
            }
            worldIn.func_184148_a(null, playerIn.field_70169_q, playerIn.field_70167_r, playerIn.field_70166_s, SoundEvents.field_187544_ad, playerIn.func_184176_by(), 1.0f, 1.0f);
            playerIn.func_70634_a((double)endPos.func_177958_n() + 0.5, (double)endPos.func_177956_o(), (double)endPos.func_177952_p() + 0.5);
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187544_ad, playerIn.func_184176_by(), 1.0f, 1.0f);
            MutantEndermanEntity.teleportAttack((EntityLivingBase)playerIn);
            EntityUtil.sendParticlePacket((Entity)playerIn, MBParticles.ENDERSOUL, 256);
            playerIn.func_184811_cZ().func_185145_a((Item)this, 40);
            stack.func_77972_a(4, (EntityLivingBase)playerIn);
        }
        playerIn.field_70143_R = 0.0f;
        playerIn.func_184609_a(handIn);
        playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 5.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, 0));
        }
        return multimap;
    }

    public static RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance) {
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, true, false);
    }

    public static boolean canCarry(World world, BlockPos pos, IBlockState blockState) {
        return blockState.func_185914_p() && blockState.func_185887_b(world, pos) > -1.0f;
    }
}

