/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import chumbanotz.mutantbeasts.packet.SpawnParticlePacket;
import chumbanotz.mutantbeasts.util.MBParticles;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityUtil {
    private static final Field FIRE = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_190534_ay");

    public static int getFire(Entity entity) {
        try {
            return FIRE.getInt(entity);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Failed to access fire timer for " + entity, e);
        }
    }

    public static float getHeadAngle(EntityLivingBase livingEntity, double x, double z) {
        return Math.abs(MathHelper.func_76142_g((float)(livingEntity.field_70759_as - ((float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f))));
    }

    public static void spawnLingeringCloud(EntityLivingBase entityLivingBase) {
        Collection collection = entityLivingBase.func_70651_bq();
        if (!collection.isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(entityLivingBase.field_70170_p, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v);
            entityareaeffectcloud.func_184483_a(2.5f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            for (PotionEffect potioneffect : collection) {
                entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
            }
            entityLivingBase.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    public static void disableShield(EntityLivingBase entityLivingBase, int ticks) {
        if (entityLivingBase instanceof EntityPlayer && entityLivingBase.func_184585_cz()) {
            ((EntityPlayer)entityLivingBase).func_184811_cZ().func_185145_a(entityLivingBase.func_184607_cu().func_77973_b(), ticks);
            entityLivingBase.func_184602_cy();
            entityLivingBase.field_70170_p.func_72960_a((Entity)entityLivingBase, (byte)30);
        }
    }

    public static void knockBackBlockingPlayer(Entity target) {
        if (target instanceof EntityPlayer && ((EntityPlayer)target).func_184585_cz()) {
            target.field_70133_I = true;
        }
    }

    public static void sendPlayerVelocityPacket(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
        }
    }

    public static boolean shouldAttackEntity(EntityLivingBase target, EntityLivingBase owner, boolean canTargetCreepers) {
        if (owner instanceof EntityPlayer) {
            if (target instanceof EntityCreeper) {
                return canTargetCreepers;
            }
            if (target instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            if (target instanceof EntityGolem & !(target instanceof IMob)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return true;
    }

    public static void dropExperience(EntityLiving mob, int recentlyHit, Function<EntityPlayer, Integer> experiencePoints, EntityPlayer attackingPlayer) {
        if (!mob.field_70170_p.field_72995_K && recentlyHit > 0 && mob.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            int j;
            int i = experiencePoints.apply(attackingPlayer);
            for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)mob, (EntityPlayer)attackingPlayer, (int)i); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                mob.field_70170_p.func_72838_d((Entity)new EntityXPOrb(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, j));
            }
        }
    }

    public static EntityLiving convertMobWithNBT(EntityLivingBase oldEntity, EntityLiving newEntity, boolean dropInventory) {
        if (oldEntity.field_70128_L) {
            return null;
        }
        NBTTagCompound copiedNBT = oldEntity.func_189511_e(new NBTTagCompound());
        copiedNBT.func_186854_a("UUID", newEntity.func_110124_au());
        copiedNBT.func_74782_a("Attributes", (NBTBase)SharedMonsterAttributes.func_111257_a((AbstractAttributeMap)newEntity.func_110140_aT()));
        copiedNBT.func_74776_a("Health", newEntity.func_110143_aJ());
        if (oldEntity.func_96124_cp() != null) {
            copiedNBT.func_74778_a("Team", oldEntity.func_96124_cp().func_96661_b());
        }
        if (copiedNBT.func_150297_b("ActiveEffects", 9)) {
            NBTTagList activeEffects = copiedNBT.func_150295_c("ActiveEffects", 10);
            for (int i = 0; i < activeEffects.func_74745_c(); ++i) {
                NBTTagCompound compound = activeEffects.func_150305_b(i);
                PotionEffect potionEffect = PotionEffect.func_82722_b((NBTTagCompound)compound);
                if (potionEffect == null || newEntity.func_70687_e(potionEffect)) continue;
                activeEffects.func_74744_a(i);
                --i;
            }
        }
        if (dropInventory && oldEntity.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            IBlockState iblockstate;
            ItemStack itemStack;
            copiedNBT.func_74757_a("CanPickUpLoot", false);
            if (copiedNBT.func_150297_b("ArmorItems", 9)) {
                NBTTagList armorItems = copiedNBT.func_150295_c("ArmorItems", 10);
                NBTTagList armorDropChances = copiedNBT.func_150295_c("ArmorDropChances", 5);
                for (int i = 0; i < armorItems.func_74745_c(); ++i) {
                    itemStack = new ItemStack(armorItems.func_150305_b(i));
                    if (itemStack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemStack) || !(armorDropChances.func_150308_e(i) > 1.0f)) continue;
                    oldEntity.func_70099_a(itemStack, 0.0f);
                }
                copiedNBT.func_74782_a("ArmorItems", (NBTBase)new NBTTagList());
                copiedNBT.func_74782_a("ArmorDropChances", (NBTBase)new NBTTagList());
            }
            if (copiedNBT.func_150297_b("HandItems", 9)) {
                NBTTagList handItems = copiedNBT.func_150295_c("HandItems", 10);
                NBTTagList handDropChances = copiedNBT.func_150295_c("HandDropChances", 5);
                for (int i = 0; i < handItems.func_74745_c(); ++i) {
                    itemStack = new ItemStack(handItems.func_150305_b(i));
                    if (!itemStack.func_190926_b() && !EnchantmentHelper.func_190939_c((ItemStack)itemStack) && handDropChances.func_150308_e(i) > 1.0f) {
                        oldEntity.func_70099_a(itemStack, 0.0f);
                    }
                    copiedNBT.func_74782_a("HandItems", (NBTBase)new NBTTagList());
                    copiedNBT.func_74782_a("HandDropChances", (NBTBase)new NBTTagList());
                }
            }
            if (oldEntity instanceof EntityEnderman && (iblockstate = Block.func_149729_e((int)copiedNBT.func_74765_d("carried")).func_176203_a(copiedNBT.func_74765_d("carriedData") & 0xFFFF)) != null && iblockstate.func_177230_c() != null && iblockstate.func_185904_a() != Material.field_151579_a) {
                Item item = Item.func_150898_a((Block)iblockstate.func_177230_c());
                int i = item.func_77614_k() ? iblockstate.func_177230_c().func_176201_c(iblockstate) : 0;
                oldEntity.func_70099_a(new ItemStack(item, 1, i), 0.0f);
            }
        }
        newEntity.func_70020_e(copiedNBT);
        oldEntity.field_70170_p.func_72838_d((Entity)newEntity);
        oldEntity.func_70106_y();
        return newEntity;
    }

    public static ResourceLocation getLootTable(Entity entity) {
        return MutantBeasts.prefix("entities/" + EntityList.func_191301_a((Entity)entity).func_110623_a());
    }

    public static void spawnParticleAtEntity(EntityLivingBase entity, EnumParticleTypes particleType, int amount, int ... parameters) {
        if (entity.field_70170_p.field_72995_K) {
            for (int i = 0; i < amount; ++i) {
                double posX = entity.field_70165_t + (double)(entity.func_70681_au().nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N;
                double posY = entity.field_70163_u + 0.5 + (double)(entity.func_70681_au().nextFloat() * entity.field_70131_O);
                double posZ = entity.field_70161_v + (double)(entity.func_70681_au().nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N;
                double x = entity.func_70681_au().nextGaussian() * 0.02;
                double y = entity.func_70681_au().nextGaussian() * 0.02;
                double z = entity.func_70681_au().nextGaussian() * 0.02;
                entity.field_70170_p.func_175688_a(particleType, posX, posY, posZ, x, y, z, parameters);
            }
        }
    }

    public static void spawnEndersoulParticles(Entity entity, int amount, float speed) {
        for (int i = 0; i < amount; ++i) {
            float f = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
            float f1 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
            float f2 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
            double tempX = entity.field_70165_t + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.field_70130_N);
            double tempY = entity.field_70163_u + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.field_70131_O) + 0.5;
            double tempZ = entity.field_70161_v + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.field_70130_N);
            entity.field_70170_p.func_175688_a(MBParticles.ENDERSOUL, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2, new int[0]);
        }
    }

    public static void sendParticlePacket(Entity entity, EnumParticleTypes particleType, int amount) {
        MBPacketHandler.INSTANCE.sendToAllAround((IMessage)new SpawnParticlePacket(particleType, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70130_N, entity.field_70131_O, entity.field_70130_N, amount), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1024.0));
    }

    public static Vec3d getDirVector(float rotation, float scale) {
        float rad = rotation * ((float)Math.PI / 180);
        return new Vec3d((double)(-MathHelper.func_76126_a((float)rad) * scale), 0.0, (double)(MathHelper.func_76134_b((float)rad) * scale));
    }

    public static boolean teleportTo(EntityLiving mob, double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().func_189532_c(x, y, z);
        if (mob.field_70170_p.func_175667_e((BlockPos)pos)) {
            do {
                pos.func_189536_c(EnumFacing.DOWN);
            } while (pos.func_177956_o() > 0 && !mob.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76230_c());
            pos.func_189536_c(EnumFacing.UP);
        }
        if (!mob.func_70038_c((double)(pos.func_177958_n() - MathHelper.func_76128_c((double)mob.field_70165_t)), (double)(pos.func_177956_o() - MathHelper.func_76128_c((double)mob.field_70163_u)), (double)(pos.func_177952_p() - MathHelper.func_76128_c((double)mob.field_70161_v)))) {
            return false;
        }
        mob.func_174828_a((BlockPos)pos, mob.field_70177_z, mob.field_70125_A);
        mob.func_70661_as().func_75499_g();
        return true;
    }

    public static void divertAttackers(EntityLiving targetedMob, EntityLivingBase newTarget) {
        for (EntityLiving mob : targetedMob.field_70170_p.func_72872_a(EntityLiving.class, targetedMob.func_174813_aQ().func_72314_b(16.0, 10.0, 16.0))) {
            if (mob == targetedMob || mob == newTarget || mob.func_70638_az() != targetedMob) continue;
            mob.func_70624_b(newTarget);
        }
    }
}

