/*
 * Decompiled with CFR 0.152.
 */
package com.mrbelieve.mvw.bowstuff;

import com.mrbelieve.mvw.bowstuff.CapabilityHelper;
import com.mrbelieve.mvw.bowstuff.IRangedWeapon;
import com.mrbelieve.mvw.bowstuff.IWeapon;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractModBowItem
extends BowItem
implements IRangedWeapon {
    private float defaultChargeTime;

    public AbstractModBowItem(float defaultChargeTimeIn, Item.Properties builder) {
        super(builder);
        this.defaultChargeTime = defaultChargeTimeIn;
    }

    public float getDefaultChargeTime() {
        return this.defaultChargeTime;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)livingEntity;
            boolean useInfiniteAmmo = playerentity.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = playerentity.func_213356_f(stack);
            int charge = this.func_77626_a(stack) - timeLeft;
            if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (PlayerEntity)playerentity, (int)charge, (!itemstack.func_190926_b() || useInfiniteAmmo ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || useInfiniteAmmo) {
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                float arrowVelocity = this.getBowArrowVelocity(stack, charge);
                this.fireArrows(stack, world, playerentity, itemstack, arrowVelocity);
            }
        }
    }

    public void fireArrows(ItemStack stack, World world, PlayerEntity playerentity, ItemStack itemstack, float arrowVelocity) {
        int multishotLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack);
        int arrowsToFire = 1;
        if (multishotLevel > 0) {
            arrowsToFire += 2;
        }
        if (this.hasMultishotBuiltIn(stack)) {
            arrowsToFire += 2;
        }
        if (this.hasMultishotWhenCharged(stack) && arrowVelocity == 1.0f) {
            arrowsToFire += 2;
        }
        for (int arrowNumber = 0; arrowNumber < arrowsToFire; ++arrowNumber) {
            boolean isAdditionalShot;
            if (!((double)arrowVelocity >= 0.1)) continue;
            boolean hasInfiniteAmmo = playerentity.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ArrowItem && ((ArrowItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, playerentity);
            boolean bl = isAdditionalShot = arrowNumber > 0;
            if (!world.field_72995_K) {
                this.createBowArrow(stack, world, playerentity, itemstack, arrowVelocity, arrowNumber, hasInfiniteAmmo, isAdditionalShot);
            }
            world.func_184148_a((PlayerEntity)null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
            if (!(hasInfiniteAmmo || playerentity.field_71075_bZ.field_75098_d || isAdditionalShot)) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    playerentity.field_71071_by.func_184437_d(itemstack);
                }
            }
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
    }

    public void createBowArrow(ItemStack stack, World world, PlayerEntity playerentity, ItemStack itemstack, float arrowVelocity, int i, boolean hasInfiniteAmmo, boolean isAdditionalShot) {
        ArrowItem arrowitem = (ArrowItem)(itemstack.func_77973_b() instanceof ArrowItem ? itemstack.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(world, itemstack, (LivingEntity)playerentity);
        abstractarrowentity = this.customArrow(abstractarrowentity);
        this.setArrowTrajectory(playerentity, arrowVelocity, i, abstractarrowentity);
        if (arrowVelocity == 1.0f) {
            abstractarrowentity.func_70243_d(true);
        }
        int powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        if (this.hasPowerBuiltIn(stack)) {
            ++powerLevel;
        }
        if (this.shootsStrongChargedArrows(stack) && abstractarrowentity.func_70241_g()) {
            ++powerLevel;
        }
        if (this.hasSuperChargedBuiltIn(stack) && abstractarrowentity.func_70241_g()) {
            ++powerLevel;
        }
        if (this.shootsHeavyArrows(stack)) {
            ++powerLevel;
        }
        if (powerLevel > 0) {
            abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
        }
        int punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
        if (this.hasPunchBuiltIn(stack)) {
            ++punchLevel;
        }
        if (this.hasSuperChargedBuiltIn(stack)) {
            ++punchLevel;
        }
        if (punchLevel > 0) {
            abstractarrowentity.func_70240_a(punchLevel);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
            abstractarrowentity.func_70015_d(100);
        }
        stack.func_222118_a(1, (LivingEntity)playerentity, p_lambda$onPlayerStoppedUsing$0_1_ -> p_lambda$onPlayerStoppedUsing$0_1_.func_213334_d(playerentity.func_184600_cs()));
        if (hasInfiniteAmmo || playerentity.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
            abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        if (isAdditionalShot) {
            abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        world.func_217376_c((Entity)abstractarrowentity);
    }

    public void setArrowTrajectory(PlayerEntity playerentity, float arrowVelocity, int i, AbstractArrowEntity abstractarrowentity) {
        if (i == 0) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 1) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 10.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 2) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z - 10.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 3) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 20.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 4) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z - 20.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 5) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 30.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 6) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z - 30.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
    }

    public float getBowArrowVelocity(ItemStack stack, int charge) {
        float bowChargeTime = this.getBowChargeTime(stack);
        if (bowChargeTime <= 0.0f) {
            bowChargeTime = 1.0f;
        }
        float arrowVelocity = (float)charge / bowChargeTime;
        if ((arrowVelocity = (arrowVelocity * arrowVelocity + arrowVelocity * 2.0f) / 3.0f) > 1.0f) {
            arrowVelocity = 1.0f;
        }
        return arrowVelocity;
    }

    public float getBowChargeTime(ItemStack stack) {
        IWeapon weaponCap;
        int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        if (this.hasQuickChargeBuiltIn(stack)) {
            ++quickChargeLevel;
        }
        if ((weaponCap = CapabilityHelper.getWeaponCapability(stack)) == null) {
            return Math.max(this.getDefaultChargeTime() - (float)(5 * quickChargeLevel), 0.0f);
        }
        float bowChargeTime = weaponCap.getBowChargeTime();
        long lastFiredTime = weaponCap.getLastFiredTime();
        return Math.max(this.getDefaultChargeTime() - (float)(5 * quickChargeLevel), 0.0f);
    }
}

