/*
 * Decompiled with CFR 0.152.
 */
package com.mrbelieve.mvw.items;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mrbelieve.mvw.ModConfig;
import com.mrbelieve.mvw.init.AttributeRegistry;
import com.mrbelieve.mvw.interfaces.IExtendedAttackReach;
import com.mrbelieve.mvw.interfaces.TwoHanded;
import com.mrbelieve.mvw.util.KeyboardHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class HalberdItem
extends AxeItem
implements IExtendedAttackReach,
TwoHanded {
    private static final Set<Material> EFFECTIVE_ON_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C});
    private static final Set<Block> EFFECTIVE_ON_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_235358_mQ_, Blocks.field_235359_mR_});
    protected static final Map<Block, Block> BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().put((Object)Blocks.field_196626_Q, (Object)Blocks.field_209389_ab).put((Object)Blocks.field_196617_K, (Object)Blocks.field_203204_R).put((Object)Blocks.field_196639_V, (Object)Blocks.field_209394_ag).put((Object)Blocks.field_196623_P, (Object)Blocks.field_203209_W).put((Object)Blocks.field_196637_U, (Object)Blocks.field_209393_af).put((Object)Blocks.field_196621_O, (Object)Blocks.field_203208_V).put((Object)Blocks.field_196631_S, (Object)Blocks.field_209391_ad).put((Object)Blocks.field_196619_M, (Object)Blocks.field_203206_T).put((Object)Blocks.field_196634_T, (Object)Blocks.field_209392_ae).put((Object)Blocks.field_196620_N, (Object)Blocks.field_203207_U).put((Object)Blocks.field_196629_R, (Object)Blocks.field_209390_ac).put((Object)Blocks.field_196618_L, (Object)Blocks.field_203205_S).put((Object)Blocks.field_235368_mh_, (Object)Blocks.field_235369_mi_).put((Object)Blocks.field_235370_mj_, (Object)Blocks.field_235371_mk_).put((Object)Blocks.field_235377_mq_, (Object)Blocks.field_235378_mr_).put((Object)Blocks.field_235379_ms_, (Object)Blocks.field_235380_mt_).build();
    protected final float field_77864_a;
    private final float attackDamage;
    private final float attackSpeed;
    private final float attackReach;
    private Multimap<Attribute, AttributeModifier> toolAttributes;
    private static final UUID ATTACK_REACH_MODIFIER = UUID.fromString("63d316c1-7d6d-41be-81c3-41fc1a216c27");

    public HalberdItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, float attackReachIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn.addToolType(ToolType.AXE, tier.func_200925_d()));
        this.field_77864_a = tier.func_200928_b();
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
        this.attackReach = attackReachIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.toolAttributes = builder.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (((Boolean)ModConfig.TWO_HANDED_WEAPONS.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.all_two_handed").func_240699_a_(TextFormatting.RED));
            if (KeyboardHelper.isHoldingShift()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.desc_two_handed").func_240699_a_(TextFormatting.DARK_GRAY));
            }
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }

    public static void setAttributeModifierMultimap(HalberdItem ThisItem) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ThisItem.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ThisItem.attackSpeed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)AttributeRegistry.ATTACK_REACH.get(), (Object)new AttributeModifier(ATTACK_REACH_MODIFIER, "Weapon modifier", (double)ThisItem.attackReach, AttributeModifier.Operation.ADDITION));
        ThisItem.toolAttributes = builder.build();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return EFFECTIVE_ON_MATERIALS.contains(material) ? this.field_77864_a : super.func_150893_a(stack, state);
    }

    @Nullable
    public static BlockState getAxeStrippingState(BlockState originalState) {
        Block block = BLOCK_STRIPPING_MAP.get(originalState.func_177230_c());
        return block != null ? (BlockState)block.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, originalState.func_177229_b((Property)RotatedPillarBlock.field_176298_M)) : null;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.toolAttributes : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public float getAttackReach() {
        return this.attackReach;
    }
}

