/*
 * Decompiled with CFR 0.152.
 */
package com.mrbelieve.mvw.items;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.mrbelieve.mvw.items.tool.OffhandAttackDamageSource;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mvw", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class HammerItem
extends PickaxeItem {
    public static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151576_e, (Object)Material.field_151573_f, (Object)Material.field_151592_s, (Object)Material.field_151588_w, (Object)Material.field_151598_x, (Object)Material.field_151574_g, (Object[])new Material[0]);
    private static final Set<Block> EFFECTIVE_ON = ImmutableSet.of((Object)Blocks.field_150408_cc, (Object)Blocks.field_150365_q, (Object)Blocks.field_150347_e, (Object)Blocks.field_150319_E, (Object)Blocks.field_150484_ah, (Object)Blocks.field_150482_ag, (Object[])new Block[]{Blocks.field_196552_aC, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_235334_I_, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_205164_gk, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_196583_aj, Blocks.field_196585_ak, Blocks.field_196798_hA, Blocks.field_196799_hB, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_196650_c, Blocks.field_196652_d, Blocks.field_196654_e, Blocks.field_196655_f, Blocks.field_196656_g, Blocks.field_196657_h, Blocks.field_150333_U, Blocks.field_222401_hJ, Blocks.field_196640_bx, Blocks.field_196643_by, Blocks.field_196646_bz, Blocks.field_196571_bA, Blocks.field_196573_bB, Blocks.field_196575_bC, Blocks.field_196576_bD, Blocks.field_196578_bE, Blocks.field_185771_cX, Blocks.field_196581_bI, Blocks.field_196582_bJ, Blocks.field_196580_bH, Blocks.field_196579_bG, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_222446_lj, Blocks.field_222447_lk, Blocks.field_222448_ll, Blocks.field_222449_lm, Blocks.field_222450_ln, Blocks.field_222451_lo, Blocks.field_222452_lp, Blocks.field_222453_lq, Blocks.field_222454_lr, Blocks.field_222455_ls, Blocks.field_222456_lt, Blocks.field_222457_lu, Blocks.field_222458_lv, Blocks.field_204409_il, Blocks.field_190975_dA, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190986_du, Blocks.field_190984_ds, Blocks.field_190990_dy, Blocks.field_190980_do, Blocks.field_196875_ie, Blocks.field_190982_dq, Blocks.field_190979_dn, Blocks.field_190978_dm, Blocks.field_190983_dr, Blocks.field_190987_dv, Blocks.field_190991_dz, Blocks.field_190977_dl, Blocks.field_190981_dp, Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150332_K});
    private Multimap<Attribute, AttributeModifier> attributeMapMoose;
    public static final Random random = new Random();

    public HammerItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder.addToolType(ToolType.PICKAXE, tier.func_200925_d()));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151036_c) && enchantment != Enchantments.field_191530_r;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        int i = this.func_200891_e().func_200925_d();
        if (blockIn.getHarvestTool() == ToolType.PICKAXE) {
            return i >= blockIn.getHarvestLevel();
        }
        Material material = blockIn.func_185904_a();
        return EFFECTIVE_MATERIALS.contains(material);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return EFFECTIVE_MATERIALS.contains(material) ? this.field_77864_a * 0.5f : super.func_150893_a(stack, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.all_hammer").func_240699_a_(TextFormatting.GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.all_hammer2").func_240699_a_(TextFormatting.GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.all_50%_efficient").func_240699_a_(TextFormatting.RED));
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        stack.func_96631_a(1, random, null);
        if (entity instanceof PlayerEntity) {
            HammerItem.attemptBreakNeighbors(world, pos, (PlayerEntity)entity, EFFECTIVE_MATERIALS);
        }
        return super.func_179218_a(stack, world, state, pos, entity);
    }

    public static void attemptBreakNeighbors(World world, BlockPos pos, PlayerEntity player, Set<Material> effectiveMaterials) {
        RayTraceResult trace = HammerItem.calcRayTrace(world, player, RayTraceContext.FluidMode.ANY);
        if (trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.func_177982_a(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.func_177982_a(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.func_177982_a(0, a, b);
                    }
                    HammerItem.attemptBreak(world, target, player, effectiveMaterials);
                }
            }
        }
    }

    public static void attemptBreak(World world, BlockPos pos, PlayerEntity player, Set<Material> effectiveMaterials) {
        BlockState state = world.func_180495_p(pos);
        boolean isWithinHarvestLevel = player.func_184614_ca().func_150998_b(state);
        boolean isEffective = effectiveMaterials.contains(state.func_185904_a());
        boolean witherImmune = BlockTags.field_219755_X.func_230235_a_((Object)state.func_177230_c());
        if (isEffective && !witherImmune && isWithinHarvestLevel) {
            world.func_175655_b(pos, false);
            Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
        }
    }

    private void processHarvest(World world, BlockPos pos, BlockState state, ItemStack stack, PlayerEntity player) {
        world.func_175655_b(pos, false);
        if (!player.func_184812_l_()) {
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)stack);
            for (ItemStack itemStack : state.func_215693_a(builder)) {
                ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack);
                world.func_217376_c((Entity)item);
                this.dropExp(player, state.func_177230_c(), pos, stack);
            }
        }
    }

    private void dropExp(PlayerEntity player, Block block, BlockPos pos, ItemStack stack) {
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        int silktouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack);
        int exp = block.getExpDrop(block.func_176223_P(), (IWorldReader)player.func_130014_f_(), pos, fortune, silktouch);
        if (!player.func_130014_f_().field_72995_K) {
            block.func_180637_b((World)((ServerWorld)player.func_130014_f_()), pos, exp);
        }
    }

    public static RayTraceResult calcRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    @SubscribeEvent
    public static void onClaymoreAttack(LivingAttackEvent event) {
        if (event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
            return;
        }
        if (event.getSource() instanceof OffhandAttackDamageSource) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            if (event.getEntityLiving() == null) {
                return;
            }
            LivingEntity victim = event.getEntityLiving();
            if (attacker.func_184614_ca().func_77973_b() instanceof HammerItem) {
                if (attacker instanceof PlayerEntity) {
                    ItemStack mainhand = attacker.func_184614_ca();
                    int knockbackEn = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)mainhand);
                    PlayerEntity playerEntity = (PlayerEntity)attacker;
                    float cooledAttackStrength = playerEntity.func_184825_o(0.5f);
                    boolean atFullAttackStrength = cooledAttackStrength > 0.5f;
                    float attackKnockbackStrength = 1.0f;
                    if (playerEntity.func_70051_ag() && atFullAttackStrength) {
                        playerEntity.field_70170_p.func_184148_a((PlayerEntity)null, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187721_dT, playerEntity.func_184176_by(), 1.0f, 1.0f);
                        attackKnockbackStrength += 1.0f;
                    }
                    victim.func_233627_a_(attackKnockbackStrength * 1.5f + (float)knockbackEn + (float)(knockbackEn * 2), (double)MathHelper.func_76126_a((float)(playerEntity.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(playerEntity.field_70177_z * ((float)Math.PI / 180)))));
                    playerEntity.func_213317_d(playerEntity.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                } else if (attacker instanceof MobEntity) {
                    MobEntity mobEntity = (MobEntity)attacker;
                    float attackKnockbackStrength = (float)mobEntity.func_233637_b_(Attributes.field_233824_g_);
                    ItemStack mainhand = attacker.func_184614_ca();
                    int knockbackEn = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)mainhand);
                    if ((attackKnockbackStrength += 1.0f) > 0.0f) {
                        victim.func_233627_a_(attackKnockbackStrength * 1.5f + (float)(knockbackEn * 2), (double)MathHelper.func_76126_a((float)(mobEntity.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(mobEntity.field_70177_z * ((float)Math.PI / 180)))));
                        mobEntity.func_213317_d(mobEntity.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                    }
                }
            }
        }
    }
}

