/*
 * Decompiled with CFR 0.152.
 */
package com.mrbelieve.mvw.items;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;

public class SickleItem
extends ToolItem {
    private static final Set<Material> EFFECTIVE_ON_MATE = ImmutableSet.of((Object)Material.field_151577_b, (Object)Material.field_151583_m);
    private static final Set<Block> EFFECTIVE_ON_BLOCKS = ImmutableSet.of((Object)Blocks.field_189878_dg, (Object)Blocks.field_235374_mn_, (Object)Blocks.field_150407_cf, (Object)Blocks.field_203216_jz, (Object)Blocks.field_235396_nb_, (Object)Blocks.field_235383_mw_, (Object[])new Block[]{Blocks.field_150360_v, Blocks.field_196577_ad, Blocks.field_196648_Z, Blocks.field_196642_W, Blocks.field_196645_X, Blocks.field_196574_ab, Blocks.field_196572_aa, Blocks.field_196647_Y});
    protected static final Map<Block, BlockState> HOE_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_185774_da, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_196660_k, (Object)Blocks.field_150346_d.func_176223_P()));
    private final float attackDamage;
    public static final Random random = new Random();
    public static final float HIT_RADIUS = 3.5f;

    public SickleItem(IItemTier itemTier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(attackDamage, attackSpeed, itemTier, EFFECTIVE_ON_BLOCKS, properties.addToolType(ToolType.HOE, itemTier.func_200925_d()));
        this.attackDamage = attackDamage + itemTier.func_200929_c();
    }

    public boolean func_150897_b(BlockState blockIn) {
        Material material = blockIn.func_185904_a();
        return EFFECTIVE_ON_MATE.contains(material);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151040_l) && enchantment != Enchantments.field_191530_r;
    }

    private void processHarvest(World world, BlockPos pos, BlockState state, ItemStack stack, PlayerEntity player) {
        world.func_175655_b(pos, false);
        if (!player.func_184812_l_()) {
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)stack);
            for (ItemStack itemStack : state.func_215693_a(builder)) {
                ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack);
                world.func_217376_c((Entity)item);
                this.dropExp(player, state.func_177230_c(), pos, stack);
            }
        }
    }

    private void dropExp(PlayerEntity player, Block block, BlockPos pos, ItemStack stack) {
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        int silktouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack);
        int exp = block.getExpDrop(block.func_176223_P(), (IWorldReader)player.func_130014_f_(), pos, fortune, silktouch);
        if (!player.func_130014_f_().field_72995_K) {
            block.func_180637_b((World)((ServerWorld)player.func_130014_f_()), pos, exp);
        }
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity, PlayerEntity player) {
        stack.func_96631_a(1, random, null);
        if (entity instanceof PlayerEntity) {
            SickleItem.attemptBreakNeighbors(world, pos, (PlayerEntity)entity, EFFECTIVE_ON_MATE);
        }
        return super.func_179218_a(stack, world, state, pos, entity);
    }

    public static void attemptBreakNeighbors(World world, BlockPos pos, PlayerEntity player, Set<Material> effectiveMaterials) {
        RayTraceResult trace = SickleItem.calcRayTrace(world, player, RayTraceContext.FluidMode.ANY);
        if (trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.func_177982_a(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.func_177982_a(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.func_177982_a(0, a, b);
                    }
                    SickleItem.attemptBreak(world, target, player, effectiveMaterials);
                }
            }
        }
    }

    public static void attemptBreak(World world, BlockPos pos, PlayerEntity player, Set<Material> effectiveMaterials) {
        BlockState state = world.func_180495_p(pos);
        boolean isWithinHarvestLevel = player.func_184614_ca().func_150998_b(state);
        boolean isEffective = effectiveMaterials.contains(state.func_185904_a());
        boolean witherImmune = BlockTags.field_219755_X.func_230235_a_((Object)state.func_177230_c());
        if (isEffective && !witherImmune && isWithinHarvestLevel) {
            world.func_175655_b(pos, false);
            Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
        }
    }

    public static RayTraceResult calcRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    @Nullable
    public static BlockState getHoeTillingState(BlockState originalState) {
        return HOE_LOOKUP.get(originalState.func_177230_c());
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        World world = attacker.field_70170_p;
        if (!world.field_72995_K) {
            List effects = PotionUtils.func_185189_a((ItemStack)stack);
            AxisAlignedBB aabb = new AxisAlignedBB(attacker.func_213303_ch().func_72441_c(-3.5, -3.5, -3.5), target.func_213303_ch().func_72441_c(3.5, 3.5, 3.5));
            for (LivingEntity entity : world.func_217357_a(LivingEntity.class, aabb)) {
                if (entity.equals((Object)attacker) || !(entity.func_70032_d((Entity)attacker) <= 3.5f)) continue;
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), this.attackDamage);
                for (EffectInstance effectInstance : effects) {
                    if (!effectInstance.func_188419_a().func_76403_b()) continue;
                    effectInstance.func_188419_a().func_180793_a((Entity)attacker, (Entity)attacker, entity, effectInstance.func_76458_c(), 1.0);
                }
            }
        }
        stack.func_222118_a(1, attacker, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.all_sickle").func_240699_a_(TextFormatting.GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.all_sickle2").func_240699_a_(TextFormatting.GREEN));
    }
}

