/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.integration.patchouli.api;

import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.integration.patchouli.api.StandardDrops;
import java.lang.reflect.Field;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

public class AnimalSpawnInfo
implements IComponentProcessor {
    private String animalName;
    private Object animal;

    public void setup(IVariableProvider<String> iVariableProvider) {
        String name;
        this.animalName = name = (String)iVariableProvider.get("animal");
        switch (name) {
            case "deer": {
                this.animal = ConfigManager.deer;
                break;
            }
            case "frog": {
                this.animal = ConfigManager.frog;
                break;
            }
            case "sprout": {
                this.animal = ConfigManager.sprout;
                break;
            }
            case "beetle": {
                this.animal = ConfigManager.beetle;
                break;
            }
            case "fox": {
                this.animal = ConfigManager.fox;
                break;
            }
            case "endermini": {
                this.animal = ConfigManager.endermini;
                break;
            }
            case "owl": {
                this.animal = ConfigManager.owl;
                break;
            }
            case "silkworm": {
                this.animal = ConfigManager.silkworm;
                break;
            }
            case "lava_cat": {
                this.animal = ConfigManager.lavaCat;
                break;
            }
            case "hell_sprout": {
                this.animal = ConfigManager.hellSprout;
                break;
            }
            default: {
                this.animal = null;
            }
        }
    }

    private int getInt(String name) {
        Field field;
        try {
            field = this.animal.getClass().getField(name);
        }
        catch (NoSuchFieldException e) {
            return 0;
        }
        try {
            return field.getInt(this.animal);
        }
        catch (IllegalAccessException e) {
            return 0;
        }
    }

    private String[] getString(String name) {
        Field field;
        try {
            field = this.animal.getClass().getField(name);
        }
        catch (NoSuchFieldException e) {
            return new String[0];
        }
        try {
            return (String[])field.get(this.animal);
        }
        catch (IllegalAccessException e) {
            return new String[0];
        }
    }

    public String process(String s) {
        if (this.animal == null && !this.animalName.equals("squid")) {
            return null;
        }
        if (s.startsWith("groupSize")) {
            if (this.animalName.equals("squid")) {
                return I18n.func_135052_a((String)"mysticalworld.patchouli.standard_group", (Object[])new Object[0]);
            }
            return I18n.func_135052_a((String)"mysticalworld.patchouli.groups", (Object[])new Object[]{this.getInt("min"), this.getInt("max")});
        }
        if (s.startsWith("biomes")) {
            if (this.animalName.equals("squid")) {
                return I18n.func_135052_a((String)"forge.biome.tags.default.name", (Object[])new Object[0]);
            }
            if (this.animalName.equals("endermini")) {
                return I18n.func_135052_a((String)"forge.biome.tags.end.name", (Object[])new Object[0]);
            }
            StringJoiner joiner = new StringJoiner(", ");
            for (String biomeName : this.getString("biomes")) {
                joiner.add(I18n.func_135052_a((String)("forge.biome.tags." + biomeName.toLowerCase() + ".name"), (Object[])new Object[0]));
            }
            return I18n.func_135052_a((String)"mysticalworld.patchouli.biomes", (Object[])new Object[]{joiner.toString()});
        }
        if (s.startsWith("title")) {
            return I18n.func_135052_a((String)("entity.entity_" + this.animalName.toLowerCase() + ".name"), (Object[])new Object[0]);
        }
        if (s.startsWith("item")) {
            List<ItemStack> drops = StandardDrops.getDrops(this.animalName);
            int index = Integer.parseInt(s.replace("item", "")) - 1;
            if (index < drops.size()) {
                return ItemStackUtil.serializeStack((ItemStack)drops.get(index));
            }
            return ItemStackUtil.serializeStack((ItemStack)ItemStack.field_190927_a);
        }
        return null;
    }
}

