/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.data;

import epicsquid.mysticallib.data.IIngredientProvider;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IngredientProvider<T extends IItemProvider & IForgeRegistryEntry<?>>
implements IIngredientProvider {
    private Tag<Item> tag = null;
    private T provider = null;
    private Supplier<? extends T> supplier = null;

    public IngredientProvider(Tag<Item> tag) {
        this.tag = tag;
    }

    public IngredientProvider(T provider) {
        this.provider = provider;
    }

    public IngredientProvider(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public String safeName() {
        if (this.tag != null) {
            return this.safeName(this.tag.func_199886_b());
        }
        if (this.provider != null) {
            return this.safeName(((IForgeRegistryEntry)this.provider).getRegistryName());
        }
        return this.safeName(((IForgeRegistryEntry)((IItemProvider)this.supplier.get())).getRegistryName());
    }

    private String safeName(ResourceLocation nameSource) {
        return nameSource.func_110623_a().replace('/', '_');
    }

    @Override
    public Ingredient asIngredient() {
        if (this.tag != null) {
            return Ingredient.func_199805_a(this.tag);
        }
        if (this.provider != null) {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.provider.func_199767_j()});
        }
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((IItemProvider)this.supplier.get()).func_199767_j()});
    }

    @Override
    public InventoryChangeTrigger.Instance hasItem() {
        return this.hasItem(this.hasItemInternal().func_200310_b());
    }

    private ItemPredicate.Builder hasItemInternal() {
        if (this.provider != null) {
            return ItemPredicate.Builder.func_200309_a().func_200308_a(this.provider);
        }
        if (this.tag != null) {
            return ItemPredicate.Builder.func_200309_a().func_200307_a(this.tag);
        }
        return ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)this.supplier.get());
    }
}

