/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.fx;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.nbt.CompoundNBT;
import org.lwjgl.opengl.GL11;

public class Effect {
    public int lifetime = 0;
    public int maxLife = 0;
    public float r = 0.0f;
    public float g = 0.0f;
    public float b = 0.0f;
    public float a = 0.0f;
    public boolean inited = false;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double px = 0.0;
    public double py = 0.0;
    public double pz = 0.0;
    public double vx = 0.0;
    public double vy = 0.0;
    public double vz = 0.0;
    public boolean additive = false;
    public boolean dead = false;
    public int dimId = 0;

    public Effect() {
    }

    public Effect(int id) {
        this.dimId = id;
    }

    public Effect setLife(int l) {
        this.maxLife = l;
        this.lifetime = l;
        return this;
    }

    public Effect setColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public Effect setPosition(double x, double y, double z) {
        this.px = x;
        this.py = y;
        this.pz = z;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Effect setMotion(double vx, double vy, double vz) {
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        return this;
    }

    public Effect setAdditive(boolean additive) {
        this.additive = additive;
        return this;
    }

    public void update() {
        if (!this.inited) {
            this.inited = true;
        }
        this.px = this.x;
        this.py = this.y;
        this.pz = this.z;
        this.x += this.vx;
        this.y += this.vy;
        this.z += this.vz;
        --this.lifetime;
        if (this.lifetime < 0) {
            this.kill();
        }
    }

    public void kill() {
        this.dead = true;
    }

    public float getLifeCoeff(float pTicks) {
        return Math.max(0.0f, ((float)this.lifetime - pTicks) / (float)this.maxLife);
    }

    public float getInterpX(float pticks) {
        return (float)this.x * pticks + (float)this.px * (1.0f - pticks);
    }

    public float getInterpY(float pticks) {
        return (float)this.y * pticks + (float)this.py * (1.0f - pticks);
    }

    public float getInterpZ(float pticks) {
        return (float)this.z * pticks + (float)this.pz * (1.0f - pticks);
    }

    public void renderTotal(float pticks) {
        if (this.inited) {
            GlStateManager.enableBlend();
            GlStateManager.enableAlphaTest();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)(this.additive ? GlStateManager.DestFactor.ONE : GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA));
            GlStateManager.depthMask((boolean)false);
            int dfunc = GL11.glGetInteger((int)2932);
            GlStateManager.depthFunc((int)515);
            int func = GL11.glGetInteger((int)3009);
            float ref = GL11.glGetFloat((int)3010);
            GlStateManager.alphaFunc((int)519, (float)0.0f);
            GlStateManager.disableCull();
            GlStateManager.shadeModel((int)7425);
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
            this.render(pticks);
            GlStateManager.popMatrix();
            GlStateManager.alphaFunc((int)func, (float)ref);
            GlStateManager.depthFunc((int)dfunc);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.depthMask((boolean)true);
            GlStateManager.disableBlend();
        }
    }

    public void read(CompoundNBT tag) {
        this.px = this.x;
        this.x = tag.func_74769_h("x");
        this.py = this.y;
        this.y = tag.func_74769_h("y");
        this.pz = this.z;
        this.z = tag.func_74769_h("z");
        this.vx = tag.func_74769_h("vx");
        this.vy = tag.func_74769_h("vy");
        this.vz = tag.func_74769_h("vz");
        this.r = tag.func_74760_g("r");
        this.g = tag.func_74760_g("g");
        this.b = tag.func_74760_g("b");
        this.a = tag.func_74760_g("a");
        this.maxLife = tag.func_74762_e("maxlife");
        this.lifetime = tag.func_74762_e("life");
        this.dimId = tag.func_74762_e("dim");
        this.additive = tag.func_74767_n("additive");
    }

    public CompoundNBT write() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a("x", this.x);
        tag.func_74780_a("y", this.y);
        tag.func_74780_a("z", this.z);
        tag.func_74780_a("vx", this.vx);
        tag.func_74780_a("vy", this.vy);
        tag.func_74780_a("vz", this.vz);
        tag.func_74776_a("r", this.r);
        tag.func_74776_a("g", this.g);
        tag.func_74776_a("b", this.b);
        tag.func_74776_a("a", this.a);
        tag.func_74768_a("maxlife", this.maxLife);
        tag.func_74768_a("life", this.lifetime);
        tag.func_74768_a("dim", this.dimId);
        tag.func_74757_a("additive", this.additive);
        return tag;
    }

    public void render(float pticks) {
    }
}

