/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.repack.registrate.builders;

import epicsquid.mysticallib.repack.registrate.AbstractRegistrate;
import epicsquid.mysticallib.repack.registrate.builders.Builder;
import epicsquid.mysticallib.repack.registrate.builders.BuilderCallback;
import epicsquid.mysticallib.repack.registrate.providers.ProviderType;
import epicsquid.mysticallib.repack.registrate.providers.RegistrateLangProvider;
import epicsquid.mysticallib.repack.registrate.util.RegistryEntry;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullBiFunction;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullSupplier;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonnullType;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AbstractBuilder<R extends IForgeRegistryEntry<R>, T extends R, P, S extends AbstractBuilder<R, T, P, S>>
implements Builder<R, T, P, S> {
    private final AbstractRegistrate<?> owner;
    private final P parent;
    private final String name;
    private final BuilderCallback callback;
    private final Class<? super R> registryType;

    @NonnullType
    protected abstract T createEntry();

    @Override
    public RegistryEntry<T> register() {
        return this.callback.accept(this.name, this.registryType, this, this::createEntry);
    }

    protected BuilderCallback getCallback() {
        return this.callback;
    }

    public S lang(NonNullFunction<T, String> langKeyProvider) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> t) -> p.getAutomaticName((NonNullSupplier<? extends IForgeRegistryEntry<?>>)t));
    }

    public S lang(NonNullFunction<T, String> langKeyProvider, String name) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> s) -> name);
    }

    private S lang(NonNullFunction<T, String> langKeyProvider, NonNullBiFunction<RegistrateLangProvider, NonNullSupplier<? extends T>, String> localizedNameProvider) {
        return (S)((AbstractBuilder)this.setData(ProviderType.LANG, (ctx, prov) -> prov.add((String)langKeyProvider.apply(ctx.getEntry()), (String)localizedNameProvider.apply((RegistrateLangProvider)prov, ctx::getEntry))));
    }

    public AbstractBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, Class<? super R> registryType) {
        this.owner = owner;
        this.parent = parent;
        this.name = name;
        this.callback = callback;
        this.registryType = registryType;
    }

    @Override
    public AbstractRegistrate<?> getOwner() {
        return this.owner;
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? super R> getRegistryType() {
        return this.registryType;
    }
}

