/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.repack.registrate.builders;

import epicsquid.mysticallib.repack.registrate.AbstractRegistrate;
import epicsquid.mysticallib.repack.registrate.builders.AbstractBuilder;
import epicsquid.mysticallib.repack.registrate.builders.BuilderCallback;
import epicsquid.mysticallib.repack.registrate.builders.ItemBuilder;
import epicsquid.mysticallib.repack.registrate.providers.DataGenContext;
import epicsquid.mysticallib.repack.registrate.providers.ProviderType;
import epicsquid.mysticallib.repack.registrate.providers.RegistrateBlockstateProvider;
import epicsquid.mysticallib.repack.registrate.providers.RegistrateRecipeProvider;
import epicsquid.mysticallib.repack.registrate.providers.loot.RegistrateBlockLootTables;
import epicsquid.mysticallib.repack.registrate.providers.loot.RegistrateLootTableProvider;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullBiConsumer;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullBiFunction;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullFunction;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullSupplier;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullUnaryOperator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.storage.loot.LootTables;

public class BlockBuilder<T extends Block, P>
extends AbstractBuilder<Block, T, P, BlockBuilder<T, P>> {
    private final NonNullFunction<Block.Properties, T> factory;
    private NonNullSupplier<Block.Properties> initialProperties;
    private NonNullFunction<Block.Properties, Block.Properties> propertiesCallback = NonNullUnaryOperator.identity();

    public static <T extends Block, P> BlockBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Block.Properties, T> factory, Material material) {
        return new BlockBuilder<T, P>(owner, parent, name, callback, factory, () -> Block.Properties.func_200945_a((Material)material)).defaultBlockstate().defaultLoot().defaultLang();
    }

    protected BlockBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Block.Properties, T> factory, NonNullSupplier<Block.Properties> initialProperties) {
        super(owner, parent, name, callback, Block.class);
        this.factory = factory;
        this.initialProperties = initialProperties;
    }

    public BlockBuilder<T, P> properties(NonNullUnaryOperator<Block.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material, DyeColor color) {
        this.initialProperties = () -> Block.Properties.func_200952_a((Material)material, (DyeColor)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material, MaterialColor color) {
        this.initialProperties = () -> Block.Properties.func_200949_a((Material)material, (MaterialColor)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(NonNullSupplier<? extends Block> block) {
        this.initialProperties = () -> Block.Properties.func_200950_a((Block)((Block)block.get()));
        return this;
    }

    public BlockBuilder<T, P> simpleItem() {
        return (BlockBuilder)this.item().build();
    }

    public ItemBuilder<BlockItem, BlockBuilder<T, P>> item() {
        return this.item(BlockItem::new);
    }

    public <I extends BlockItem> ItemBuilder<I, BlockBuilder<T, P>> item(NonNullBiFunction<? super T, Item.Properties, ? extends I> factory) {
        return ((ItemBuilder)this.getOwner().item(this, this.getName(), p -> (BlockItem)factory.apply((T)this.get(), (Item.Properties)p)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model((ctx, prov) -> prov.blockItem(this));
    }

    public <TE extends TileEntity> BlockBuilder<T, P> tileEntity(NonNullSupplier<? extends TE> factory) {
        return (BlockBuilder)this.getOwner().tileEntity(this, this.getName(), factory).validBlock(this).build();
    }

    public BlockBuilder<T, P> defaultBlockstate() {
        return this.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry()));
    }

    public BlockBuilder<T, P> blockstate(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.BLOCKSTATE, cons);
    }

    public BlockBuilder<T, P> defaultLang() {
        return (BlockBuilder)this.lang(Block::func_149739_a);
    }

    public BlockBuilder<T, P> lang(String name) {
        return (BlockBuilder)this.lang(Block::func_149739_a, name);
    }

    public BlockBuilder<T, P> defaultLoot() {
        return this.loot(BlockLootTables::func_218492_c);
    }

    public BlockBuilder<T, P> loot(NonNullBiConsumer<RegistrateBlockLootTables, T> cons) {
        return (BlockBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, tb -> {
            if (!((Block)ctx.getEntry()).func_220068_i().equals((Object)LootTables.field_186419_a)) {
                cons.accept((RegistrateBlockLootTables)tb, (Object)ctx.getEntry());
            }
        }));
    }

    public BlockBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    public BlockBuilder<T, P> tag(Tag<Block> tag) {
        return (BlockBuilder)this.tag(ProviderType.BLOCK_TAGS, tag);
    }

    @Override
    protected T createEntry() {
        Block.Properties properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Block)this.factory.apply(properties));
    }
}

