/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.repack.registrate.builders;

import epicsquid.mysticallib.repack.registrate.AbstractRegistrate;
import epicsquid.mysticallib.repack.registrate.builders.AbstractBuilder;
import epicsquid.mysticallib.repack.registrate.builders.BuilderCallback;
import epicsquid.mysticallib.repack.registrate.builders.ItemBuilder;
import epicsquid.mysticallib.repack.registrate.providers.ProviderType;
import epicsquid.mysticallib.repack.registrate.providers.loot.RegistrateEntityLootTables;
import epicsquid.mysticallib.repack.registrate.providers.loot.RegistrateLootTableProvider;
import epicsquid.mysticallib.repack.registrate.util.LazySpawnEggItem;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullBiConsumer;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullConsumer;
import epicsquid.mysticallib.repack.registrate.util.nullness.NonNullSupplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class EntityBuilder<T extends Entity, P>
extends AbstractBuilder<EntityType<?>, EntityType<T>, P, EntityBuilder<T, P>> {
    private final NonNullSupplier<EntityType.Builder<T>> builder;
    private NonNullConsumer<EntityType.Builder<T>> builderCallback = $ -> {};

    public static <T extends Entity, P> EntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.IFactory<T> factory, EntityClassification classification) {
        return new EntityBuilder<T, P>(owner, parent, name, callback, factory, classification).defaultLang();
    }

    protected EntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.IFactory<T> factory, EntityClassification classification) {
        super(owner, parent, name, callback, EntityType.class);
        this.builder = () -> EntityType.Builder.func_220322_a((EntityType.IFactory)factory, (EntityClassification)classification);
    }

    public EntityBuilder<T, P> properties(NonNullConsumer<EntityType.Builder<T>> cons) {
        this.builderCallback = this.builderCallback.andThen(cons);
        return this;
    }

    @Deprecated
    public EntityBuilder<T, P> defaultSpawnEgg(int primaryColor, int secondaryColor) {
        return (EntityBuilder)this.spawnEgg(primaryColor, secondaryColor).build();
    }

    @Deprecated
    public ItemBuilder<? extends SpawnEggItem, EntityBuilder<T, P>> spawnEgg(int primaryColor, int secondaryColor) {
        return this.getOwner().item(this, this.getName() + "_spawn_egg", p -> new LazySpawnEggItem(this, primaryColor, secondaryColor, (Item.Properties)p)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg")));
    }

    public EntityBuilder<T, P> defaultLang() {
        return (EntityBuilder)this.lang(EntityType::func_210760_d);
    }

    public EntityBuilder<T, P> lang(String name) {
        return (EntityBuilder)this.lang(EntityType::func_210760_d, name);
    }

    public EntityBuilder<T, P> loot(NonNullBiConsumer<RegistrateEntityLootTables, EntityType<T>> cons) {
        return (EntityBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.ENTITY, tb -> cons.accept((RegistrateEntityLootTables)tb, (EntityType)ctx.getEntry())));
    }

    public EntityBuilder<T, P> tag(Tag<EntityType<?>> tag) {
        return (EntityBuilder)this.tag(ProviderType.ENTITY_TAGS, tag);
    }

    @Override
    protected EntityType<T> createEntry() {
        EntityType.Builder<T> builder = this.builder.get();
        this.builderCallback.accept(builder);
        return builder.func_206830_a(this.getName());
    }
}

