/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.repack.registrate.providers;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import epicsquid.mysticallib.repack.registrate.AbstractRegistrate;
import epicsquid.mysticallib.repack.registrate.providers.ProviderType;
import epicsquid.mysticallib.repack.registrate.providers.RegistrateProvider;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnterBlockTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Block;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistrateRecipeProvider
extends RecipeProvider
implements RegistrateProvider,
Consumer<IFinishedRecipe> {
    private final AbstractRegistrate<?> owner;
    @Nullable
    private Consumer<IFinishedRecipe> callback;
    public static final int DEFAULT_SMELT_TIME = 200;
    public static final int DEFAULT_BLAST_TIME = 100;
    public static final int DEFAULT_SMOKE_TIME = 100;
    public static final int DEFAULT_CAMPFIRE_TIME = 600;
    private static final String SMELTING_NAME = "smelting";
    private static final ImmutableMap<CookingRecipeSerializer<?>, String> COOKING_TYPE_NAMES = ImmutableMap.builder().put((Object)IRecipeSerializer.field_222171_o, (Object)"smelting").put((Object)IRecipeSerializer.field_222172_p, (Object)"blasting").put((Object)IRecipeSerializer.field_222173_q, (Object)"smoking").put((Object)IRecipeSerializer.field_222174_r, (Object)"campfire").build();

    public RegistrateRecipeProvider(AbstractRegistrate<?> owner, DataGenerator generatorIn) {
        super(generatorIn);
        this.owner = owner;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void accept(@Nullable IFinishedRecipe t) {
        if (this.callback == null) {
            throw new IllegalStateException("Cannot accept recipes outside of a call to registerRecipes");
        }
        this.callback.accept(t);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.callback = consumer;
        this.owner.genData(ProviderType.RECIPE, this);
        this.callback = null;
    }

    private ResourceLocation safeId(ResourceLocation id) {
        return new ResourceLocation(this.owner.getModid(), this.safeName(id));
    }

    private ResourceLocation safeId(IForgeRegistryEntry<?> registryEntry) {
        return this.safeId(registryEntry.getRegistryName());
    }

    private String safeName(ResourceLocation nameSource) {
        return nameSource.func_110623_a().replace('/', '_');
    }

    private String safeName(IForgeRegistryEntry<?> registryEntry) {
        return this.safeName(registryEntry.getRegistryName());
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void cooking(Supplier<? extends T> source, Supplier<? extends T> result, float experience, int cookingTime, CookingRecipeSerializer<?> serializer, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, (String)COOKING_TYPE_NAMES.get(serializer), serializer, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void cooking(Tag<Item> source, Supplier<? extends T> result, float experience, int cookingTime, CookingRecipeSerializer<?> serializer, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, (String)COOKING_TYPE_NAMES.get(serializer), serializer, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void cooking(Supplier<? extends T> source, Supplier<? extends T> result, float experience, int cookingTime, String typeName, CookingRecipeSerializer<?> serializer, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)experience, (int)cookingTime, serializer).func_218628_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get())).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from" + (SMELTING_NAME.equals(typeName) ? "_" + this.safeName((IForgeRegistryEntry)source.get()) + "_" + typeName : ""));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void cooking(Tag<Item> source, Supplier<? extends T> result, float experience, int cookingTime, String typeName, CookingRecipeSerializer<?> serializer, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)experience, (int)cookingTime, serializer).func_218628_a("has_" + this.safeName(source.func_199886_b()), (ICriterionInstance)this.func_200409_a(source)).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from" + (SMELTING_NAME.equals(typeName) ? "_" + this.safeName(source.func_199886_b()) + "_" + typeName : ""));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smelting(Supplier<? extends T> source, Supplier<? extends T> result, float experience, Consumer<IFinishedRecipe> consumer) {
        this.smelting(source, result, experience, 200, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smelting(Supplier<? extends T> source, Supplier<? extends T> result, float experience, int cookingTime, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222171_o, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smelting(Tag<Item> source, Supplier<? extends T> result, float experience, Consumer<IFinishedRecipe> consumer) {
        this.smelting(source, result, experience, 200, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smelting(Tag<Item> source, Supplier<? extends T> result, float experience, int cookingTime, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222171_o, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void blasting(Supplier<? extends T> source, Supplier<? extends T> result, float experience, Consumer<IFinishedRecipe> consumer) {
        this.blasting(source, result, experience, 100, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void blasting(Supplier<? extends T> source, Supplier<? extends T> result, float experience, int cookingTime, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222172_p, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void blasting(Tag<Item> source, Supplier<? extends T> result, float experience, Consumer<IFinishedRecipe> consumer) {
        this.blasting(source, result, experience, 100, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void blasting(Tag<Item> source, Supplier<? extends T> result, float experience, int cookingTime, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222172_p, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smoking(Supplier<? extends T> source, Supplier<? extends T> result, float experience, Consumer<IFinishedRecipe> consumer) {
        this.smoking(source, result, experience, 100, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smoking(Supplier<? extends T> source, Supplier<? extends T> result, float experience, int cookingTime, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222173_q, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smoking(Tag<Item> source, Supplier<? extends T> result, float experience, Consumer<IFinishedRecipe> consumer) {
        this.smoking(source, result, experience, 100, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smoking(Tag<Item> source, Supplier<? extends T> result, float experience, int cookingTime, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222173_q, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void campfire(Supplier<? extends T> source, Supplier<? extends T> result, float experience, Consumer<IFinishedRecipe> consumer) {
        this.campfire(source, result, experience, 600, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void campfire(Supplier<? extends T> source, Supplier<? extends T> result, float experience, int cookingTime, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222174_r, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void campfire(Tag<Item> source, Supplier<? extends T> result, float experience, Consumer<IFinishedRecipe> consumer) {
        this.campfire(source, result, experience, 600, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void campfire(Tag<Item> source, Supplier<? extends T> result, float experience, int cookingTime, Consumer<IFinishedRecipe> consumer) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222174_r, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void stonecutting(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<IFinishedRecipe> consumer) {
        this.stonecutting(source, result, 1, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void stonecutting(Supplier<? extends T> source, Supplier<? extends T> result, int resultAmount, Consumer<IFinishedRecipe> consumer) {
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (int)resultAmount).func_218643_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get())).func_218645_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smeltingAndBlasting(Supplier<? extends T> source, Supplier<? extends T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        this.smelting(source, result, xp, consumer);
        this.blasting(source, result, xp, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smeltingAndBlasting(Tag<Item> source, Supplier<? extends T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        this.smelting(source, result, xp, consumer);
        this.blasting(source, result, xp, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void food(Supplier<? extends T> source, Supplier<? extends T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        this.smelting(source, result, xp, consumer);
        this.smoking(source, result, xp, consumer);
        this.campfire(source, result, xp, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void food(Tag<Item> source, Supplier<? extends T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        this.smelting(source, result, xp, consumer);
        this.smoking(source, result, xp, consumer);
        this.campfire(source, result, xp, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void storage(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("XXX").func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200465_a("has_at_least_9_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)this.func_200408_a(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)input.get())).func_200467_a(consumer, this.safeId((IForgeRegistryEntry)output.get()));
        this.singleItemUnfinished(input, output, 1, 9).func_200484_a(consumer, this.safeId((IForgeRegistryEntry)input.get()) + "_from_" + this.safeName((IForgeRegistryEntry)output.get()));
    }

    @CheckReturnValue
    public <T extends IItemProvider & IForgeRegistryEntry<?>> ShapelessRecipeBuilder singleItemUnfinished(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount) {
        return ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)result.get()), (int)amount).func_200491_b((IItemProvider)source.get(), required).func_200483_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void singleItem(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount, Consumer<IFinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, required, amount).func_200485_a(consumer, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void planks(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<IFinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, 1, 4).func_200490_a("planks").func_200485_a(consumer, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void stairs(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)4).func_200472_a("X  ").func_200472_a("XX ").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get())).func_200467_a(consumer, this.safeId((IForgeRegistryEntry)result.get()));
        if (stone) {
            this.stonecutting(source, result, consumer);
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void slab(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get())).func_200467_a(consumer, this.safeId((IForgeRegistryEntry)result.get()));
        if (stone) {
            this.stonecutting(source, result, 2, consumer);
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void fence(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("W#W").func_200472_a("W#W").func_200462_a(Character.valueOf('W'), (IItemProvider)source.get()).func_200469_a(Character.valueOf('#'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get())).func_200467_a(consumer, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void fenceGate(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("#W#").func_200472_a("#W#").func_200462_a(Character.valueOf('W'), (IItemProvider)source.get()).func_200469_a(Character.valueOf('#'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get())).func_200467_a(consumer, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void wall(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get())).func_200467_a(consumer, this.safeId((IForgeRegistryEntry)result.get()));
        this.stonecutting(source, result, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void door(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("XX").func_200472_a("XX").func_200472_a("XX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get())).func_200467_a(consumer, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void trapDoor(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)2).func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.func_200403_a((IItemProvider)source.get())).func_200467_a(consumer, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public void func_208310_b(DirectoryCache cache, JsonObject advancementJson, Path pathIn) {
        super.func_208310_b(cache, advancementJson, pathIn);
    }

    public EnterBlockTrigger.Instance func_200407_a(Block blockIn) {
        return super.func_200407_a(blockIn);
    }

    public InventoryChangeTrigger.Instance func_200408_a(MinMaxBounds.IntBound amount, IItemProvider itemIn) {
        return super.func_200408_a(amount, itemIn);
    }

    public InventoryChangeTrigger.Instance func_200403_a(IItemProvider itemIn) {
        return super.func_200403_a(itemIn);
    }

    public InventoryChangeTrigger.Instance func_200409_a(Tag<Item> tagIn) {
        return super.func_200409_a(tagIn);
    }

    public InventoryChangeTrigger.Instance func_200405_a(ItemPredicate ... predicates) {
        return super.func_200405_a(predicates);
    }
}

