/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class MobConfig {
    private String name;
    private int chance;
    private int min;
    private int max;
    private List<String> biomes;
    private ForgeConfigSpec.IntValue configChance;
    private ForgeConfigSpec.IntValue configMin;
    private ForgeConfigSpec.IntValue configMax;
    private ForgeConfigSpec.ConfigValue<String> configBiomes;

    public MobConfig(String name, int chance, int min, int max, List<String> biomes) {
        this.name = name;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.biomes = biomes;
    }

    public int getChance() {
        return (Integer)this.configChance.get();
    }

    public int getMin() {
        return (Integer)this.configMin.get();
    }

    public int getMax() {
        return (Integer)this.configMax.get();
    }

    public List<String> getBiomes() {
        String values = (String)this.configBiomes.get();
        return Arrays.asList(values.split(","));
    }

    public boolean shouldRegister() {
        return this.getChance() > 0;
    }

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " spawn config.").push(this.name + "_spawn");
        this.configChance = builder.comment("Chance to spawn (set to 0 to disable).").defineInRange("spawnChance", this.chance, 0, 256);
        this.configMin = builder.comment("Min to spawn in a group.").defineInRange("min", this.min, 0, 256);
        this.configMax = builder.comment("Max to spawn in a group.").defineInRange("max", this.max, 0, 256);
        StringBuilder sb = new StringBuilder();
        this.biomes.forEach(biome -> {
            sb.append((String)biome);
            sb.append(",");
        });
        this.configBiomes = builder.comment("List of biome types to spawn.").define("biomes", (Object)sb.toString());
        builder.pop();
    }
}

