/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import epicsquid.mysticallib.block.BaseOreBlock;
import epicsquid.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;

public class OreConfig {
    private String name;
    private int chance;
    private int minY;
    private int maxY;
    private int size;
    private Supplier<RegistryEntry<BaseOreBlock>> ore;
    private ForgeConfigSpec.IntValue configChance;
    private ForgeConfigSpec.IntValue configMinY;
    private ForgeConfigSpec.IntValue configMaxY;
    private ForgeConfigSpec.IntValue configSize;

    public OreConfig(String name, int chance, int minY, int maxY, int size, Supplier<RegistryEntry<BaseOreBlock>> ore) {
        this.name = name;
        this.chance = chance;
        this.minY = minY;
        this.maxY = maxY;
        this.size = size;
        this.ore = ore;
    }

    public String getName() {
        return this.name;
    }

    public int getChance() {
        return (Integer)this.configChance.get();
    }

    public int getMinY() {
        return (Integer)this.configMinY.get();
    }

    public int getMaxY() {
        return (Integer)this.configMaxY.get();
    }

    public int getSize() {
        return (Integer)this.configSize.get();
    }

    public Block getOre() {
        return (Block)this.ore.get().get();
    }

    public boolean shouldRegister() {
        return this.getChance() > 0;
    }

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " ore generation.").push(this.name + "_oregen");
        this.configChance = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("oreChances", this.chance, 0, 256);
        this.configSize = builder.comment("Max size of the vein.").defineInRange("veinSize", this.size, 1, 256);
        this.configMinY = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("minY", this.minY, 0, 256);
        this.configMaxY = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("maxY", this.maxY, 0, 256);
        builder.pop();
    }
}

