/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.data;

import epicsquid.mysticallib.data.IIngredientProvider;
import epicsquid.mysticallib.item.DrinkItem;
import epicsquid.mysticalworld.repack.registrate.providers.DataGenContext;
import epicsquid.mysticalworld.repack.registrate.providers.RegistrateRecipeProvider;
import epicsquid.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullBiConsumer;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Block;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeProvider {
    private String modid;

    public RecipeProvider(String modid) {
        this.modid = modid;
    }

    public <T extends Item, B extends Block> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> storage(Supplier<RegistryEntry<B>> block, Supplier<RegistryEntry<T>> ingot, Tag<Item> blockTag, Tag<Item> ingotTag, @Nullable Tag<Item> oreTag, @Nullable Supplier<RegistryEntry<T>> nugget, @Nullable Tag<Item> nuggetTag, @Nullable Tag<Item> dustTag) {
        return (ctx, p) -> {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)((RegistryEntry)block.get()).get())).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200469_a(Character.valueOf('#'), ingotTag).func_200465_a("has_at_least_9_" + this.safeName(ingotTag.func_199886_b()), (ICriterionInstance)p.func_200409_a(ingotTag)).func_200466_a((Consumer)p, this.safeName(ingotTag.func_199886_b()) + "_to_storage_block");
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)((RegistryEntry)ingot.get()).get()), (int)9).func_203221_a(blockTag).func_200483_a("has_block_" + this.safeName(blockTag.func_199886_b()), (ICriterionInstance)p.func_200409_a(blockTag)).func_200484_a((Consumer)p, this.safeName(blockTag.func_199886_b()) + "_to_9_ingots");
            if (oreTag != null) {
                this.ore(oreTag, (Supplier)ingot.get(), 0.125f, (Consumer<IFinishedRecipe>)p);
            }
            if (nuggetTag != null) {
                ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)((RegistryEntry)ingot.get()).get())).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200469_a(Character.valueOf('#'), nuggetTag).func_200465_a("has_at_least_9_" + this.safeName(nuggetTag.func_199886_b()), (ICriterionInstance)p.func_200409_a(nuggetTag)).func_200466_a((Consumer)p, this.safeName(nuggetTag.func_199886_b()) + "_to_ingot");
                ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)((RegistryEntry)nugget.get()).get()), (int)9).func_203221_a(ingotTag).func_200483_a("has_ingot_" + this.safeName(ingotTag.func_199886_b()), (ICriterionInstance)p.func_200409_a(ingotTag)).func_200484_a((Consumer)p, this.safeName(ingotTag.func_199886_b()) + "_to_9_nuggets");
            }
            if (dustTag != null) {
                this.dust(dustTag, (Supplier)ingot.get(), 0.125f, (Consumer<IFinishedRecipe>)p);
            }
        };
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void ore(Tag<Item> source, Supplier<T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)200).func_218628_a("has_" + this.safeName(source.func_199886_b()), (ICriterionInstance)this.hasItem(source)).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100).func_218628_a("has_" + this.safeName(source.func_199886_b()), (ICriterionInstance)this.hasItem(source)).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting");
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void dust(Tag<Item> source, Supplier<T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)200).func_218628_a("has_" + this.safeName(source.func_199886_b()), (ICriterionInstance)this.hasItem(source)).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting_dust");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100).func_218628_a("has_" + this.safeName(source.func_199886_b()), (ICriterionInstance)this.hasItem(source)).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting_dust");
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void recycle(Supplier<? extends T> source, Supplier<? extends T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)200).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting");
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void recycle(Supplier<? extends T> source, Supplier<? extends T> result, float xp, String namespace, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)200).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218635_a(consumer, new ResourceLocation(namespace, this.safeName((IForgeRegistryEntry)result.get()) + "_from_smelting_" + this.safeName((IForgeRegistryEntry)source.get())));
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218635_a(consumer, new ResourceLocation(namespace, this.safeName((IForgeRegistryEntry)result.get()) + "_from_blasting_" + this.safeName((IForgeRegistryEntry)source.get())));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void recycle(Tag<Item> tag, Supplier<? extends T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(tag), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)200).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)result.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)result.get())).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199805_a(tag), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)result.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)result.get())).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting");
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void food(Supplier<? extends T> source, Supplier<? extends T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)200).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218630_a(consumer);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100, (CookingRecipeSerializer)IRecipeSerializer.field_222173_q).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smoker");
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)600, (CookingRecipeSerializer)IRecipeSerializer.field_222174_r).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_campfire");
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void food(Tag<Item> source, Supplier<? extends T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)200).func_218628_a("has_" + this.safeName(source.func_199886_b()), (ICriterionInstance)this.hasItem(source)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100, (CookingRecipeSerializer)IRecipeSerializer.field_222173_q).func_218628_a("has_" + this.safeName(source.func_199886_b()), (ICriterionInstance)this.hasItem(source)).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smoker");
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)600, (CookingRecipeSerializer)IRecipeSerializer.field_222174_r).func_218628_a("has_" + this.safeName(source.func_199886_b()), (ICriterionInstance)this.hasItem(source)).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_campfire");
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smelting(Supplier<? extends T> source, Supplier<? extends T> result, float xp, boolean blast, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)200).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting");
        if (blast) {
            CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting");
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void storage(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)input.get()).func_200465_a("has_at_least_9_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)input.get())).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)input.get()), (int)9).func_200487_b((IItemProvider)output.get()).func_200483_a("has_" + this.safeName((IForgeRegistryEntry)output.get()), (ICriterionInstance)this.hasItem((IItemProvider)output.get())).func_200484_a(consumer, this.safeId((IForgeRegistryEntry)input.get()) + "_from_" + this.safeName((IForgeRegistryEntry)output.get()));
    }

    public Item getModElement(Tag<Item> input) {
        Item last = Items.field_190931_a;
        Iterator iterator = input.func_199885_a().iterator();
        while (iterator.hasNext()) {
            Item item;
            last = item = (Item)iterator.next();
            if (!item.getRegistryName().func_110624_b().equals(this.modid)) continue;
            return item;
        }
        return last;
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void storage(Tag<Item> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200469_a(Character.valueOf('#'), input).func_200465_a("has_at_least_9_" + this.safeName(input.func_199886_b()), (ICriterionInstance)this.hasItem(input)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)this.getModElement(input), (int)9).func_200487_b((IItemProvider)output.get()).func_200483_a("has_" + this.safeName((IForgeRegistryEntry)output.get()), (ICriterionInstance)this.hasItem((IItemProvider)output.get())).func_200485_a(consumer, new ResourceLocation(this.modid, this.safeName(input.func_199886_b()) + "_from_" + this.safeName((IForgeRegistryEntry)output.get())));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> ShapelessRecipeBuilder singleItemUnfinished(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount) {
        return ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)result.get()), (int)amount).func_200491_b((IItemProvider)source.get(), required).func_200483_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get()));
    }

    public ResourceLocation safeId(ResourceLocation id) {
        return new ResourceLocation(id.func_110624_b(), this.safeName(id));
    }

    public ResourceLocation safeId(IForgeRegistryEntry<?> registryEntry) {
        return this.safeId(registryEntry.getRegistryName());
    }

    public String safeName(ResourceLocation nameSource) {
        return nameSource.func_110623_a().replace('/', '_');
    }

    public String safeName(IForgeRegistryEntry<?> registryEntry) {
        return this.safeName(registryEntry.getRegistryName());
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void dye(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount, Consumer<IFinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, required, amount).func_200485_a(consumer, new ResourceLocation(this.modid, ((IForgeRegistryEntry)((IItemProvider)result.get())).getRegistryName().func_110623_a()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void singleItem(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount, Consumer<IFinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, required, amount).func_200482_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void planks(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<IFinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, 1, 4).func_200490_a("planks").func_200482_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void twoByTwo(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, int count, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)count).func_200472_a("XX").func_200472_a("XX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void twoByTwo(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        this.twoByTwo(source, result, group, 4, consumer);
    }

    public <T extends IIngredientProvider, V extends IItemProvider & IForgeRegistryEntry<?>> void twoTwoByTwo(T source1, T source2, Supplier<? extends V> result, @Nullable String group, int count, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)count).func_200472_a("XY").func_200472_a("YX").func_200471_a(Character.valueOf('X'), source1.asIngredient()).func_200471_a(Character.valueOf('Y'), source2.asIngredient()).func_200473_b(group).func_200465_a("has_" + source1.safeName(), (ICriterionInstance)source1.hasItem()).func_200465_a("has_" + source2.safeName(), (ICriterionInstance)source2.hasItem()).func_200464_a(consumer);
    }

    public <T extends IIngredientProvider, V extends IItemProvider & IForgeRegistryEntry<?>> void twoTwoByTwo(T source1, T source2, Supplier<? extends V> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        this.twoTwoByTwo(source1, source2, result, group, 4, consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void stairs(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)4).func_200472_a("X  ").func_200472_a("XX ").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
        if (stone) {
            SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get())).func_218643_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218645_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void slab(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
        if (stone) {
            SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (int)2).func_218643_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218645_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void narrowPost(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)4).func_200472_a("X").func_200472_a("X").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
        if (stone) {
            SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (int)2).func_218643_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218645_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void widePost(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("X").func_200472_a("X").func_200472_a("X").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
        if (stone) {
            SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (int)2).func_218643_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218645_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void fence(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("W#W").func_200472_a("W#W").func_200462_a(Character.valueOf('W'), (IItemProvider)source.get()).func_200469_a(Character.valueOf('#'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void fenceGate(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("#W#").func_200472_a("#W#").func_200462_a(Character.valueOf('W'), (IItemProvider)source.get()).func_200469_a(Character.valueOf('#'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void wall(Supplier<? extends T> source, Supplier<? extends T> result, boolean stone, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
        if (stone) {
            SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get())).func_218643_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_218645_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void door(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("XX").func_200472_a("XX").func_200472_a("XX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void trapDoor(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)2).func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)this.hasItem((IItemProvider)source.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void axe(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XX ").func_200472_a("XS ").func_200472_a(" S ").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void pickaxe(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XXX").func_200472_a(" S ").func_200472_a(" S ").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void shovel(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X").func_200472_a("S").func_200472_a("S").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void sword(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X").func_200472_a("X").func_200472_a("S").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void knife(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a(" X").func_200472_a("S ").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void knife(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a(" X").func_200472_a("S ").func_200469_a(Character.valueOf('X'), material).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200466_a(consumer, this.safeName((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName(material.func_199886_b()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void hoe(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XX ").func_200472_a(" S ").func_200472_a(" S ").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void boots(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X X").func_200472_a("X X").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void spear(Supplier<? extends Item> sword, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X").func_200472_a("S").func_200472_a("S").func_200462_a(Character.valueOf('X'), (IItemProvider)sword.get()).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)sword.get()), (ICriterionInstance)this.hasItem((IItemProvider)sword.get())).func_200467_a(consumer, new ResourceLocation(this.modid, ((IForgeRegistryEntry)((IItemProvider)result.get())).getRegistryName().func_110623_a()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void spear(Item sword, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X").func_200472_a("S").func_200472_a("S").func_200462_a(Character.valueOf('X'), (IItemProvider)sword).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry<?>)sword), (ICriterionInstance)this.hasItem((IItemProvider)sword)).func_200467_a(consumer, new ResourceLocation(this.modid, ((IForgeRegistryEntry)((IItemProvider)result.get())).getRegistryName().func_110623_a()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void legs(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void chest(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void helmet(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XXX").func_200472_a("X X").func_200462_a(Character.valueOf('X'), (IItemProvider)material.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)material.get()), (ICriterionInstance)this.hasItem((IItemProvider)material.get())).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void axe(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XX ").func_200472_a("XS ").func_200472_a(" S ").func_200469_a(Character.valueOf('X'), material).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void pickaxe(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XXX").func_200472_a(" S ").func_200472_a(" S ").func_200469_a(Character.valueOf('X'), material).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void shovel(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X").func_200472_a("S").func_200472_a("S").func_200469_a(Character.valueOf('X'), material).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void sword(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X").func_200472_a("X").func_200472_a("S").func_200469_a(Character.valueOf('X'), material).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void hoe(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XX ").func_200472_a(" S ").func_200472_a(" S ").func_200469_a(Character.valueOf('X'), material).func_200469_a(Character.valueOf('S'), Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void boots(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X X").func_200472_a("X X").func_200469_a(Character.valueOf('X'), material).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void legs(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200469_a(Character.valueOf('X'), material).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void chest(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200469_a(Character.valueOf('X'), material).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200464_a(consumer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void helmet(Tag<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XXX").func_200472_a("X X").func_200469_a(Character.valueOf('X'), material).func_200473_b(group).func_200465_a("has_" + this.safeName(material.func_199886_b()), (ICriterionInstance)this.hasItem(material)).func_200464_a(consumer);
    }

    public <T extends DrinkItem> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cordial(Supplier<RegistryEntry<T>> cordial, IItemProvider ingredient) {
        return this.cordial(cordial, () -> ingredient);
    }

    public <T extends DrinkItem> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cordial(Supplier<RegistryEntry<T>> cordial, Supplier<? extends IItemProvider> ingredient) {
        return this.cordial(cordial, ingredient, 4);
    }

    public <T extends DrinkItem> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cordial(Supplier<RegistryEntry<T>> cordial, Supplier<? extends IItemProvider> ingredient, int amount) {
        return (ctx, p) -> ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)((RegistryEntry)cordial.get()).get()), (int)amount).func_200472_a("1S1").func_200472_a("BWB").func_200472_a("BSB").func_200462_a(Character.valueOf('1'), (IItemProvider)ingredient.get()).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151102_aT).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151069_bo).func_200462_a(Character.valueOf('W'), (IItemProvider)Items.field_151131_as).func_200465_a("has_first", (ICriterionInstance)p.func_200403_a((IItemProvider)ingredient.get())).func_200465_a("has_sugar", (ICriterionInstance)p.func_200403_a((IItemProvider)Items.field_151102_aT)).func_200464_a((Consumer)p);
    }

    public InventoryChangeTrigger.Instance hasItem(MinMaxBounds.IntBound amount, IItemProvider itemIn) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200308_a(itemIn).func_200311_a(amount).func_200310_b());
    }

    public InventoryChangeTrigger.Instance hasItem(IItemProvider itemIn) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200308_a(itemIn).func_200310_b());
    }

    public InventoryChangeTrigger.Instance hasItem(Tag<Item> tagIn) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200307_a(tagIn).func_200310_b());
    }

    public InventoryChangeTrigger.Instance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.Instance(MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicates);
    }
}

