/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity;

import com.google.common.collect.Sets;
import epicsquid.mysticalworld.entity.ai.StalkGoal;
import epicsquid.mysticalworld.init.ModSounds;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class EnderminiEntity
extends CreatureEntity {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/endermini");
    private static final Set<Block> CARRIABLE_BLOCKS = Sets.newIdentityHashSet();
    private static final DataParameter<Optional<BlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(EnderminiEntity.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EnderminiEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int lastCreepySound;
    private int targetChangeTime;
    private static final Predicate<LivingEntity> endermitePredicate = entity -> entity instanceof EndermiteEntity && ((EndermiteEntity)entity).func_175495_n();

    public EnderminiEntity(EntityType<? extends EnderminiEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new StalkGoal(this, 2.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 32.0f, 1.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new FindPlayerGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PlayerEntity.class}));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, endermitePredicate));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.targetChangeTime = 0;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)false);
        } else {
            this.targetChangeTime = this.field_70173_aa;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)true);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, Optional.empty());
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    public void playEnderminiSound() {
        if (this.field_70173_aa >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, ModSounds.ENDERMINI_STARE.get(), this.func_184176_by(), 2.5f, 1.0f);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.isScreaming() && this.field_70170_p.field_72995_K) {
            this.playEnderminiSound();
        }
        super.func_184206_a(key);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        BlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            compound.func_74777_a("carried", (short)Block.func_196246_j((BlockState)iblockstate));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        BlockState iblockstate = null;
        if (compound.func_150297_b("carried", 8)) {
            iblockstate = Block.func_196257_b((int)compound.func_74765_d("carried"));
        }
        if (iblockstate == null || iblockstate.func_177230_c() == null || iblockstate.func_185904_a() == Material.field_151579_a) {
            iblockstate = null;
        }
        this.setHeldBlock(iblockstate);
    }

    public float func_213307_e(Pose p_213307_1_) {
        return 1.0f;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.field_70173_aa >= this.targetChangeTime + 600 && this.field_70170_p.func_175710_j(new BlockPos((Entity)this)) && this.field_70146_Z.nextFloat() * 30.0f < 1.2f) {
            this.func_70624_b(null);
            this.teleportRandomly();
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.func_213302_cg() / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
        if (flag) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, ModSounds.ENDERMINI_PORTAL.get(), this.func_184176_by(), 1.0f, 1.0f);
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? ModSounds.ENDERMINI_SCREAM.get() : ModSounds.ENDERMINI_IDLE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.ENDERMINI_HIT.get();
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.ENDERMINI_DEATH.get();
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        BlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            Item item = Item.func_150898_a((Block)iblockstate.func_177230_c());
            this.func_70099_a(new ItemStack((IItemProvider)item, 1), 0.0f);
        }
    }

    @Nullable
    public ResourceLocation func_184647_J() {
        return new ResourceLocation("mysticalworld", "entities/endermini");
    }

    public void setHeldBlock(@Nullable BlockState state) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState getHeldBlockState() {
        return ((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orElse(null);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    public static void setCarriable(Block block, boolean canCarry) {
        if (canCarry) {
            CARRIABLE_BLOCKS.add(block);
        } else {
            CARRIABLE_BLOCKS.remove(block);
        }
    }

    public static boolean getCarriable(Block block) {
        return CARRIABLE_BLOCKS.contains(block);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    private boolean shouldFollowPlayer(PlayerEntity player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() == Items.field_221687_cF) {
            return false;
        }
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 && player.func_70685_l((Entity)this);
    }

    private boolean shouldAttackPlayer(PlayerEntity player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            return false;
        }
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 && player.func_70685_l((Entity)this);
    }

    public void func_195406_b(@Nullable BlockState p_195406_1_) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, Optional.ofNullable(p_195406_1_));
    }

    public static boolean canEnderminiSpawn(EntityType<? extends EnderminiEntity> p_223325_0_, IWorld p_223325_1_, SpawnReason p_223325_2_, BlockPos p_223325_3_, Random p_223325_4_) {
        return MonsterEntity.func_223323_a((IWorld)p_223325_1_, (BlockPos)p_223325_3_, (Random)p_223325_4_) && EnderminiEntity.func_223315_a(p_223325_0_, (IWorld)p_223325_1_, (SpawnReason)p_223325_2_, (BlockPos)p_223325_3_, (Random)p_223325_4_);
    }

    static {
        CARRIABLE_BLOCKS.add(Blocks.field_150349_c);
        CARRIABLE_BLOCKS.add(Blocks.field_150346_d);
        CARRIABLE_BLOCKS.add(Blocks.field_150354_m);
        CARRIABLE_BLOCKS.add(Blocks.field_150351_n);
        CARRIABLE_BLOCKS.add(Blocks.field_196605_bc);
        CARRIABLE_BLOCKS.add(Blocks.field_196606_bd);
        CARRIABLE_BLOCKS.add(Blocks.field_150338_P);
        CARRIABLE_BLOCKS.add(Blocks.field_150337_Q);
        CARRIABLE_BLOCKS.add(Blocks.field_150335_W);
        CARRIABLE_BLOCKS.add(Blocks.field_150434_aF);
        CARRIABLE_BLOCKS.add(Blocks.field_150435_aG);
        CARRIABLE_BLOCKS.add(Blocks.field_150423_aK);
        CARRIABLE_BLOCKS.add(Blocks.field_150440_ba);
        CARRIABLE_BLOCKS.add(Blocks.field_150391_bh);
        CARRIABLE_BLOCKS.add(Blocks.field_150424_aL);
    }

    static class TakeBlockGoal
    extends Goal {
        private final EnderminiEntity enderman;

        public TakeBlockGoal(EnderminiEntity p_i45841_1_) {
            this.enderman = p_i45841_1_;
        }

        public boolean func_75250_a() {
            if (this.enderman.getHeldBlockState() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(20) == 0;
        }

        public void func_75246_d() {
            boolean flag;
            Vec3d vec3d1;
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 2.0 + random.nextDouble() * 4.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u + random.nextDouble() * 3.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            Vec3d vec3d = new Vec3d((double)MathHelper.func_76128_c((double)this.enderman.field_70165_t) + 0.5, (double)j + 0.5, (double)MathHelper.func_76128_c((double)this.enderman.field_70161_v) + 0.5);
            BlockRayTraceResult blockraytraceresult = world.func_217299_a(new RayTraceContext(vec3d, vec3d1 = new Vec3d((double)i + 0.5, (double)j + 0.5, (double)k + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.enderman));
            boolean bl = flag = blockraytraceresult.func_216346_c() != RayTraceResult.Type.MISS && blockraytraceresult.func_216350_a().equals((Object)blockpos);
            if (block.func_203417_a(BlockTags.field_201151_l) && flag) {
                this.enderman.func_195406_b(blockstate);
                world.func_217377_a(blockpos, false);
            }
        }
    }

    static class StareGoal
    extends Goal {
        private final EnderminiEntity field_220835_a;

        public StareGoal(EnderminiEntity p_i50520_1_) {
            this.field_220835_a = p_i50520_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.field_220835_a.func_70638_az();
            if (!(livingentity instanceof PlayerEntity)) {
                return false;
            }
            double d0 = livingentity.func_70068_e((Entity)this.field_220835_a);
            return !(d0 > 256.0) && this.field_220835_a.shouldAttackPlayer((PlayerEntity)livingentity);
        }

        public void func_75249_e() {
            this.field_220835_a.func_70661_as().func_75499_g();
        }
    }

    static class PlaceBlockGoal
    extends Goal {
        private final EnderminiEntity enderman;

        public PlaceBlockGoal(EnderminiEntity p_i45843_1_) {
            this.enderman = p_i45843_1_;
        }

        public boolean func_75250_a() {
            if (this.enderman.getHeldBlockState() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.enderman.func_70681_au();
            World iworld = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = iworld.func_180495_p(blockpos);
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate1 = iworld.func_180495_p(blockpos1);
            BlockState blockstate2 = this.enderman.getHeldBlockState();
            if (blockstate2 != null && this.func_220836_a((IWorldReader)iworld, blockpos, blockstate2, blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.enderman, (BlockSnapshot)new BlockSnapshot((IWorld)iworld, blockpos, blockstate1), (Direction)Direction.UP)) {
                iworld.func_180501_a(blockpos, blockstate2, 3);
                this.enderman.func_195406_b(null);
            }
        }

        private boolean func_220836_a(IWorldReader p_220836_1_, BlockPos p_220836_2_, BlockState p_220836_3_, BlockState p_220836_4_, BlockState p_220836_5_, BlockPos p_220836_6_) {
            return p_220836_4_.isAir((IBlockReader)p_220836_1_, p_220836_2_) && !p_220836_5_.isAir((IBlockReader)p_220836_1_, p_220836_6_) && p_220836_5_.func_224756_o((IBlockReader)p_220836_1_, p_220836_6_) && p_220836_3_.func_196955_c(p_220836_1_, p_220836_2_);
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final EnderminiEntity enderman;
        private PlayerEntity player;
        private int aggroTime;
        private int teleportTime;
        private final EntityPredicate field_220791_m;
        private final EntityPredicate field_220792_n = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(EnderminiEntity p_i45842_1_) {
            super((MobEntity)p_i45842_1_, PlayerEntity.class, false);
            this.enderman = p_i45842_1_;
            this.field_220791_m = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> p_i45842_1_.shouldAttackPlayer((PlayerEntity)p_220790_1_));
        }

        public boolean func_75250_a() {
            this.player = this.enderman.field_70170_p.func_217370_a(this.field_220791_m, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.enderman.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.enderman.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.field_220792_n.func_221015_a((LivingEntity)this.enderman, this.field_75309_a) || super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.enderman.func_184218_aH()) {
                    if (this.enderman.shouldAttackPlayer((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)this.enderman) < 16.0) {
                            this.enderman.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportToEntity((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

