/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity.ai;

import epicsquid.mysticalworld.entity.SilkwormEntity;
import epicsquid.mysticalworld.events.LeafHandler;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.AxisAlignedBB;

public class TargetLeavesGoal
extends Goal {
    protected final SilkwormEntity taskOwner;
    protected boolean shouldCheckSight;
    private int targetUnseenTicks;
    protected ItemEntity target;
    protected int unseenMemoryTicks;
    private final int targetChance;
    private final Predicate<ItemEntity> targetEntitySelector;

    public TargetLeavesGoal(SilkwormEntity creature) {
        this.targetChance = 1;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE));
        this.targetEntitySelector = item -> LeafHandler.getLeafItems().contains(item.func_92059_d().func_77973_b());
        this.unseenMemoryTicks = 60;
        this.taskOwner = creature;
        this.shouldCheckSight = false;
    }

    public boolean func_75253_b() {
        ItemEntity leaf = this.taskOwner.getLeafTarget();
        if (leaf == null) {
            leaf = this.target;
        }
        if (leaf == null) {
            return false;
        }
        if (!leaf.func_70089_S()) {
            return false;
        }
        Team team = this.taskOwner.func_96124_cp();
        Team team1 = leaf.func_96124_cp();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getTargetDistance();
        if (this.taskOwner.func_70068_e((Entity)leaf) > d0 * d0) {
            return false;
        }
        if (this.shouldCheckSight) {
            if (this.taskOwner.func_70635_at().func_75522_a((Entity)leaf)) {
                this.targetUnseenTicks = 0;
            } else if (++this.targetUnseenTicks > this.unseenMemoryTicks) {
                return false;
            }
        }
        this.taskOwner.setLeafTarget(leaf);
        return true;
    }

    private double getTargetDistance() {
        IAttributeInstance iattributeinstance = this.taskOwner.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }

    public void func_75251_c() {
        this.taskOwner.setLeafTarget(null);
        this.target = null;
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.taskOwner.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        List list = this.taskOwner.field_70170_p.func_175647_a(ItemEntity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        list.sort((p_compare_1_, p_compare_2_) -> {
            double d1;
            double d0 = this.taskOwner.func_70068_e((Entity)p_compare_1_);
            if (d0 < (d1 = this.taskOwner.func_70068_e((Entity)p_compare_2_))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        });
        this.target = (ItemEntity)list.get(0);
        return true;
    }

    private AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.taskOwner.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.taskOwner.setLeafTarget(this.target);
        this.targetUnseenTicks = 0;
        super.func_75249_e();
    }
}

