/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity.model;

import epicsquid.mysticalworld.entity.OwlEntity;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OwlModel
extends EntityModel<OwlEntity> {
    private final RendererModel body;
    private final RendererModel footR;
    private final RendererModel footL;
    private final RendererModel wingR1;
    private final RendererModel wingR2;
    private final RendererModel wingL1;
    private final RendererModel wingL2;
    private final RendererModel tail;
    private final RendererModel head;
    private final RendererModel tuftR;
    private final RendererModel tuftL;
    private State state = State.STANDING;

    public OwlModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new RendererModel((Model)this);
        this.body.func_78793_a(0.0f, 24.0f, 0.0f);
        this.body.field_78804_l.add(new ModelBox(this.body, 0, 0, -4.0f, -13.0f, -4.0f, 8, 9, 8, 0.0f, false));
        this.footR = new RendererModel((Model)this);
        this.footR.func_78793_a(-1.5f, -4.0f, -0.5f);
        this.body.func_78792_a(this.footR);
        this.footR.field_78804_l.add(new ModelBox(this.footR, 0, 43, -1.5f, 0.0f, -1.5f, 3, 2, 3, 0.0f, false));
        this.footR.field_78804_l.add(new ModelBox(this.footR, 26, 48, -1.0f, 2.0f, 0.5f, 2, 2, 0, 0.0f, false));
        this.footR.field_78804_l.add(new ModelBox(this.footR, 0, 48, -1.0f, 4.0f, -1.5f, 2, 0, 2, 0.0f, false));
        this.footL = new RendererModel((Model)this);
        this.footL.func_78793_a(1.5f, -4.0f, -0.5f);
        this.body.func_78792_a(this.footL);
        this.footL.field_78804_l.add(new ModelBox(this.footL, 12, 43, -1.5f, 0.0f, -1.5f, 3, 2, 3, 0.0f, false));
        this.footL.field_78804_l.add(new ModelBox(this.footL, 22, 48, -1.0f, 2.0f, 0.5f, 2, 2, 0, 0.0f, false));
        this.footL.field_78804_l.add(new ModelBox(this.footL, 8, 48, -1.0f, 4.0f, -1.5f, 2, 0, 2, 0.0f, false));
        this.wingR1 = new RendererModel((Model)this);
        this.wingR1.func_78793_a(-4.0f, -13.0f, -1.0f);
        this.body.func_78792_a(this.wingR1);
        this.wingR1.field_78804_l.add(new ModelBox(this.wingR1, 16, 17, -1.0f, 0.0f, -2.0f, 1, 7, 7, 0.0f, false));
        this.wingR2 = new RendererModel((Model)this);
        this.wingR2.func_78793_a(-1.0f, 7.0f, -2.0f);
        this.setRotationAngle(this.wingR2, 0.1745f, 0.0349f, -0.1745f);
        this.wingR1.func_78792_a(this.wingR2);
        this.wingR2.field_78804_l.add(new ModelBox(this.wingR2, 14, 31, -0.0f, 0.0f, 0.0f, 1, 6, 6, 0.0f, false));
        this.wingL1 = new RendererModel((Model)this);
        this.wingL1.func_78793_a(4.0f, -13.0f, -1.0f);
        this.body.func_78792_a(this.wingL1);
        this.wingL1.field_78804_l.add(new ModelBox(this.wingL1, 0, 17, 0.0f, 0.0f, -2.0f, 1, 7, 7, 0.0f, false));
        this.wingL2 = new RendererModel((Model)this);
        this.wingL2.func_78793_a(1.0f, 7.0f, -2.0f);
        this.setRotationAngle(this.wingL2, 0.1745f, -0.0349f, 0.1745f);
        this.wingL1.func_78792_a(this.wingL2);
        this.wingL2.field_78804_l.add(new ModelBox(this.wingL2, 0, 31, -1.0f, 0.0f, 0.0f, 1, 6, 6, 0.0f, false));
        this.tail = new RendererModel((Model)this);
        this.tail.func_78793_a(0.0f, -5.0f, 4.0f);
        this.setRotationAngle(this.tail, 0.5236f, 0.0f, 0.0f);
        this.body.func_78792_a(this.tail);
        this.tail.field_78804_l.add(new ModelBox(this.tail, 28, 31, -3.0f, 0.0f, -2.0f, 6, 4, 2, 0.0f, false));
        this.head = new RendererModel((Model)this);
        this.head.func_78793_a(0.0f, -13.0f, 0.0f);
        this.body.func_78792_a(this.head);
        this.head.field_78804_l.add(new ModelBox(this.head, 32, 0, -3.5f, -6.0f, -3.5f, 7, 6, 7, 0.0f, false));
        this.head.field_78804_l.add(new ModelBox(this.head, 16, 48, -1.0f, -3.0f, -4.5f, 2, 2, 1, 0.0f, false));
        this.tuftR = new RendererModel((Model)this);
        this.tuftR.func_78793_a(-2.0f, -6.0f, -3.0f);
        this.setRotationAngle(this.tuftR, 0.4363f, -0.3491f, 0.0f);
        this.head.func_78792_a(this.tuftR);
        this.tuftR.field_78804_l.add(new ModelBox(this.tuftR, 24, 43, -2.0f, 0.0f, 0.0f, 2, 0, 4, 0.0f, false));
        this.tuftL = new RendererModel((Model)this);
        this.tuftL.func_78793_a(2.0f, -6.0f, -3.0f);
        this.setRotationAngle(this.tuftL, 0.4363f, 0.3491f, 0.0f);
        this.head.func_78792_a(this.tuftL);
        this.tuftL.field_78804_l.add(new ModelBox(this.tuftL, 36, 43, 0.0f, 0.0f, 0.0f, 2, 0, 4, 0.0f, false));
    }

    public void render(OwlEntity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.body.func_78785_a(f5);
    }

    public void setRotationAngles(OwlEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78808_h = 0.0f;
        boolean hootfire = false;
        if (entityIn.func_145818_k_() && entityIn.func_200201_e() != null && entityIn.func_200201_e().getString().equals("Hootfire")) {
            hootfire = true;
        }
        if (this.state == State.FLYING && !hootfire) {
            this.setRotationAngle(this.body, 0.45f, 0.0f, 0.0f);
            this.setRotationAngle(this.footR, 0.25f, 0.0f, 0.0f);
            this.setRotationAngle(this.footL, 0.25f, 0.0f, 0.0f);
            this.setRotationAngle(this.tail, 0.15f, 0.0f, 0.0f);
            this.setRotationAngle(this.head, -0.3f, 0.0f, 0.0f);
            float wingR_rotation = -(0.65f * (float)Math.sin(ageInTicks) - 1.625f);
            float wingL_rotation = 0.65f * (float)Math.sin(ageInTicks) - 1.625f;
            this.setRotationAngle(this.wingR1, 0.45f, 0.0f, wingR_rotation);
            this.setRotationAngle(this.wingL1, 0.45f, 0.0f, wingL_rotation);
            this.setRotationAngle(this.wingR2, 0.45f, 0.0f, 0.05f * wingR_rotation);
            this.setRotationAngle(this.wingL2, 0.45f, 0.0f, 0.05f * wingL_rotation);
        } else {
            this.setRotationAngle(this.body, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.footR, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.footL, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.tail, 0.5236f, 0.0f, 0.0f);
            this.setRotationAngle(this.head, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.wingR1, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.wingR2, 0.1745f, 0.0349f, -0.1745f);
            this.setRotationAngle(this.wingL1, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.wingL2, 0.1745f, -0.0349f, 0.1745f);
        }
    }

    public void setLivingAnimations(OwlEntity owl, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.state = owl.isFlying() ? State.FLYING : State.STANDING;
    }

    public void setRotationAngle(RendererModel modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum State {
        FLYING,
        STANDING,
        SITTING;

    }
}

