/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity.player;

import com.mojang.blaze3d.platform.GlStateManager;
import epicsquid.mysticalworld.api.Capabilities;
import epicsquid.mysticalworld.entity.model.BeetleModel;
import epicsquid.mysticalworld.entity.model.ShoulderRidingModel;
import epicsquid.mysticalworld.init.ModEntities;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShoulderLayer<T extends PlayerEntity>
extends LayerRenderer<T, PlayerModel<T>> {
    private final Map<EntityType<?>, ShoulderRidingModel<?>> MODEL_MAP = new HashMap();

    public ShoulderLayer(IEntityRenderer<T, PlayerModel<T>> player) {
        super(player);
    }

    @Nullable
    public ShoulderRidingModel<?> getModelFor(EntityType<?> type) {
        return this.MODEL_MAP.computeIfAbsent(type, e -> {
            if (e == ModEntities.BEETLE.get()) {
                return new BeetleModel();
            }
            return null;
        });
    }

    public void render(T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scaleIn) {
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityIn.getCapability(Capabilities.SHOULDER_CAPABILITY).ifPresent(cap -> {
            EntityType<?> type = cap.getEntityType();
            ShoulderRidingModel<?> model = this.getModelFor(type);
            if (model != null) {
                this.renderModel(entityIn, limbSwing, limbSwingAmount, partialTicks, netHeadYaw, headPitch, scaleIn, model);
            }
        });
        GlStateManager.disableRescaleNormal();
    }

    private void renderModel(T player, float limbSwing, float limbSwingAmount, float partialTicks, float netHeadYaw, float headPitch, float scaleIn, ShoulderRidingModel<?> model) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.375f, (float)(player.func_213287_bg() ? -0.3f : -0.5f), (float)0.0f);
        GlStateManager.scalef((float)0.35f, (float)0.35f, (float)0.35f);
        this.func_215333_a(model.getTexture());
        model.renderOnShoulder(limbSwing, limbSwingAmount, netHeadYaw, headPitch, scaleIn, ((PlayerEntity)player).field_70173_aa);
        GlStateManager.popMatrix();
    }

    public boolean func_177142_b() {
        return false;
    }
}

