/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity.render;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import epicsquid.mysticalworld.entity.EnderminiEntity;
import epicsquid.mysticalworld.entity.model.EnderminiModel;
import epicsquid.mysticalworld.entity.model.ModelHolder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EnderminiRenderer
extends MobRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> {
    private static final ResourceLocation ENDERMINI_TEXTURES = new ResourceLocation("mysticalworld", "textures/entity/endermini.png");
    private final Random rnd = new Random();

    public EnderminiRenderer(EntityRendererManager renderManagerIn, EnderminiModel<EnderminiEntity> model, float size) {
        super(renderManagerIn, model, size);
        this.func_177094_a(new EnderminiEyesLayer(this));
        this.func_177094_a(new HeldBlockLayer((IEntityRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>>)this));
    }

    protected void renderModel(EnderminiEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        GlStateManager.pushMatrix();
        GlStateManager.scaled((double)0.4, (double)0.4, (double)0.4);
        GlStateManager.translated((double)0.0, (double)2.2, (double)0.0);
        super.func_77036_a((LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        GlStateManager.popMatrix();
    }

    public void doRender(EnderminiEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        BlockState blockstate = entity.getHeldBlockState();
        EnderminiModel<EnderminiEntity> endermanmodel = this.getEntityModel();
        endermanmodel.field_78126_a = blockstate != null;
        endermanmodel.field_78125_b = entity.isScreaming();
        if (entity.isScreaming()) {
            double d0 = 0.02;
            x += this.rnd.nextGaussian() * 0.02;
            z += this.rnd.nextGaussian() * 0.02;
        }
        super.func_76986_a((MobEntity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EnderminiEntity entity) {
        return ENDERMINI_TEXTURES;
    }

    public EnderminiModel<EnderminiEntity> getEntityModel() {
        return ModelHolder.enderminiModel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EnderminiEyesLayer<T extends LivingEntity>
    extends LayerRenderer<T, EnderminiModel<T>> {
        private static final ResourceLocation RES_ENDERMAN_EYES = new ResourceLocation("textures/entity/enderman/enderman_eyes.png");

        public EnderminiEyesLayer(IEntityRenderer<T, EnderminiModel<T>> p_i50939_1_) {
            super(p_i50939_1_);
        }

        public void render(T entityIn, float p_212842_2_, float p_212842_3_, float p_212842_4_, float p_212842_5_, float p_212842_6_, float p_212842_7_, float p_212842_8_) {
            this.func_215333_a(RES_ENDERMAN_EYES);
            GlStateManager.pushMatrix();
            GlStateManager.scaled((double)0.4, (double)0.4, (double)0.4);
            GlStateManager.translated((double)0.0, (double)2.2, (double)0.0);
            GlStateManager.enableBlend();
            GlStateManager.disableAlphaTest();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.disableLighting();
            GlStateManager.depthMask((!entityIn.func_82150_aj() ? 1 : 0) != 0);
            int i = 61680;
            int j = 61680;
            boolean k = false;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)61680.0f, (float)0.0f);
            GlStateManager.enableLighting();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GameRenderer gamerenderer = Minecraft.func_71410_x().field_71460_t;
            gamerenderer.func_191514_d(true);
            ((EnderminiModel)this.func_215332_c()).func_78088_a((LivingEntity)entityIn, p_212842_2_, p_212842_3_, p_212842_5_, p_212842_6_, p_212842_7_, p_212842_8_);
            gamerenderer.func_191514_d(false);
            this.func_215334_a((Entity)entityIn);
            GlStateManager.depthMask((boolean)true);
            GlStateManager.disableBlend();
            GlStateManager.enableAlphaTest();
            GlStateManager.popMatrix();
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class HeldBlockLayer
    extends LayerRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> {
        public HeldBlockLayer(IEntityRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> p_i50949_1_) {
            super(p_i50949_1_);
        }

        public void render(EnderminiEntity entityIn, float p_212842_2_, float p_212842_3_, float p_212842_4_, float p_212842_5_, float p_212842_6_, float p_212842_7_, float p_212842_8_) {
            BlockState blockstate = entityIn.getHeldBlockState();
            if (blockstate != null) {
                GlStateManager.pushMatrix();
                GlStateManager.scaled((double)0.4, (double)0.4, (double)0.4);
                GlStateManager.translated((double)0.0, (double)2.2, (double)0.0);
                GlStateManager.enableRescaleNormal();
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)0.0f, (float)0.6875f, (float)-0.75f);
                GlStateManager.rotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)0.25f, (float)0.1875f, (float)0.25f);
                float f = 0.5f;
                GlStateManager.scalef((float)-0.5f, (float)-0.5f, (float)0.5f);
                int i = entityIn.func_70070_b();
                int j = i % 65536;
                int k = i / 65536;
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_215333_a(AtlasTexture.field_110575_b);
                Minecraft.func_71410_x().func_175602_ab().func_175016_a(blockstate, 1.0f);
                GlStateManager.popMatrix();
                GlStateManager.disableRescaleNormal();
                GlStateManager.popMatrix();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    public static class Factory
    implements IRenderFactory<EnderminiEntity> {
        public EntityRenderer<? super EnderminiEntity> createRenderFor(EntityRendererManager manager) {
            return new EnderminiRenderer(manager, ModelHolder.enderminiModel, 0.35f);
        }
    }
}

