/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.events;

import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.api.Capabilities;
import epicsquid.mysticalworld.api.IPlayerShoulderCapability;
import epicsquid.mysticalworld.capability.PlayerShoulderCapability;
import epicsquid.mysticalworld.network.Networking;
import epicsquid.mysticalworld.network.ShoulderRide;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ShoulderHandler {
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        if (!world.func_175623_d(event.getPos().func_177984_a())) {
            return;
        }
        BlockPos pos = event.getPos().func_177984_a();
        if (!world.field_72995_K && event.getHand() == Hand.MAIN_HAND && player.func_70093_af() && player.func_184614_ca().func_190926_b()) {
            Entity animal;
            EntityType type;
            IPlayerShoulderCapability cap;
            if (!world.func_180495_p(pos).isAir((IBlockReader)world, pos)) {
                return;
            }
            LazyOptional laycap = player.getCapability(Capabilities.SHOULDER_CAPABILITY);
            if (laycap.isPresent() && (cap = (IPlayerShoulderCapability)laycap.orElseThrow(IllegalStateException::new)).isShouldered() && (type = (EntityType)ForgeRegistries.ENTITIES.getValue(cap.getRegistryName())) != null && (animal = type.func_200721_a(world)) != null) {
                animal.func_70020_e(cap.getAnimalSerialized());
                animal.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5);
                world.func_217376_c(animal);
                player.func_184609_a(Hand.MAIN_HAND);
                cap.drop();
                try {
                    PlayerShoulderCapability.setLeftShoulder.invokeExact(player, new CompoundNBT());
                }
                catch (Throwable throwable) {
                    MysticalWorld.LOG.error("Unable to unset player having a shoulder entity", throwable);
                }
                event.setCanceled(true);
                ShoulderRide message = new ShoulderRide(player, cap);
                Networking.send(PacketDistributor.ALL.noArg(), message);
            }
        }
    }

    public static void onDeath(LivingDeathEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living instanceof PlayerEntity) {
            Entity animal;
            EntityType type;
            IPlayerShoulderCapability cap;
            PlayerEntity player = (PlayerEntity)living;
            World world = player.field_70170_p;
            LazyOptional laycap = player.getCapability(Capabilities.SHOULDER_CAPABILITY, null);
            if (laycap.isPresent() && (cap = (IPlayerShoulderCapability)laycap.orElseThrow(IllegalStateException::new)).isShouldered() && (type = (EntityType)ForgeRegistries.ENTITIES.getValue(cap.getRegistryName())) != null && (animal = type.func_200721_a(world)) != null) {
                animal.func_70020_e(cap.getAnimalSerialized());
                BlockPos pos = player.func_180425_c();
                animal.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
                world.func_217376_c(animal);
                player.func_184609_a(Hand.MAIN_HAND);
                cap.drop();
                try {
                    PlayerShoulderCapability.setLeftShoulder.invokeExact(player, new CompoundNBT());
                }
                catch (Throwable throwable) {
                    MysticalWorld.LOG.error("Unable to unset player having a shoulder entity", throwable);
                }
                ShoulderRide message = new ShoulderRide(player, cap);
                Networking.send(PacketDistributor.ALL.noArg(), message);
            }
        }
    }
}

